#!/bin/env ruby

require 'csv'
require 'json'

options = { converters: :numeric, headers: true }
outputFilename = './data.json'

data = []

['Americas', 'Asia-Pacific', 'Europe'].each do | region |
  input = "./standings_#{region.downcase}.csv"
  CSV.foreach(input, options) do |row|
    temp = row.to_hash
    temp['Region'] = region
    data << temp
  end
end

File.new(outputFilename, 'w').write(data.to_json)
