package cmd

import (
	"strconv"

	"code.justin.tv/event-engineering/OBSConfig/pkg/attr"
	"code.justin.tv/event-engineering/OBSConfig/pkg/flags"
	"code.justin.tv/event-engineering/OBSConfig/pkg/obs"
	"code.justin.tv/event-engineering/OBSConfig/pkg/writer"
)

func Cli() {

	writer.WriteEncoderFile("output/streamEncoder.json", attr.StreamEnc)
	writer.WriteServiceFile("output/service.json", attr.ServerJson)

	obs.WriteBasicFile(obs.OBSIni{
		Name:      *flags.NamePtr,
		Mode:      "Advanced",
		BaseCX:    strconv.Itoa(*flags.CXPtr),
		BaseCY:    strconv.Itoa(*flags.CYPtr),
		OutputCX:  strconv.Itoa(*flags.CXPtr),
		OutputCY:  strconv.Itoa(*flags.CYPtr),
		FPSCommon: strconv.Itoa(*flags.FpsPtr),
	}, "output/basic.ini")
}

/*
-bitrate 6000 -keyint 2 -preset medium -ingest rtmp://twitch.tv/app -streamkey live_tetegen -type rtmp_custom -name TwitchTest -fps 60 -cx 1920 -cy 1080
*/
