package cli

import (
	"strconv"

	"code.justin.tv/event-engineering/OBSConfig/attr"
	"code.justin.tv/event-engineering/OBSConfig/flags"
	"code.justin.tv/event-engineering/OBSConfig/obs"
	"code.justin.tv/event-engineering/OBSConfig/writer"
)

func Cli() {

	writer.WriteEncoderFile("output/streamEncoder.json", attr.StreamEnc)
	writer.WriteServiceFile("output/service.json", attr.ServerJson)

	obs.WriteBasicFile(obs.OBSIni{
		Name:      *flags.NamePtr,
		Mode:      "Advanced",
		BaseCX:    strconv.Itoa(*flags.CXPtr),
		BaseCY:    strconv.Itoa(*flags.CYPtr),
		OutputCX:  strconv.Itoa(*flags.CXPtr),
		OutputCY:  strconv.Itoa(*flags.CYPtr),
		FPSCommon: strconv.Itoa(*flags.FpsPtr),
	}, "output/basic.ini")
}
