package obs

import "github.com/go-ini/ini"

type OBSIni struct {
	Name      string
	Mode      string
	BaseCX    string
	BaseCY    string
	OutputCX  string
	OutputCY  string
	FPSCommon string
}

func WriteBasicFile(iniSettings OBSIni, filename string) {
	cfg := ini.Empty()

	sctInput1 := cfg.Section("")
	sctInput1.NewKey("Name", iniSettings.Name)

	sctInput2 := cfg.Section("Output")
	sctInput2.NewKey("Mode", iniSettings.Mode)

	sctInput3 := cfg.Section("Video")
	sctInput3.NewKey("BaseCX", iniSettings.BaseCX)
	sctInput3.NewKey("BaseCY", iniSettings.BaseCY)
	sctInput3.NewKey("OutputCX", iniSettings.OutputCX)
	sctInput3.NewKey("OutputCY", iniSettings.OutputCY)
	sctInput3.NewKey("FPSCommon", iniSettings.FPSCommon)

	cfg.SaveTo(filename)

}
