// Writer Package is for the encoding of the JSON file to output.

package writer

import (
	"encoding/json"
	"os"

	"code.justin.tv/event-engineering/OBSConfig/pkg/obs"
)

func WriteEncoderFile(filename string, encoderConfig obs.StreamEncoderJson) {
	// Json writer for streamEncoder.json
	writer, _ := os.Create(filename)
	_ = json.NewEncoder(writer).Encode(
		encoderConfig)
	writer.Close()

}

func WriteServiceFile(filename string, serverJson obs.ServerJson) {
	// Json writer for service.json
	writer, _ := os.Create(filename)
	_ = json.NewEncoder(writer).Encode(
		serverJson)
	writer.Close()

}
