package main

import (
	"code.justin.tv/event-engineering/acm-ca-go/pkg/certgen"
	"crypto/tls"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/credentials"
	"github.com/aws/aws-sdk-go/aws/session"
	"log"
	"net/http"
)

type handler struct{}

func main() {

	region := "us-west-2"

	sess := session.New(&aws.Config{
		Region: &region,
		Credentials: credentials.NewCredentials(&credentials.SharedCredentialsProvider{
			Profile: "irl-privca-test",
		}),
	})

	generator := certgen.New(sess, "arn:aws:acm-pca:us-west-2:450786683468:certificate-authority/040eaf4b-b770-4974-99ea-591d43064c02")

	cert, err := generator.CanHazCert("ip-172-23-133-239.us-west-2.compute.internal", nil)
	if err != nil {
		panic(err)
	}

	log.Println("Haz cert, woop! starting server")

	config := &tls.Config{Certificates: []tls.Certificate{cert}}
	ln, err := tls.Listen("tcp", ":443", config)
	if err != nil {
		log.Println(err)
		return
	}
	defer ln.Close()

	handler := &handler{}

	http.Serve(ln, handler)
}

func (th *handler) ServeHTTP(w http.ResponseWriter, r *http.Request) {
	w.Header().Set("Content-Type", "text/plain")
	w.Write([]byte("This is an example server.\n"))
}
