package aws

import (
	"code.justin.tv/event-engineering/acm-ca-go/pkg/aws/backend"
	"github.com/aws/aws-sdk-go/service/acm"
	"github.com/aws/aws-sdk-go/service/acmpca"
)

// New generates a new AWS Client with the supplied backend client
func New(awsClient backend.Client) *Client {
	return &Client{
		aws: awsClient,
	}
}

// Client is an AWS client containing methods for use in the acm-ca-go package
type Client struct {
	aws backend.Client
}

// ACMRequestCertificate calls the underlying ACMRequestCertificate from the aws backend
func (c *Client) ACMRequestCertificate(input *acm.RequestCertificateInput) (*acm.RequestCertificateOutput, error) {
	return c.aws.ACMRequestCertificate(input)
}

// ACMListCertificates calls the underlying ACMListCertificates from the aws backend
func (c *Client) ACMListCertificates(input *acm.ListCertificatesInput) (*acm.ListCertificatesOutput, error) {
	return c.aws.ACMListCertificates(input)
}

// ACMDescribeCertificate calls the underlying ACMDescribeCertificate from the aws backend
func (c *Client) ACMDescribeCertificate(input *acm.DescribeCertificateInput) (*acm.DescribeCertificateOutput, error) {
	return c.aws.ACMDescribeCertificate(input)
}

// ACMExportCertificate calls the underlying ACMExportCertificate from the aws backend
func (c *Client) ACMExportCertificate(input *acm.ExportCertificateInput) (*acm.ExportCertificateOutput, error) {
	return c.aws.ACMExportCertificate(input)
}

// ACMPCAGetCertificateAuthorityCertificate calls the underlying ACMPCAGetCertificateAuthorityCertificate from the aws backend
func (c *Client) ACMPCAGetCertificateAuthorityCertificate(input *acmpca.GetCertificateAuthorityCertificateInput) (*acmpca.GetCertificateAuthorityCertificateOutput, error) {
	return c.aws.ACMPCAGetCertificateAuthorityCertificate(input)
}
