provider "aws" {
    region = "${local.region}" 
}

/*resource "aws_instance" "test" {
		ami =        "ami-0330fc29bf4fcadc7"
		instance_type =     "t2.micro"
		key_name =         "shalke"
		vpc_security_group_ids = ["sg-d15051bc"]
		subnet_id =         "subnet-bfed9ff2"
        user_data = "${data.template_file.startupscript.rendered}"
        iam_instance_profile = "${aws_iam_instance_profile.profile.name}"
        }
*/

locals {
    env = "development"
    service = "cpu-performance"
    owner = "eduard@twitch.tv"

    region = "eu-central-1"
}

resource "aws_s3_bucket" "bucket" {
    bucket = "twitch-shalke-${local.env}-cpuperformance"

    tags {
        Name = "cpu-perf-output"
        Service = "${local.service}"
        Owner = "${local.owner}"
        Environment = "${local.env}"
    }
}

resource "aws_s3_bucket_policy" "bucket_ee" {
    bucket = "${aws_s3_bucket.bucket.id}"
    policy = "${data.aws_iam_policy_document.bucket_ee.json}"
}

data "template_file" "startupscript" {
    template = "${file("startupscript.sh.tpl")}"
    vars {
        bucket_name = "${aws_s3_bucket.bucket.id}"
        bucket_region = "${aws_s3_bucket.bucket.region}"

    }
}

resource "aws_iam_role" "role" {
  name               = "cpuperformance-${local.env}"
  assume_role_policy = "${data.aws_iam_policy_document.assume.json}"
}

data "aws_iam_policy_document" "assume" {
  statement {
    actions = ["sts:AssumeRole"]

    principals {
      type        = "Service"
      identifiers = ["ec2.amazonaws.com"]
    }
  }
}

resource "aws_iam_role_policy" "role_policy" {
  name   = "cpuperformance-${local.env}-policy"
  role   = "cpuperformance-${local.env}"
  policy = "${data.aws_iam_policy_document.policy.json}"
}

data "aws_iam_policy_document" "policy" {
  statement {
    actions = [
      "s3:ListBucket",
      "s3:GetObject",
      "s3:PutObject",
    ]

    resources = [
      "arn:aws:s3:::${aws_s3_bucket.bucket.id}",
      "arn:aws:s3:::${aws_s3_bucket.bucket.id}/*",
    ]
  }
}

data "aws_iam_policy_document" "bucket_ee" {
  statement {
    actions = [
      "s3:*",
    ]

    resources = [
      "arn:aws:s3:::${aws_s3_bucket.bucket.id}",
      "arn:aws:s3:::${aws_s3_bucket.bucket.id}/*",
    ]

    principals {
        type = "AWS"
        identifiers = ["arn:aws:iam::078911238551:root"]
    }
  }
}

resource "aws_iam_instance_profile" "profile" {
  name = "cpuperformance-${local.env}-profile"
  role = "${aws_iam_role.role.name}"
}

output "config" {
    value = "${jsonencode(local.output_config)}"
}
locals {
    output_config = {
        aws_region = "${local.region}"
        run_instance_config = {
            ImageId = "ami-0330fc29bf4fcadc7"
            KeyName = "shalke"
            SecurityGroupIds = ["sg-d15051bc"]
            SubnetId = "subnet-bfed9ff2"
            IamInstanceProfile = {
                Name = "${aws_iam_instance_profile.profile.name}"
            }
            InstanceInitiatedShutdownBehavior = "terminate"
            UserData = "${base64encode(data.template_file.startupscript.rendered)}"
            TagSpecifications = [
                {
                    ResourceType = "instance"
                    Tags = [
                        {
                            Key = "Owner"
                            Value = "${local.owner}"
                        },
                        {
                            Key = "Service"
                            Value = "${local.service}"
                        }
                    ]
                }
            ]
        }
    }
}