#!/bin/bash
set -eu

cd /tmp/
mkdir output

cat /proc/cpuinfo > output/cpuinfo
dmidecode --type 17 > output/ram

ffmpeg -i /home/ubuntu/MERGED-1080p60-X264-MPEGTS.ts -s 1920x1080 -preset veryfast -vcodec libx264 -x264opts bitrate=5500:nal-hrd=cbr -c:a aac -strict 2 -pix_fmt yuv420p -maxrate 5500k -bufsize 5500k  -f flv output.flv > output/ffmpeg_output.log 2>&1

cat "$0" > output/script

meta() {
  curl --fail --silent --show-error "http://169.254.169.254/latest/meta-data/$1"
}

instance_id=$(meta instance-id)
instance_type=$(meta instance-type)
date=$(date -u "+%Y-%m-%d-%H:%M:%S")

tar cf output.tar output
aws --region ${bucket_region} s3 cp output.tar "s3://${bucket_name}/$date-$instance_type-$instance_id.tar"

halt