#!/usr/bin/env node
import 'source-map-support/register';
import * as cdk from '@aws-cdk/core';
import { CarrotAnalyticsVpcStack } from '../lib/carrot-analytics-vpc-stack';
import { CarrotAnalyticsStack } from '../lib/carrot-analytics-stack';

const app = new cdk.App();

const prodVpcStack = new CarrotAnalyticsVpcStack(app, 'carrot-analytics-vpc-prod', {
  cdkProps: {
    env: {
      region: 'us-west-2',
      account: '291428775132',
    },
    terminationProtection: true,
  },
  cidr: '172.22.0.0/16',
  jumpboxProps: {
    keyPairName: 'carrot-analytics-prod',
  }
});

// We don't have a staging redshift cluster, but it makes sense to have a staging application
// So all this really does is separate some concerns but it will still run on the prod cluster
new CarrotAnalyticsStack(app, 'carrot-analytics-stg', {
  cdkProps: {
    env: {
      region: 'us-west-2',
      account: '291428775132',
    },
  },
  vpc: prodVpcStack.Vpc,
  carrotAnalyticsProps: {
    redshiftAddr: 'carrot-analytics-prod.c0ytm2ke3rsj.us-west-2.redshift.amazonaws.com:5439',
    redshiftUser: 'carrot-analysis-prod-query',
    redshiftDatabase: 'product',
    // Pasword is stored in SSM under /carrot-analytics/redshiftPass
    redshitPassParameterArn: 'arn:aws:ssm:us-west-2:291428775132:parameter/carrot-analytics/redshiftPass',
    invokeFunctionRoles: [
      'arn:aws:iam::134277936734:role/carrot-control-stg-CarrotControlServiceRole38F61F3-CUOBT9HTOPF4', // Carrot Control Staging
    ],
  },
});

new CarrotAnalyticsStack(app, 'carrot-analytics-prod', {
  cdkProps: {
    env: {
      region: 'us-west-2',
      account: '291428775132',
    },
    terminationProtection: true,
  },
  vpc: prodVpcStack.Vpc,
  carrotAnalyticsProps: {
    redshiftAddr: 'carrot-analytics-prod.c0ytm2ke3rsj.us-west-2.redshift.amazonaws.com:5439',
    redshiftUser: 'carrot-analysis-prod-query',
    redshiftDatabase: 'product',
    // Pasword is stored in SSM under /carrot-analytics/redshiftPass
    redshitPassParameterArn: 'arn:aws:ssm:us-west-2:291428775132:parameter/carrot-analytics/redshiftPass',
    invokeFunctionRoles: [
      'arn:aws:iam::782947612856:role/carrot-control-prod-CarrotControlServiceRole38F61F-1IQPIF0KPHJF9' // Carrot Control Production
    ],
  },
});
