import * as cdk from '@aws-cdk/core';
import * as ec2 from '@aws-cdk/aws-ec2';

import { CarrotAnalytics, CarrotAnalyticsProps } from './carrot-analytics/carrot-analytics'

export interface CarrotAnalyticsStackProps {
  cdkProps: cdk.StackProps;
  carrotAnalyticsProps: CarrotAnalyticsProps;
  vpc: ec2.IVpc
}

export class CarrotAnalyticsStack extends cdk.Stack {
  constructor(scope: cdk.Construct, id: string, props: CarrotAnalyticsStackProps) {
    super(scope, id, props.cdkProps);

    new CarrotAnalytics(this, 'CarrotAnalytics', props.vpc, props.carrotAnalyticsProps)
  }
}
