import * as cdk from '@aws-cdk/core';
import * as ec2 from '@aws-cdk/aws-ec2';

import { CarrotAnalyticsJumpbox, CarrotAnalyticsJumpboxProps } from './carrot-analytics-jumpbox/carrot-analytics-jumpbox'

export interface CarrotAnalyticsVpcProps {
  cdkProps: cdk.StackProps;
  jumpboxProps: CarrotAnalyticsJumpboxProps;
  cidr: string
}

export class CarrotAnalyticsVpcStack extends cdk.Stack {
  Vpc: ec2.Vpc;

  constructor(scope: cdk.Construct, id: string, props: CarrotAnalyticsVpcProps) {
    super(scope, id, props.cdkProps);

    // Create the VPC
    this.Vpc = new ec2.Vpc(this, 'CarrotAnalyticsVpc', {
      maxAzs: 3,
      cidr: props.cidr,
    })

    // Add a little jumpbox so we can access things inside the VPC
    new CarrotAnalyticsJumpbox(this, 'CarrotAnalyticsJumpbox', this.Vpc, props.jumpboxProps)
  }
}
