package main

import (
	"bytes"
	"context"
	"encoding/json"
	"flag"
	"fmt"
	"io/ioutil"
	"net/http"
	"os"
	"path"
	"time"

	control "code.justin.tv/event-engineering/carrot-analytics/control/rpc"
	"code.justin.tv/event-engineering/carrot-analytics/control/svc"
	"code.justin.tv/video/amzncorp"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/credentials"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/golang/protobuf/ptypes"
	"github.com/sirupsen/logrus"
)

var (
	awsAccountID = "291428775132" // starfruit-support+analytics-prod@amazon.com
	awsRole      = "Admin"
	awsRegion    = "us-west-2"
)

func init() {
	flag.Parse()
}

func main() {
	logger := logrus.New()
	logger.SetLevel(logrus.DebugLevel)

	credentials, err := midwayCredentials(awsAccountID, awsRole)
	if err != nil {
		panic(err)
	}

	sess := session.New(&aws.Config{
		Credentials: credentials,
		Region:      &awsRegion,
	})

	executorSQSQueueURL := "https://sqs.us-west-2.amazonaws.com/291428775132/carrot-analytics-stg-CarrotAnalyticsCarrotAnalyticsExecutorQueueC4-5BXIQ0VN7SDA"
	queriesTableName := "carrot-analytics-stg-CarrotAnalyticsCarrotAnalyticsQueries56AF22A9-FB4ZAY37GI5J"
	resultsBucketName := "carrot-analytics-stg-carrotanalyticscarrotanalyti-1g6fs9kklkhyh"

	// Create the Service
	controlServer := svc.New(sess, executorSQSQueueURL, queriesTableName, resultsBucketName, logger)

	doQueryList(controlServer)
	//doPlaySessionInfo(controlServer)
}

func doQueryList(client svc.Client) {
	resp, err := client.ListQueries(context.Background(), &control.ListQueriesRequest{
		RequestedBy: "coleiain",
	})

	if err != nil {
		panic(err)
	}

	bytes, _ := json.MarshalIndent(resp, "", "  ")
	fmt.Println(string(bytes))
}

func doPlaySessionInfo(client svc.Client) {
	startDate, err := time.Parse(time.RFC3339, "2020-03-24T00:00:00Z")
	if err != nil {
		panic(err)
	}

	endDate, err := time.Parse(time.RFC3339, "2020-03-27T23:59:00Z")
	if err != nil {
		panic(err)
	}

	playSessionID := "f970108b760743adadb3527ddbbfbb85"

	pStart, err := ptypes.TimestampProto(startDate)
	if err != nil {
		panic(err)
	}

	pEnd, err := ptypes.TimestampProto(endDate)
	if err != nil {
		panic(err)
	}

	// Test your shit
	resp, err := client.EnqueueQuery(context.Background(), &control.EnqueueQueryRequest{
		Query: &control.Query{

			StartDate: pStart,
			EndDate:   pEnd,
			QueryParams: &control.Query_PlaySessionInfoParams{
				PlaySessionInfoParams: &control.PlaySessionInfoParameters{
					PlaySessionId: playSessionID,
				},
			},
		},
	})

	if err != nil {
		panic(err)
	}

	fmt.Println(resp.QueryId)
}

func midwayCredentials(accountID, role string) (*credentials.Credentials, error) {
	midwayClient, err := midwayClient()
	if err != nil {
		return nil, err
	}

	return credentials.NewCredentials(&amzncorp.IsengardCredentials{
		AWSAccountID: accountID,
		IAMRoleName:  role,
		MidwayClient: midwayClient,
	}), nil

}

func midwayClient() (*http.Client, error) {
	cookieFile, err := readCookieFile()
	if err != nil {
		return nil, err
	}
	return amzncorp.MidwayClient(bytes.NewReader(cookieFile))
}

func readCookieFile() ([]byte, error) {
	home, err := os.UserHomeDir()
	if err != nil {
		return nil, err
	}

	f, err := os.Open(path.Join(home, ".midway/cookie"))
	if err != nil {
		return nil, err
	}

	defer f.Close()

	bs, err := ioutil.ReadAll(f)
	if err != nil {
		return nil, err
	}

	return bs, nil
}
