package main

import (
	"fmt"
	"os"

	twirpLambda "code.justin.tv/amzn/TwirpGoLangAWSTransports/lambda"
	rpc "code.justin.tv/event-engineering/carrot-analytics/control/rpc"
	"code.justin.tv/event-engineering/carrot-analytics/control/svc"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/sirupsen/logrus"
)

func main() {
	logger := logrus.New()
	logger.SetLevel(logrus.DebugLevel)

	executorSQSQueueURL := os.Getenv("executorSQSQueueURL")
	queriesTableName := os.Getenv("queriesTableName")
	resultsBucketName := os.Getenv("resultsBucketName")

	// Create am AWS session
	sess, err := session.NewSession(&aws.Config{
		Region: aws.String("us-west-2"),
	})

	if err != nil {
		panic(fmt.Errorf("Error creating AWS session %v", err))
	}

	// Create the Service
	controlService := svc.New(sess, executorSQSQueueURL, queriesTableName, resultsBucketName, logger)

	// Create a Twirp service based off the internal service
	err = twirpLambda.ListenAndServe(":80", rpc.NewCarrotAnalyticsControlServer(controlService, nil))

	if err != nil {
		// TODO logging and metrics
		panic(err)
	}
}
