// Code generated by protoc-gen-twirp v8.1.0, DO NOT EDIT.
// source: control.proto

package rpc

import context "context"
import fmt "fmt"
import http "net/http"
import ioutil "io/ioutil"
import json "encoding/json"
import strconv "strconv"
import strings "strings"

import protojson "google.golang.org/protobuf/encoding/protojson"
import proto "google.golang.org/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

import bytes "bytes"
import errors "errors"
import io "io"
import path "path"
import url "net/url"

// Version compatibility assertion.
// If the constant is not defined in the package, that likely means
// the package needs to be updated to work with this generated code.
// See https://twitchtv.github.io/twirp/docs/version_matrix.html
const _ = twirp.TwirpPackageMinVersion_8_1_0

// ================================
// CarrotAnalyticsControl Interface
// ================================

type CarrotAnalyticsControl interface {
	EnqueueQuery(context.Context, *EnqueueQueryRequest) (*EnqueueQueryResponse, error)

	GetQueryResult(context.Context, *GetQueryResultRequest) (*GetQueryResultResponse, error)

	ListQueries(context.Context, *ListQueriesRequest) (*ListQueriesResponse, error)
}

// ======================================
// CarrotAnalyticsControl Protobuf Client
// ======================================

type carrotAnalyticsControlProtobufClient struct {
	client      HTTPClient
	urls        [3]string
	interceptor twirp.Interceptor
	opts        twirp.ClientOptions
}

// NewCarrotAnalyticsControlProtobufClient creates a Protobuf client that implements the CarrotAnalyticsControl interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewCarrotAnalyticsControlProtobufClient(baseURL string, client HTTPClient, opts ...twirp.ClientOption) CarrotAnalyticsControl {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	// Using ReadOpt allows backwards and forwads compatibility with new options in the future
	literalURLs := false
	_ = clientOpts.ReadOpt("literalURLs", &literalURLs)
	var pathPrefix string
	if ok := clientOpts.ReadOpt("pathPrefix", &pathPrefix); !ok {
		pathPrefix = "/twirp" // default prefix
	}

	// Build method URLs: <baseURL>[<prefix>]/<package>.<Service>/<Method>
	serviceURL := sanitizeBaseURL(baseURL)
	serviceURL += baseServicePath(pathPrefix, "starfruit.carrot_analytics_control", "CarrotAnalyticsControl")
	urls := [3]string{
		serviceURL + "EnqueueQuery",
		serviceURL + "GetQueryResult",
		serviceURL + "ListQueries",
	}

	return &carrotAnalyticsControlProtobufClient{
		client:      client,
		urls:        urls,
		interceptor: twirp.ChainInterceptors(clientOpts.Interceptors...),
		opts:        clientOpts,
	}
}

func (c *carrotAnalyticsControlProtobufClient) EnqueueQuery(ctx context.Context, in *EnqueueQueryRequest) (*EnqueueQueryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_analytics_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotAnalyticsControl")
	ctx = ctxsetters.WithMethodName(ctx, "EnqueueQuery")
	caller := c.callEnqueueQuery
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *EnqueueQueryRequest) (*EnqueueQueryResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*EnqueueQueryRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*EnqueueQueryRequest) when calling interceptor")
					}
					return c.callEnqueueQuery(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*EnqueueQueryResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*EnqueueQueryResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotAnalyticsControlProtobufClient) callEnqueueQuery(ctx context.Context, in *EnqueueQueryRequest) (*EnqueueQueryResponse, error) {
	out := new(EnqueueQueryResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotAnalyticsControlProtobufClient) GetQueryResult(ctx context.Context, in *GetQueryResultRequest) (*GetQueryResultResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_analytics_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotAnalyticsControl")
	ctx = ctxsetters.WithMethodName(ctx, "GetQueryResult")
	caller := c.callGetQueryResult
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetQueryResultRequest) (*GetQueryResultResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetQueryResultRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetQueryResultRequest) when calling interceptor")
					}
					return c.callGetQueryResult(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetQueryResultResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetQueryResultResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotAnalyticsControlProtobufClient) callGetQueryResult(ctx context.Context, in *GetQueryResultRequest) (*GetQueryResultResponse, error) {
	out := new(GetQueryResultResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotAnalyticsControlProtobufClient) ListQueries(ctx context.Context, in *ListQueriesRequest) (*ListQueriesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_analytics_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotAnalyticsControl")
	ctx = ctxsetters.WithMethodName(ctx, "ListQueries")
	caller := c.callListQueries
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *ListQueriesRequest) (*ListQueriesResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListQueriesRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListQueriesRequest) when calling interceptor")
					}
					return c.callListQueries(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ListQueriesResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ListQueriesResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotAnalyticsControlProtobufClient) callListQueries(ctx context.Context, in *ListQueriesRequest) (*ListQueriesResponse, error) {
	out := new(ListQueriesResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ==================================
// CarrotAnalyticsControl JSON Client
// ==================================

type carrotAnalyticsControlJSONClient struct {
	client      HTTPClient
	urls        [3]string
	interceptor twirp.Interceptor
	opts        twirp.ClientOptions
}

// NewCarrotAnalyticsControlJSONClient creates a JSON client that implements the CarrotAnalyticsControl interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewCarrotAnalyticsControlJSONClient(baseURL string, client HTTPClient, opts ...twirp.ClientOption) CarrotAnalyticsControl {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	// Using ReadOpt allows backwards and forwads compatibility with new options in the future
	literalURLs := false
	_ = clientOpts.ReadOpt("literalURLs", &literalURLs)
	var pathPrefix string
	if ok := clientOpts.ReadOpt("pathPrefix", &pathPrefix); !ok {
		pathPrefix = "/twirp" // default prefix
	}

	// Build method URLs: <baseURL>[<prefix>]/<package>.<Service>/<Method>
	serviceURL := sanitizeBaseURL(baseURL)
	serviceURL += baseServicePath(pathPrefix, "starfruit.carrot_analytics_control", "CarrotAnalyticsControl")
	urls := [3]string{
		serviceURL + "EnqueueQuery",
		serviceURL + "GetQueryResult",
		serviceURL + "ListQueries",
	}

	return &carrotAnalyticsControlJSONClient{
		client:      client,
		urls:        urls,
		interceptor: twirp.ChainInterceptors(clientOpts.Interceptors...),
		opts:        clientOpts,
	}
}

func (c *carrotAnalyticsControlJSONClient) EnqueueQuery(ctx context.Context, in *EnqueueQueryRequest) (*EnqueueQueryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_analytics_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotAnalyticsControl")
	ctx = ctxsetters.WithMethodName(ctx, "EnqueueQuery")
	caller := c.callEnqueueQuery
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *EnqueueQueryRequest) (*EnqueueQueryResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*EnqueueQueryRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*EnqueueQueryRequest) when calling interceptor")
					}
					return c.callEnqueueQuery(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*EnqueueQueryResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*EnqueueQueryResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotAnalyticsControlJSONClient) callEnqueueQuery(ctx context.Context, in *EnqueueQueryRequest) (*EnqueueQueryResponse, error) {
	out := new(EnqueueQueryResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotAnalyticsControlJSONClient) GetQueryResult(ctx context.Context, in *GetQueryResultRequest) (*GetQueryResultResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_analytics_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotAnalyticsControl")
	ctx = ctxsetters.WithMethodName(ctx, "GetQueryResult")
	caller := c.callGetQueryResult
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetQueryResultRequest) (*GetQueryResultResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetQueryResultRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetQueryResultRequest) when calling interceptor")
					}
					return c.callGetQueryResult(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetQueryResultResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetQueryResultResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotAnalyticsControlJSONClient) callGetQueryResult(ctx context.Context, in *GetQueryResultRequest) (*GetQueryResultResponse, error) {
	out := new(GetQueryResultResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotAnalyticsControlJSONClient) ListQueries(ctx context.Context, in *ListQueriesRequest) (*ListQueriesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_analytics_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotAnalyticsControl")
	ctx = ctxsetters.WithMethodName(ctx, "ListQueries")
	caller := c.callListQueries
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *ListQueriesRequest) (*ListQueriesResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListQueriesRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListQueriesRequest) when calling interceptor")
					}
					return c.callListQueries(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ListQueriesResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ListQueriesResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotAnalyticsControlJSONClient) callListQueries(ctx context.Context, in *ListQueriesRequest) (*ListQueriesResponse, error) {
	out := new(ListQueriesResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =====================================
// CarrotAnalyticsControl Server Handler
// =====================================

type carrotAnalyticsControlServer struct {
	CarrotAnalyticsControl
	interceptor      twirp.Interceptor
	hooks            *twirp.ServerHooks
	pathPrefix       string // prefix for routing
	jsonSkipDefaults bool   // do not include unpopulated fields (default values) in the response
	jsonCamelCase    bool   // JSON fields are serialized as lowerCamelCase rather than keeping the original proto names
}

// NewCarrotAnalyticsControlServer builds a TwirpServer that can be used as an http.Handler to handle
// HTTP requests that are routed to the right method in the provided svc implementation.
// The opts are twirp.ServerOption modifiers, for example twirp.WithServerHooks(hooks).
func NewCarrotAnalyticsControlServer(svc CarrotAnalyticsControl, opts ...interface{}) TwirpServer {
	serverOpts := newServerOpts(opts)

	// Using ReadOpt allows backwards and forwads compatibility with new options in the future
	jsonSkipDefaults := false
	_ = serverOpts.ReadOpt("jsonSkipDefaults", &jsonSkipDefaults)
	jsonCamelCase := false
	_ = serverOpts.ReadOpt("jsonCamelCase", &jsonCamelCase)
	var pathPrefix string
	if ok := serverOpts.ReadOpt("pathPrefix", &pathPrefix); !ok {
		pathPrefix = "/twirp" // default prefix
	}

	return &carrotAnalyticsControlServer{
		CarrotAnalyticsControl: svc,
		hooks:                  serverOpts.Hooks,
		interceptor:            twirp.ChainInterceptors(serverOpts.Interceptors...),
		pathPrefix:             pathPrefix,
		jsonSkipDefaults:       jsonSkipDefaults,
		jsonCamelCase:          jsonCamelCase,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *carrotAnalyticsControlServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// handleRequestBodyError is used to handle error when the twirp server cannot read request
func (s *carrotAnalyticsControlServer) handleRequestBodyError(ctx context.Context, resp http.ResponseWriter, msg string, err error) {
	if context.Canceled == ctx.Err() {
		s.writeError(ctx, resp, twirp.NewError(twirp.Canceled, "failed to read request: context canceled"))
		return
	}
	if context.DeadlineExceeded == ctx.Err() {
		s.writeError(ctx, resp, twirp.NewError(twirp.DeadlineExceeded, "failed to read request: deadline exceeded"))
		return
	}
	s.writeError(ctx, resp, twirp.WrapError(malformedRequestError(msg), err))
}

// CarrotAnalyticsControlPathPrefix is a convenience constant that may identify URL paths.
// Should be used with caution, it only matches routes generated by Twirp Go clients,
// with the default "/twirp" prefix and default CamelCase service and method names.
// More info: https://twitchtv.github.io/twirp/docs/routing.html
const CarrotAnalyticsControlPathPrefix = "/twirp/starfruit.carrot_analytics_control.CarrotAnalyticsControl/"

func (s *carrotAnalyticsControlServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_analytics_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotAnalyticsControl")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}

	// Verify path format: [<prefix>]/<package>.<Service>/<Method>
	prefix, pkgService, method := parseTwirpPath(req.URL.Path)
	if pkgService != "starfruit.carrot_analytics_control.CarrotAnalyticsControl" {
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}
	if prefix != s.pathPrefix {
		msg := fmt.Sprintf("invalid path prefix %q, expected %q, on path %q", prefix, s.pathPrefix, req.URL.Path)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}

	switch method {
	case "EnqueueQuery":
		s.serveEnqueueQuery(ctx, resp, req)
		return
	case "GetQueryResult":
		s.serveGetQueryResult(ctx, resp, req)
		return
	case "ListQueries":
		s.serveListQueries(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}
}

func (s *carrotAnalyticsControlServer) serveEnqueueQuery(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveEnqueueQueryJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveEnqueueQueryProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *carrotAnalyticsControlServer) serveEnqueueQueryJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EnqueueQuery")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(EnqueueQueryRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.CarrotAnalyticsControl.EnqueueQuery
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *EnqueueQueryRequest) (*EnqueueQueryResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*EnqueueQueryRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*EnqueueQueryRequest) when calling interceptor")
					}
					return s.CarrotAnalyticsControl.EnqueueQuery(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*EnqueueQueryResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*EnqueueQueryResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *EnqueueQueryResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EnqueueQueryResponse and nil error while calling EnqueueQuery. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotAnalyticsControlServer) serveEnqueueQueryProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EnqueueQuery")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(EnqueueQueryRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.CarrotAnalyticsControl.EnqueueQuery
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *EnqueueQueryRequest) (*EnqueueQueryResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*EnqueueQueryRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*EnqueueQueryRequest) when calling interceptor")
					}
					return s.CarrotAnalyticsControl.EnqueueQuery(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*EnqueueQueryResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*EnqueueQueryResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *EnqueueQueryResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *EnqueueQueryResponse and nil error while calling EnqueueQuery. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotAnalyticsControlServer) serveGetQueryResult(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetQueryResultJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetQueryResultProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *carrotAnalyticsControlServer) serveGetQueryResultJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetQueryResult")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(GetQueryResultRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.CarrotAnalyticsControl.GetQueryResult
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetQueryResultRequest) (*GetQueryResultResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetQueryResultRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetQueryResultRequest) when calling interceptor")
					}
					return s.CarrotAnalyticsControl.GetQueryResult(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetQueryResultResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetQueryResultResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *GetQueryResultResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetQueryResultResponse and nil error while calling GetQueryResult. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotAnalyticsControlServer) serveGetQueryResultProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetQueryResult")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(GetQueryResultRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.CarrotAnalyticsControl.GetQueryResult
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetQueryResultRequest) (*GetQueryResultResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetQueryResultRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetQueryResultRequest) when calling interceptor")
					}
					return s.CarrotAnalyticsControl.GetQueryResult(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetQueryResultResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetQueryResultResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *GetQueryResultResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetQueryResultResponse and nil error while calling GetQueryResult. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotAnalyticsControlServer) serveListQueries(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListQueriesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListQueriesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *carrotAnalyticsControlServer) serveListQueriesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListQueries")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(ListQueriesRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.CarrotAnalyticsControl.ListQueries
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *ListQueriesRequest) (*ListQueriesResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListQueriesRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListQueriesRequest) when calling interceptor")
					}
					return s.CarrotAnalyticsControl.ListQueries(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ListQueriesResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ListQueriesResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *ListQueriesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListQueriesResponse and nil error while calling ListQueries. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotAnalyticsControlServer) serveListQueriesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListQueries")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(ListQueriesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.CarrotAnalyticsControl.ListQueries
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *ListQueriesRequest) (*ListQueriesResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListQueriesRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListQueriesRequest) when calling interceptor")
					}
					return s.CarrotAnalyticsControl.ListQueries(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ListQueriesResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ListQueriesResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *ListQueriesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListQueriesResponse and nil error while calling ListQueries. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotAnalyticsControlServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *carrotAnalyticsControlServer) ProtocGenTwirpVersion() string {
	return "v8.1.0"
}

// PathPrefix returns the base service path, in the form: "/<prefix>/<package>.<Service>/"
// that is everything in a Twirp route except for the <Method>. This can be used for routing,
// for example to identify the requests that are targeted to this service in a mux.
func (s *carrotAnalyticsControlServer) PathPrefix() string {
	return baseServicePath(s.pathPrefix, "starfruit.carrot_analytics_control", "CarrotAnalyticsControl")
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler

	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// google.golang.org/protobuf/types/descriptorpb.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)

	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string

	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route Twirp requests.
	// The path prefix is in the form: "/<prefix>/<package>.<Service>/"
	// that is, everything in a Twirp route except for the <Method> at the end.
	PathPrefix() string
}

func newServerOpts(opts []interface{}) *twirp.ServerOptions {
	serverOpts := &twirp.ServerOptions{}
	for _, opt := range opts {
		switch o := opt.(type) {
		case twirp.ServerOption:
			o(serverOpts)
		case *twirp.ServerHooks: // backwards compatibility, allow to specify hooks as an argument
			twirp.WithServerHooks(o)(serverOpts)
		case nil: // backwards compatibility, allow nil value for the argument
			continue
		default:
			panic(fmt.Sprintf("Invalid option type %T, please use a twirp.ServerOption", o))
		}
	}
	return serverOpts
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Convert to a twirp.Error. Non-twirp errors are converted to internal errors.
	var twerr twirp.Error
	if !errors.As(err, &twerr) {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// sanitizeBaseURL parses the the baseURL, and adds the "http" scheme if needed.
// If the URL is unparsable, the baseURL is returned unchaged.
func sanitizeBaseURL(baseURL string) string {
	u, err := url.Parse(baseURL)
	if err != nil {
		return baseURL // invalid URL will fail later when making requests
	}
	if u.Scheme == "" {
		u.Scheme = "http"
	}
	return u.String()
}

// baseServicePath composes the path prefix for the service (without <Method>).
// e.g.: baseServicePath("/twirp", "my.pkg", "MyService")
//       returns => "/twirp/my.pkg.MyService/"
// e.g.: baseServicePath("", "", "MyService")
//       returns => "/MyService/"
func baseServicePath(prefix, pkg, service string) string {
	fullServiceName := service
	if pkg != "" {
		fullServiceName = pkg + "." + service
	}
	return path.Join("/", prefix, fullServiceName) + "/"
}

// parseTwirpPath extracts path components form a valid Twirp route.
// Expected format: "[<prefix>]/<package>.<Service>/<Method>"
// e.g.: prefix, pkgService, method := parseTwirpPath("/twirp/pkg.Svc/MakeHat")
func parseTwirpPath(path string) (string, string, string) {
	parts := strings.Split(path, "/")
	if len(parts) < 2 {
		return "", "", ""
	}
	method := parts[len(parts)-1]
	pkgService := parts[len(parts)-2]
	prefix := strings.Join(parts[0:len(parts)-2], "/")
	return prefix, pkgService, method
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v8.1.0")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429: // Too Many Requests
			code = twirp.ResourceExhausted
		case 502, 503, 504: // Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	marshaler := &protojson.MarshalOptions{UseProtoNames: true}
	reqBytes, err := marshaler.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, bytes.NewReader(reqBytes), "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	d := json.NewDecoder(resp.Body)
	rawRespBody := json.RawMessage{}
	if err := d.Decode(&rawRespBody); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawRespBody, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1980 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x58, 0x4f, 0x73, 0x1b, 0x49,
	0x15, 0x8f, 0x2c, 0xff, 0xd3, 0x93, 0x2d, 0xc9, 0xed, 0x28, 0x99, 0x98, 0x0d, 0x31, 0x2a, 0xfe,
	0x64, 0x03, 0x91, 0xb3, 0x59, 0xb2, 0xd9, 0x65, 0xc9, 0x2e, 0x91, 0x56, 0x49, 0x4c, 0xc5, 0xbb,
	0xc9, 0xc8, 0x4e, 0x28, 0x0e, 0x4c, 0xb5, 0x66, 0x5a, 0xf2, 0xb0, 0xa3, 0xe9, 0x49, 0x77, 0x8f,
	0xbc, 0xda, 0x03, 0x55, 0x5c, 0xa0, 0x8a, 0x0b, 0x07, 0xae, 0x5c, 0xe1, 0x46, 0xf1, 0x15, 0xf8,
	0x1a, 0x1c, 0xf9, 0x08, 0x5c, 0x38, 0x53, 0xfd, 0xba, 0x47, 0x1a, 0xc9, 0x32, 0x91, 0xf7, 0xc4,
	0x6d, 0xfa, 0xbd, 0xf7, 0x7b, 0xfd, 0xfe, 0xf7, 0x93, 0x60, 0xdb, 0xe7, 0xb1, 0x12, 0x3c, 0x6a,
	0x26, 0x82, 0x2b, 0x4e, 0x1a, 0x52, 0x51, 0xd1, 0x17, 0x69, 0xa8, 0x9a, 0x3e, 0x15, 0x82, 0x2b,
	0x8f, 0xc6, 0x34, 0x1a, 0xab, 0xd0, 0x97, 0x9e, 0x95, 0xdc, 0xbb, 0x35, 0xe0, 0x7c, 0x10, 0xb1,
	0x03, 0x44, 0xf4, 0xd2, 0xfe, 0x81, 0x0a, 0x87, 0x4c, 0x2a, 0x3a, 0x4c, 0x8c, 0x92, 0x46, 0x1b,
	0x6e, 0xbc, 0x88, 0xe8, 0xb8, 0xcb, 0xa4, 0x0c, 0x79, 0x7c, 0x18, 0xf7, 0xf9, 0x0b, 0x2a, 0xe8,
	0x90, 0x29, 0x26, 0x24, 0xf9, 0x3e, 0x54, 0x93, 0x88, 0x8e, 0x3d, 0x69, 0xb8, 0x5e, 0x18, 0x38,
	0x85, 0xfd, 0xc2, 0xed, 0x92, 0xbb, 0x9d, 0xe4, 0x30, 0x41, 0xe3, 0xcf, 0x45, 0xa8, 0x6a, 0x2d,
	0x3d, 0xea, 0x7f, 0xd9, 0x4d, 0x87, 0x43, 0x2a, 0xc6, 0xe4, 0x13, 0xd8, 0xee, 0x87, 0x42, 0x2a,
	0x6f, 0x78, 0xe6, 0xe9, 0x4b, 0x11, 0x59, 0xbe, 0xbf, 0xd7, 0x34, 0x16, 0x35, 0x33, 0x8b, 0x9a,
	0xc7, 0x99, 0x45, 0x6e, 0x19, 0x01, 0x47, 0x67, 0x9a, 0x42, 0x7e, 0x0a, 0x5b, 0x11, 0xcd, 0xc1,
	0x57, 0xde, 0x0a, 0x07, 0x2d, 0x6f, 0xd1, 0x3f, 0x80, 0xea, 0x30, 0x8c, 0x53, 0xc5, 0xa4, 0x77,
	0x46, 0x95, 0x7f, 0xca, 0x02, 0xa7, 0xb8, 0x5f, 0xb8, 0x5d, 0x74, 0x2b, 0x96, 0xfc, 0xda, 0x50,
	0xc9, 0xf7, 0xa0, 0xd2, 0x4b, 0xfb, 0x7d, 0x26, 0x3c, 0x36, 0x4c, 0x54, 0xc8, 0xa4, 0xb3, 0x8a,
	0x72, 0xdb, 0x86, 0xda, 0x31, 0x44, 0x72, 0x0d, 0xd6, 0x99, 0x10, 0x5c, 0x48, 0x67, 0x0d, 0xd9,
	0xf6, 0x44, 0x7e, 0x08, 0x3b, 0x92, 0xf9, 0x3c, 0x0e, 0xa4, 0x67, 0x00, 0x61, 0x3c, 0x70, 0xd6,
	0x51, 0xa4, 0x66, 0x19, 0xad, 0x8c, 0x4e, 0x7e, 0x0c, 0xd7, 0x12, 0x26, 0x7c, 0x16, 0x2b, 0x74,
	0x29, 0x87, 0xd8, 0xd8, 0x2f, 0xdc, 0x2e, 0xb8, 0x57, 0x2d, 0x57, 0x7b, 0x30, 0x45, 0xdd, 0x82,
	0x32, 0x1d, 0x0d, 0xbc, 0x88, 0x2a, 0x16, 0xfb, 0x63, 0x67, 0x13, 0x45, 0x81, 0x8e, 0x06, 0xcf,
	0x0d, 0x45, 0x0b, 0x24, 0x0f, 0xee, 0x4d, 0x04, 0x4a, 0x46, 0x20, 0x79, 0x70, 0xcf, 0x0a, 0x34,
	0xfe, 0xb1, 0x0a, 0xf0, 0x2a, 0x0c, 0x18, 0xef, 0x68, 0xa3, 0x49, 0x13, 0x56, 0x97, 0x4c, 0x08,
	0xca, 0x91, 0xdb, 0x50, 0x1b, 0x69, 0xb4, 0x87, 0x3e, 0x7b, 0x3e, 0x0f, 0x4c, 0x36, 0xd6, 0xdc,
	0xca, 0x68, 0xa2, 0xb5, 0xcd, 0x03, 0x46, 0x9a, 0xb0, 0x9b, 0x97, 0x1c, 0x32, 0x29, 0xe9, 0x80,
	0x61, 0xe4, 0x4b, 0xee, 0xce, 0x54, 0xf8, 0xc8, 0x30, 0xc8, 0x07, 0x70, 0x3d, 0x2f, 0x2f, 0x98,
	0xcf, 0x47, 0x4c, 0xd0, 0x5e, 0xc4, 0x30, 0x0b, 0x9b, 0x6e, 0x7d, 0x8a, 0x71, 0xa7, 0x4c, 0xf2,
	0x23, 0x20, 0xb3, 0x38, 0x99, 0x46, 0x0a, 0x33, 0x53, 0x72, 0x6b, 0x79, 0x88, 0xa6, 0xcf, 0x4b,
	0x4b, 0x9e, 0x0a, 0x9f, 0x61, 0x92, 0x66, 0xa4, 0xbb, 0x48, 0x27, 0x77, 0x60, 0x27, 0x2f, 0x3d,
	0xa2, 0x51, 0xca, 0x30, 0x3f, 0x6b, 0x6e, 0x75, 0x2a, 0xfc, 0x4a, 0x93, 0xa7, 0xb2, 0xb6, 0x84,
	0x64, 0xf8, 0x35, 0xb3, 0x09, 0x32, 0xb2, 0x26, 0x8b, 0xdd, 0xf0, 0x6b, 0xb4, 0x39, 0x57, 0x68,
	0x63, 0xcf, 0xe7, 0x69, 0xac, 0x30, 0x59, 0x45, 0xb7, 0x36, 0x2d, 0xb6, 0x71, 0x5b, 0xd3, 0xc9,
	0x4d, 0x00, 0xdd, 0x62, 0x61, 0x3c, 0xf0, 0x68, 0xe0, 0x00, 0x06, 0xa3, 0x64, 0x29, 0x8f, 0x03,
	0x52, 0x83, 0x62, 0x2a, 0x22, 0xa7, 0x8c, 0x3e, 0xe8, 0x4f, 0x5d, 0x04, 0xc6, 0x60, 0xf6, 0x95,
	0x12, 0xd4, 0xd9, 0x42, 0xbd, 0x80, 0xa4, 0x8e, 0xa6, 0x68, 0x8d, 0x46, 0x40, 0x8d, 0x13, 0xe6,
	0x6c, 0x23, 0xb2, 0x84, 0x94, 0xe3, 0x71, 0xc2, 0xa6, 0xec, 0xb3, 0x53, 0xaa, 0x9c, 0x0a, 0xc2,
	0x0d, 0xfb, 0xf5, 0x29, 0x55, 0x8d, 0x3f, 0x95, 0x4c, 0x87, 0xe7, 0xe6, 0xc4, 0xa5, 0xeb, 0x68,
	0x0f, 0x36, 0x93, 0x88, 0xaa, 0x3e, 0x17, 0x43, 0xac, 0x9f, 0x92, 0x3b, 0x39, 0xeb, 0xfe, 0xd2,
	0xde, 0x31, 0x61, 0x8b, 0xc5, 0x9e, 0xc8, 0x77, 0x60, 0xcb, 0xe7, 0x82, 0x79, 0x23, 0x26, 0xf4,
	0xbd, 0x58, 0x16, 0x25, 0xb7, 0xac, 0x69, 0xaf, 0x0c, 0x89, 0x38, 0xb0, 0xa1, 0xe7, 0x0e, 0x8b,
	0x03, 0x5b, 0x01, 0xd9, 0x51, 0x0f, 0x01, 0xfb, 0x39, 0xc1, 0x9b, 0xac, 0x57, 0x2c, 0x39, 0xa7,
	0xc2, 0x3f, 0xa5, 0x71, 0xcc, 0x22, 0xcc, 0x74, 0xc9, 0xcd, 0x8e, 0x3a, 0x2c, 0x7a, 0x94, 0xea,
	0x96, 0x0d, 0x03, 0x4c, 0x6d, 0xc9, 0x2d, 0x59, 0xca, 0x61, 0xa0, 0xa3, 0xee, 0xa7, 0x52, 0xf1,
	0x21, 0x13, 0x9a, 0x5f, 0x42, 0x3e, 0x64, 0xa4, 0xc3, 0x00, 0x35, 0x47, 0xa9, 0x54, 0x4c, 0x60,
	0x12, 0xb5, 0x66, 0x73, 0x24, 0x04, 0x56, 0x63, 0xdd, 0x49, 0x26, 0x87, 0xf8, 0xad, 0x6f, 0x93,
	0x4c, 0x8c, 0x74, 0xd6, 0xc3, 0x00, 0x73, 0x58, 0x72, 0x4b, 0x96, 0x62, 0x95, 0xe9, 0xea, 0x10,
	0x63, 0x9b, 0xbf, 0xec, 0xa8, 0x95, 0x45, 0xe1, 0x88, 0x61, 0xde, 0x36, 0x5d, 0xfc, 0x26, 0xdf,
	0x85, 0xca, 0x88, 0x07, 0x9e, 0x1f, 0xc4, 0x1e, 0x17, 0xe1, 0x20, 0x8c, 0x9d, 0x2a, 0x82, 0xb6,
	0x46, 0x3c, 0x68, 0x07, 0xf1, 0x17, 0x48, 0xd3, 0x1e, 0x44, 0xfc, 0x6c, 0x32, 0x3c, 0x6a, 0xa8,
	0x00, 0x22, 0x7e, 0x96, 0x4d, 0x17, 0x1d, 0x81, 0x28, 0xd4, 0x01, 0xa0, 0x49, 0xe2, 0xec, 0xd8,
	0x08, 0x20, 0xe5, 0x71, 0x92, 0xe0, 0x74, 0x4a, 0x92, 0x49, 0x7c, 0x89, 0x89, 0x00, 0x4d, 0x92,
	0x2c, 0xb6, 0x7a, 0xc0, 0x0a, 0x7e, 0x26, 0x99, 0xf0, 0xfa, 0x74, 0x18, 0x46, 0x63, 0x67, 0xd7,
	0x3c, 0x21, 0x96, 0xfa, 0x04, 0x89, 0x98, 0x2b, 0x2b, 0x96, 0xe9, 0xba, 0x6a, 0x73, 0x65, 0xc8,
	0x99, 0xbe, 0x0a, 0xac, 0x70, 0xe9, 0xd4, 0x91, 0xb7, 0xc2, 0x25, 0xb9, 0x0e, 0x1b, 0x5c, 0x7a,
	0x31, 0x1d, 0x32, 0xe7, 0x9a, 0x29, 0x1d, 0x2e, 0x3f, 0xa7, 0x43, 0x0c, 0x26, 0x97, 0x13, 0x65,
	0xd7, 0x8d, 0xe1, 0x5c, 0x66, 0x7a, 0x0e, 0x60, 0x37, 0x60, 0xa3, 0xd0, 0x67, 0xde, 0x90, 0xc6,
	0x69, 0x9f, 0xfa, 0x2a, 0x15, 0x4c, 0x38, 0x0e, 0xca, 0x11, 0xc3, 0x3a, 0xca, 0x71, 0xc8, 0x87,
	0x70, 0x03, 0xa7, 0x76, 0x9f, 0x0b, 0xcf, 0x54, 0xa7, 0x87, 0xa5, 0x19, 0x71, 0x1a, 0x38, 0x37,
	0xb0, 0x61, 0xea, 0x5a, 0xe0, 0x09, 0x17, 0x2f, 0x90, 0xdd, 0xe6, 0x82, 0x3d, 0xe7, 0x34, 0x20,
	0x77, 0x61, 0x77, 0x82, 0x54, 0xfc, 0x4b, 0x16, 0x1b, 0xcc, 0x9e, 0xe9, 0x7d, 0x8b, 0x39, 0xd6,
	0x0c, 0x14, 0xff, 0x19, 0xdc, 0x44, 0x71, 0xc5, 0xbd, 0x21, 0xd5, 0xb5, 0x82, 0xd7, 0x45, 0xa1,
	0x54, 0x9e, 0x60, 0x34, 0x18, 0x3b, 0xdf, 0x42, 0x20, 0x5a, 0x73, 0xcc, 0x8f, 0x50, 0xe4, 0x85,
	0x95, 0x70, 0xb5, 0x00, 0x79, 0x0f, 0xea, 0x99, 0x86, 0x11, 0x15, 0x21, 0x8d, 0x33, 0xe4, 0x3b,
	0x88, 0x24, 0x06, 0xf9, 0xca, 0xb0, 0xce, 0x41, 0x24, 0x1b, 0x0c, 0xd9, 0x04, 0x72, 0x33, 0x0f,
	0xe9, 0x1a, 0xd6, 0x2c, 0x44, 0x86, 0xb1, 0x6f, 0xc2, 0xe0, 0xe9, 0x8d, 0x44, 0x39, 0xdf, 0x9e,
	0x42, 0xba, 0x9a, 0xa7, 0xbd, 0xea, 0x6a, 0x8e, 0x6e, 0xe7, 0x2c, 0xe8, 0x3c, 0x60, 0x91, 0x73,
	0xcb, 0xb4, 0xb3, 0x8d, 0xb6, 0x26, 0xe9, 0x99, 0x6a, 0x45, 0x72, 0xd9, 0xdb, 0x47, 0xb9, 0xaa,
	0x61, 0x7c, 0x91, 0xe5, 0xb0, 0xf1, 0xb7, 0x15, 0xb8, 0x3e, 0x37, 0x95, 0x5c, 0x26, 0x13, 0x1e,
	0x4b, 0x46, 0x7e, 0x05, 0xb5, 0xc4, 0xae, 0x24, 0x9e, 0x34, 0x3b, 0x89, 0x9d, 0x54, 0xef, 0x37,
	0xdf, 0xbe, 0x38, 0x35, 0xe7, 0xd6, 0x19, 0xb7, 0x9a, 0xcc, 0xed, 0x37, 0x2f, 0x61, 0x2b, 0xf7,
	0x4e, 0x48, 0x67, 0x65, 0xbf, 0x78, 0xbb, 0x7c, 0xbf, 0xb9, 0x8c, 0xee, 0xe9, 0x5b, 0xec, 0x96,
	0xa7, 0x4f, 0x8a, 0x24, 0x1e, 0xec, 0xcc, 0xae, 0x5b, 0x71, 0x9f, 0xe3, 0x3c, 0xbc, 0x84, 0xcd,
	0xf9, 0x50, 0x54, 0x93, 0x59, 0x42, 0xa3, 0x03, 0xd7, 0x5b, 0x82, 0xd3, 0xc0, 0xa7, 0x52, 0xcd,
	0xad, 0x7a, 0x77, 0x60, 0x27, 0x8c, 0x07, 0x4c, 0xaa, 0xf3, 0xcb, 0x5e, 0xd5, 0x30, 0xa6, 0xeb,
	0xde, 0x5f, 0x8a, 0x40, 0x72, 0x77, 0x65, 0x11, 0xb9, 0xec, 0x7b, 0xf0, 0x31, 0x94, 0xed, 0x64,
	0x59, 0x76, 0xc1, 0x33, 0xe2, 0xb8, 0xe0, 0x75, 0xc1, 0x31, 0xeb, 0x21, 0xae, 0x73, 0xd9, 0x92,
	0x67, 0x34, 0x15, 0xdf, 0xaa, 0xa9, 0x8e, 0xab, 0x22, 0x42, 0xed, 0x22, 0x88, 0x4a, 0x17, 0xec,
	0xbb, 0xab, 0x0b, 0xf6, 0x5d, 0x5d, 0xc6, 0xbd, 0x2c, 0x8e, 0x5a, 0xc8, 0xec, 0x84, 0xe5, 0x09,
	0xed, 0x30, 0x20, 0xef, 0x42, 0x6d, 0x48, 0xe3, 0xb0, 0xaf, 0x23, 0x9a, 0xbd, 0x00, 0xe6, 0xf1,
	0xa9, 0x66, 0xf4, 0xf6, 0xdc, 0x4b, 0xb0, 0x91, 0x7b, 0x09, 0x6a, 0x50, 0xa4, 0x32, 0xb6, 0x0f,
	0x8e, 0xfe, 0xbc, 0xb8, 0xdb, 0x4a, 0x17, 0x75, 0x5b, 0xe3, 0xef, 0x05, 0xd8, 0xcb, 0xe5, 0xa9,
	0x35, 0x9e, 0xf1, 0x98, 0x9c, 0xc2, 0xd5, 0x19, 0x6f, 0x67, 0xbb, 0xe4, 0x83, 0x4b, 0x56, 0x5c,
	0xd6, 0x28, 0x24, 0x39, 0x5f, 0x19, 0x0b, 0xb6, 0xf1, 0x95, 0x45, 0xdb, 0x78, 0xe3, 0x5f, 0x05,
	0xd8, 0x99, 0xb1, 0xb8, 0xd5, 0x39, 0x7a, 0xfd, 0x7f, 0x68, 0xe8, 0x82, 0x9f, 0x0d, 0xc5, 0x45,
	0x3f, 0x1b, 0x08, 0xac, 0xf6, 0xd8, 0xf0, 0x0c, 0xab, 0xa8, 0xe0, 0xe2, 0x77, 0xe3, 0x0f, 0x2b,
	0x50, 0x9f, 0xe9, 0xc2, 0xc9, 0xc8, 0xfa, 0x5d, 0x01, 0xf6, 0xf3, 0x8e, 0x4a, 0xaf, 0x37, 0xf6,
	0xe6, 0xed, 0x29, 0xe0, 0x9c, 0xf9, 0xe4, 0x92, 0x4e, 0xcf, 0xe5, 0xde, 0x7d, 0x27, 0xe7, 0xbc,
	0xcc, 0x98, 0x72, 0x5a, 0x19, 0xf5, 0x73, 0x76, 0xa0, 0x1f, 0x66, 0xc8, 0x3d, 0xb8, 0xf4, 0xe5,
	0x3a, 0x8d, 0x33, 0x01, 0x97, 0xad, 0x71, 0x4b, 0x07, 0xe3, 0x3f, 0x2b, 0xb0, 0xf6, 0x32, 0x65,
	0x62, 0x4c, 0x3e, 0x02, 0xc0, 0x7a, 0xf6, 0x02, 0xaa, 0x96, 0x99, 0x21, 0x25, 0x94, 0xfe, 0x8c,
	0x2a, 0x46, 0x1e, 0xc0, 0xa6, 0xde, 0xf1, 0x10, 0xf8, 0xf6, 0x29, 0xb2, 0xc1, 0xe2, 0x00, 0x61,
	0x6f, 0xa0, 0x9e, 0xeb, 0xe2, 0xb8, 0xcf, 0xbd, 0x44, 0xcf, 0x43, 0xe9, 0x04, 0xa8, 0xe3, 0xe3,
	0x65, 0xbc, 0xbc, 0x60, 0x9c, 0x3e, 0xbb, 0xe2, 0xee, 0xf6, 0xce, 0xb1, 0x24, 0xf9, 0x0a, 0x9c,
	0x73, 0x13, 0x3e, 0xbb, 0x95, 0xe1, 0xad, 0x8f, 0xbe, 0xc1, 0xa0, 0x9f, 0xb9, 0xb7, 0x9e, 0x2c,
	0x60, 0xca, 0x56, 0x05, 0xb6, 0xde, 0xe8, 0x38, 0xdb, 0xdb, 0x1a, 0x7f, 0x2c, 0xc0, 0x6e, 0x27,
	0x7e, 0x93, 0xb2, 0x94, 0x61, 0xfc, 0x5d, 0xf6, 0x26, 0x65, 0x52, 0x91, 0x4f, 0x61, 0x0d, 0xe5,
	0x6c, 0x06, 0xde, 0x5d, 0xc6, 0x1c, 0xa3, 0xc0, 0xe0, 0xf4, 0x6c, 0x14, 0x46, 0x17, 0x0b, 0xbc,
	0xde, 0xd8, 0x6e, 0xfa, 0xe5, 0x09, 0xad, 0x35, 0x26, 0x57, 0x61, 0x2d, 0xa2, 0x3d, 0x16, 0xd9,
	0x5d, 0xdf, 0x1c, 0x1a, 0xef, 0xc1, 0xd5, 0x59, 0x83, 0x6c, 0x57, 0xdc, 0x80, 0x4d, 0x63, 0xf9,
	0xe4, 0x41, 0xda, 0xc0, 0xf3, 0x61, 0xd0, 0xb8, 0x0f, 0xf5, 0xa7, 0x4c, 0x65, 0xe2, 0x69, 0xa4,
	0x32, 0x2f, 0xfe, 0x07, 0xe6, 0xdf, 0x05, 0xb8, 0x36, 0x0f, 0xb2, 0x37, 0xf5, 0x70, 0x55, 0xcd,
	0x15, 0x84, 0xad, 0x84, 0x8f, 0x2e, 0x5d, 0x09, 0x99, 0xca, 0x67, 0x57, 0x70, 0xcf, 0x9d, 0x32,
	0x48, 0xb8, 0xe8, 0x8d, 0x67, 0xcb, 0x17, 0xdc, 0x05, 0xeb, 0xce, 0xb3, 0x2b, 0xe7, 0x5e, 0xfb,
	0xd6, 0x26, 0xac, 0x9b, 0x5f, 0xc6, 0x8d, 0x87, 0x40, 0x9e, 0x87, 0x12, 0x7d, 0x0e, 0x99, 0xcc,
	0x82, 0x34, 0x9f, 0xa9, 0xc2, 0xb9, 0x4c, 0x35, 0xfe, 0x59, 0x80, 0x2d, 0x8c, 0x54, 0x36, 0x20,
	0x2f, 0x0e, 0x2c, 0x79, 0x94, 0x57, 0x47, 0xd5, 0x12, 0x9d, 0x38, 0xbd, 0xea, 0xb1, 0x22, 0x4f,
	0x61, 0x5d, 0x2a, 0xaa, 0x52, 0x33, 0x49, 0x2b, 0xf7, 0x0f, 0x96, 0xae, 0xbc, 0x2e, 0xc2, 0x5c,
	0x0b, 0xd7, 0x4f, 0xa7, 0x52, 0x91, 0xfd, 0x1b, 0x47, 0x7f, 0x4e, 0xeb, 0x6d, 0x2d, 0x5f, 0x6f,
	0x14, 0x76, 0x67, 0x82, 0x62, 0x8b, 0xe0, 0xe7, 0x80, 0x1e, 0xe9, 0x91, 0x6e, 0x46, 0xed, 0xbd,
	0xe5, 0x0d, 0xb1, 0x2f, 0x4b, 0xa6, 0xe0, 0x4e, 0x0b, 0xca, 0x39, 0x0b, 0x09, 0xc0, 0xfa, 0xcb,
	0x93, 0xce, 0x49, 0xe7, 0xb3, 0xda, 0x15, 0xb2, 0x0d, 0xa5, 0xce, 0x2f, 0x3a, 0xed, 0x93, 0xe3,
	0xc3, 0xcf, 0x9f, 0xd6, 0x0a, 0xa4, 0x0c, 0x1b, 0xdd, 0x93, 0x76, 0xbb, 0xd3, 0xed, 0xd6, 0x56,
	0xf4, 0xe1, 0xc9, 0xe3, 0xc3, 0xe7, 0x27, 0x6e, 0xa7, 0x56, 0xbc, 0xff, 0xd7, 0x22, 0x5c, 0x6b,
	0xe3, 0xb5, 0x8f, 0xb3, 0x5b, 0xdb, 0xe6, 0x52, 0xf2, 0xdb, 0x02, 0x6c, 0xe5, 0x5b, 0x86, 0x3c,
	0x5c, 0xc6, 0xd4, 0x05, 0x5d, 0xbf, 0xf7, 0xe1, 0xe5, 0x81, 0x36, 0x5c, 0xbf, 0x2f, 0x40, 0x65,
	0xb6, 0x9d, 0xc8, 0x52, 0xed, 0xb2, 0xb0, 0x6f, 0xf7, 0x7e, 0xf2, 0x4d, 0xa0, 0xd6, 0x92, 0xdf,
	0x40, 0x39, 0x97, 0x4f, 0xb2, 0xd4, 0x5a, 0x70, 0xbe, 0x2b, 0xf6, 0x1e, 0x5e, 0x1a, 0x67, 0xee,
	0x6f, 0x7d, 0xfa, 0xcb, 0x47, 0x3e, 0x0f, 0x58, 0xf3, 0xd7, 0xa9, 0x54, 0x61, 0xdc, 0x54, 0xa3,
	0x03, 0x36, 0x62, 0xb1, 0xba, 0xcb, 0xe2, 0x41, 0x18, 0x33, 0xfc, 0x2f, 0xef, 0xc0, 0x28, 0xbc,
	0x3b, 0x51, 0x78, 0x60, 0x15, 0x1e, 0x88, 0xc4, 0xef, 0xad, 0x63, 0x8b, 0xbc, 0xff, 0xdf, 0x00,
	0x00, 0x00, 0xff, 0xff, 0x6e, 0xa6, 0xbd, 0x56, 0xe7, 0x15, 0x00, 0x00,
}
