package main

import (
	"bytes"
	"context"
	"flag"
	"io/ioutil"
	"net/http"
	"os"
	"path"
	"time"

	control "code.justin.tv/event-engineering/carrot-analytics/control/rpc"
	"code.justin.tv/event-engineering/carrot-analytics/executor/svc"
	"code.justin.tv/video/amzncorp"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/credentials"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/gobuffalo/packr/v2"
	"github.com/golang/protobuf/ptypes"
	"github.com/google/uuid"
	"github.com/sirupsen/logrus"
)

var (
	awsAccountID = "291428775132" // starfruit-support+analytics-prod@amazon.com
	awsRole      = "Admin"
	awsRegion    = "us-west-2"
)

var (
	redshiftPass = flag.String("redshiftPass", "", "Password to access redshift")
)

func init() {
	flag.Parse()
}

func main() {
	logger := logrus.New()
	logger.SetLevel(logrus.DebugLevel)

	credentials, err := midwayCredentials(awsAccountID, awsRole)
	if err != nil {
		panic(err)
	}

	sess := session.New(&aws.Config{
		Credentials: credentials,
		Region:      &awsRegion,
	})

	redshiftAddr := "localhost:5439"
	redshiftUser := "carrot-analyst"
	redshiftDatabase := "product"
	resultsBucketName := ""
	queriesTableName := ""

	queries := packr.New("queries", "../../../queries")

	// Create the Service
	executorServer := svc.New(sess, redshiftAddr, redshiftUser, *redshiftPass, redshiftDatabase, resultsBucketName, queriesTableName, queries, logger)

	//doSessionList(csaServer)
	doPlaySessionInfo(executorServer)
}

func doPlaySessionInfo(client svc.Client) {
	startDate, err := time.Parse(time.RFC3339, "2020-03-24T00:00:00Z")
	if err != nil {
		panic(err)
	}

	endDate, err := time.Parse(time.RFC3339, "2020-03-27T23:59:00Z")
	if err != nil {
		panic(err)
	}

	playSessionID := "f970108b760743adadb3527ddbbfbb85"

	pStart, err := ptypes.TimestampProto(startDate)
	if err != nil {
		panic(err)
	}

	pEnd, err := ptypes.TimestampProto(endDate)
	if err != nil {
		panic(err)
	}

	queryID := uuid.New().String()

	// Test your shit
	err = client.ExecuteQuery(context.Background(), queryID, "testing/"+queryID, &control.Query{
		StartDate: pStart,
		EndDate:   pEnd,
		QueryParams: &control.Query_PlaySessionInfoParams{
			PlaySessionInfoParams: &control.PlaySessionInfoParameters{
				PlaySessionId: playSessionID,
			},
		},
	})

	if err != nil {
		panic(err)
	}
}

func midwayCredentials(accountID, role string) (*credentials.Credentials, error) {
	midwayClient, err := midwayClient()
	if err != nil {
		return nil, err
	}

	return credentials.NewCredentials(&amzncorp.IsengardCredentials{
		AWSAccountID: accountID,
		IAMRoleName:  role,
		MidwayClient: midwayClient,
	}), nil

}

func midwayClient() (*http.Client, error) {
	cookieFile, err := readCookieFile()
	if err != nil {
		return nil, err
	}
	return amzncorp.MidwayClient(bytes.NewReader(cookieFile))
}

func readCookieFile() ([]byte, error) {
	home, err := os.UserHomeDir()
	if err != nil {
		return nil, err
	}

	f, err := os.Open(path.Join(home, ".midway/cookie"))
	if err != nil {
		return nil, err
	}

	defer f.Close()

	bs, err := ioutil.ReadAll(f)
	if err != nil {
		return nil, err
	}

	return bs, nil
}
