WITH stream_ids AS (
  SELECT DISTINCT ingest_session_id, stream_id
  FROM spade_lvs.transcode_stream_start iss
  WHERE iss.date >= '{{.StartDate}}' AND iss.date <= '{{.EndDate}}'
    AND iss.time_utc >= '{{.StartDateTime}}' AND iss.time_utc <= '{{.EndDateTime}}'
    AND iss.ingest_session_id = '{{.IngestSessionID}}'
), play_sessions AS (
  SELECT sids.ingest_session_id, vp.time_utc, vp.client_time_utc, vp.play_session_id, vp.broadcast_id, vp.manifest_cluster, vp.node, vp.asn, vp.time_since_load_start
  FROM spade_lvs."video-play" vp
  INNER JOIN stream_ids sids ON sids.stream_id = vp.broadcast_id
  WHERE vp.date >= '{{.StartDate}}' AND vp.date <= '{{.EndDate}}'
    AND vp.time_utc >= '{{.StartDateTime}}' AND vp.time_utc <= '{{.EndDateTime}}'
  GROUP BY 1, 2, 3, 4, 5, 6, 7, 8, 9
), minutes_watched AS (
  SELECT play_session_id, COUNT(*) as minutes_watched, MAX(time_utc) as last_mw
  FROM spade_lvs."minute-watched" mw
  INNER JOIN stream_ids sids ON sids.stream_id = mw.broadcast_id
  WHERE mw.date >= '{{.StartDate}}' AND mw.date <= '{{.EndDate}}'
    AND mw.time_utc >= '{{.StartDateTime}}' AND mw.time_utc <= '{{.EndDateTime}}'
  GROUP BY play_session_id
  HAVING minutes_watched > 0
)
SELECT mw.minutes_watched, mw.last_mw, ps.time_utc, ps.client_time_utc, ps.play_session_id, ps.broadcast_id, ps.manifest_cluster, ps.node, ps.asn, ps.time_since_load_start
FROM play_sessions ps
INNER JOIN minutes_watched mw on ps.play_session_id = mw.play_session_id
ORDER BY mw.minutes_watched DESC
LIMIT 20
;

WITH stream_ids AS (
  SELECT DISTINCT ingest_session_id, stream_id
  FROM spade_lvs.transcode_stream_start iss
  WHERE iss.date >= '{{.StartDate}}' AND iss.date <= '{{.EndDate}}'
    AND iss.time_utc >= '{{.StartDateTime}}' AND iss.time_utc <= '{{.EndDateTime}}'
    AND iss.ingest_session_id = '{{.IngestSessionID}}'
), play_sessions AS (
  SELECT sids.ingest_session_id, vp.time_utc, vp.client_time_utc, vp.play_session_id, vp.broadcast_id, vp.manifest_cluster, vp.node, vp.asn, vp.time_since_load_start
  FROM spade_lvs."video-play" vp
  INNER JOIN stream_ids sids ON sids.stream_id = vp.broadcast_id
  WHERE vp.date >= '{{.StartDate}}' AND vp.date <= '{{.EndDate}}'
    AND vp.time_utc >= '{{.StartDateTime}}' AND vp.time_utc <= '{{.EndDateTime}}'
  GROUP BY 1, 2, 3, 4, 5, 6, 7, 8, 9
), minutes_watched AS (
  SELECT play_session_id, COUNT(*) as minutes_watched, MAX(time_utc) as last_mw
  FROM spade_lvs."minute-watched" mw
  INNER JOIN stream_ids sids ON sids.stream_id = mw.broadcast_id
  WHERE mw.date >= '{{.StartDate}}' AND mw.date <= '{{.EndDate}}'
    AND mw.time_utc >= '{{.StartDateTime}}' AND mw.time_utc <= '{{.EndDateTime}}'
  GROUP BY play_session_id
  HAVING minutes_watched > 0
), buffer_empties AS (
  SELECT play_session_id, COUNT(*) as buffer_empties
  FROM spade_lvs."buffer-empty" be
  INNER JOIN stream_ids sids ON sids.stream_id = be.broadcast_id
  WHERE be.date >= '{{.StartDate}}' AND be.date <= '{{.EndDate}}'
    AND be.time_utc >= '{{.StartDateTime}}' AND be.time_utc <= '{{.EndDateTime}}'
  GROUP BY play_session_id
)
SELECT mw.minutes_watched, mw.last_mw, ISNULL(be.buffer_empties, 0) as buffer_empties, ISNULL(be.buffer_empties, 0)::float / mw.minutes_watched as be_mw,
  ps.time_utc, ps.client_time_utc, ps.play_session_id, ps.broadcast_id, ps.manifest_cluster, ps.node, ps.asn, ps.time_since_load_start
FROM play_sessions ps
INNER JOIN minutes_watched mw on ps.play_session_id = mw.play_session_id
LEFT JOIN buffer_empties be on ps.play_session_id = be.play_session_id
ORDER BY be_mw DESC
LIMIT 20
;
