/*
  Replacement Variables:
  $1 - play_session_id
  $2 - start_time
  $3 - end_time
  $4 - start_time - 1 day because we chunk our data in "Pacific Time" because we're dumb
  $5 - end_time + 1 day because we chunk our data in "Pacific Time" because we're dumb
*/

-- Playback Summary
WITH total_mw AS (
  SELECT
    COUNT(*) AS total,
    AVG(hls_latency_broadcaster) AS avg_latency,
    PERCENTILE_CONT(0.50) WITHIN GROUP(ORDER BY hls_latency_broadcaster) AS p50_latency,
    MAX("time") AS last_mw,
    MIN("time") AS first_mw,
    play_session_id
  FROM spade_lvs."minute-watched"
  WHERE date >= '{{.StartDate}}' AND date <= '{{.EndDate}}'
  AND time_utc >= '{{.StartDateTime}}' AND time_utc <= '{{.EndDateTime}}'
  AND play_session_id = '{{.PlaySessionID}}'
  GROUP BY play_session_id
  ORDER BY total DESC LIMIT 1
), total_be AS (
  SELECT
    COUNT(*) AS total,
    play_session_id
  FROM spade_lvs."buffer-empty"
  WHERE date >= '{{.StartDate}}' AND date <= '{{.EndDate}}'
  AND time_utc >= '{{.StartDateTime}}' AND time_utc <= '{{.EndDateTime}}'
  AND play_session_id = '{{.PlaySessionID}}'
  GROUP BY play_session_id
  ORDER BY total DESC LIMIT 1
), total_errors AS (
  SELECT
    COUNT(*) AS total,
    play_session_id
  FROM spade_lvs."video_error"
  WHERE date >= '{{.StartDate}}' AND date <= '{{.EndDate}}'
  AND time_utc >= '{{.StartDateTime}}' AND time_utc <= '{{.EndDateTime}}'
  AND play_session_id = '{{.PlaySessionID}}'
  GROUP BY play_session_id
  ORDER BY total DESC LIMIT 1
), total_buffer_2_seconds AS (
  SELECT
    COUNT(*) AS total,
    play_session_id
  FROM spade_lvs."buffer_2_seconds"
  WHERE date >= '{{.StartDate}}' AND date <= '{{.EndDate}}'
  AND time_utc >= '{{.StartDateTime}}' AND time_utc <= '{{.EndDateTime}}'
  AND play_session_id = '{{.PlaySessionID}}'
  GROUP BY play_session_id
  ORDER BY total DESC LIMIT 1
)
SELECT
  total_mw.first_mw AS first_mw_time,
  total_mw.last_mw AS last_mw_time,
  ISNULL(total_mw.total, 0) AS minutes_watched,
  ISNULL(total_be.total, 0) AS buffer_empties,
  ISNULL(total_errors.total, 0) AS errors,
  ISNULL((total_buffer_2_seconds.total * 2), 0) AS seconds_buffering,
  ISNULL((seconds_buffering / (minutes_watched * 60.0)) * 100, 0) AS percent_time_buffering,
  ISNULL(avg_latency, 0),
  ISNULL(p50_latency, 0)
FROM total_mw
LEFT JOIN total_be ON total_mw.play_session_id = total_be.play_session_id
LEFT JOIN total_errors ON total_mw.play_session_id = total_errors.play_session_id
LEFT JOIN total_buffer_2_seconds ON total_mw.play_session_id = total_buffer_2_seconds.play_session_id
;

-- Video Errors
SELECT
  time_utc,
  ISNULL(video_error_code, 0) as video_error_code,
  ISNULL(video_error_message, '') as video_error_message,
  ISNULL(video_error_recoverable, FALSE) as video_error_recoverable,
  ISNULL(video_error_result, '') as video_error_result,
  ISNULL(video_error_source, '') as video_error_source,
  ISNULL(video_error_value, 0) as video_error_value,
  ISNULL(video_buffer_size, 0) as video_buffer_size,
  ISNULL(buffer_empty_count, 0) as buffer_empty_count,
  ISNULL(playing_ad, FALSE) as playing_ad,
  ISNULL(url, '') as url,
  ISNULL(error_extra, 0) as error_extra,
  ISNULL(error_type, '') as error_type,
  ISNULL(error_what, 0) as error_what
FROM spade_lvs."video_error"
WHERE date >= '{{.StartDate}}' AND date <= '{{.EndDate}}'
  AND time_utc >= '{{.StartDateTime}}' AND time_utc <= '{{.EndDateTime}}'
  AND play_session_id = '{{.PlaySessionID}}'
ORDER BY time_utc ASC
;

-- Video Play Info
SELECT
  time_utc,
  ISNULL(platform, '') as platform,
  ISNULL(player, '') as player,
  ISNULL(core_version, '') as core_version,
  ISNULL(backend, '') as backend,
  ISNULL(backend_version, '') as backend_version,
  ISNULL(channel, '') as channel,
  ISNULL(content_id, '') as content_id,
  ISNULL(customer_id, '') as customer_id,
  ISNULL(cluster, '') as cluster,
  ISNULL(node, '') as node,
  ISNULL(serving_id, '') as serving_id,
  ISNULL(country, '') as country,
  ISNULL(live, FALSE) as live,
  ISNULL(vod_cdn_origin, '') as vod_cdn_origin,
  ISNULL(low_latency, FALSE) as low_latency,
  ISNULL(client_app, '') as client_app,
  ISNULL(app_version, '') as app_version,
  ISNULL(browser_family, '') as browser_family,
  ISNULL(browser_version, '') as browser_version,
  ISNULL(os, '') as os,
  ISNULL(os_name, '') as os_name,
  ISNULL(os_version, '') as os_version,
  ISNULL(device_manufacturer, '') device_manufacturer,
  ISNULL(time_for_player_core_load, 0) AS time_for_player_core_load,
  ISNULL(time_for_token_load, 0) AS time_for_token_load,
  ISNULL(time_to_master_playlist_ready, 0) AS time_to_master_playlist_ready,
  ISNULL(time_to_variant_ready, 0) AS time_to_variant_ready,
  ISNULL(time_to_segment_ready, 0) AS time_to_segment_ready,
  ISNULL(time_since_load_start, 0) AS time_since_load_start,
  ISNULL(device_model, '') as device_model,
  ISNULL(device_os_version, '') as device_os_version
FROM spade_lvs."video-play" AS vp
WHERE vp.date >= '{{.StartDate}}' AND vp.date <= '{{.EndDate}}'
  AND vp.time_utc >= '{{.StartDateTime}}' AND vp.time_utc <= '{{.EndDateTime}}'
  AND vp.play_session_id = '{{.PlaySessionID}}'
  ORDER BY vp.time_utc ASC
  LIMIT 1
;
