#!/usr/bin/env node
import 'source-map-support/register';
import * as cdk from '@aws-cdk/core';
import { CarrotControlStack } from '../lib/carrot-control-stack';

const app = new cdk.App();
new CarrotControlStack(app, 'carrot-control-stg', {
  cdkProps: {
    env: {
      region: 'us-west-2',
      account: '134277936734',
    },
  },
  vpcId: 'vpc-0ba8a2483a591a259',
  ccProps: {
    invokeFunctionRoles: [
      'arn:aws:iam::134277936734:role/support-portal-stg-PortalAppPortalLambdaServiceRol-RYPPQ6X2TDCI' // Starfruit Support Portal
    ],
    carrotStreamAnalysisLambdaARN: 'arn:aws:lambda:us-west-2:134277936734:function:carrot-stream-analysis-st-CarrotStreamAnalysis66AA-GL65ALU6B8B5',
    carrotAnalyticsControlLambdaARN: 'arn:aws:lambda:us-west-2:291428775132:function:carrot-analytics-stg-CarrotAnalyticsCarrotAnalytic-CEDFZQIN5DTY',
    carrotSystemHealthLambdaARN: 'arn:aws:lambda:us-west-2:134277936734:function:carrot-system-health-stg-CarrotSystemHealthCFF3E61-XQQLH8SLYT9F',
    carrotRtmpRecorderLambdaARN: 'arn:aws:lambda:us-west-2:134277936734:function:carrot-rtmp-recorder-api-APIRecorderServiceF507BB-M5X5M3TJGKG3',
    carrotOmnibarLambdaARN: 'arn:aws:lambda:us-west-2:134277936734:function:carrot-omnibar-stg-OmnibarFunction2F151B77-M9L191IQKN42',
    iocpHost: "iocp.live-video.a2z.com",
    iocpStage: "prod",
    iocpArn: "*",
    bindleLockConfig: {
      systemAccessBindleLockID: 'amzn1.bindle.resource.veqpbhnztsbu6tqeuqmq',
      toolsAccessBindleLockID: 'amzn1.bindle.resource.3b7x5roiuykknb575e7a',
      twitchDataBindleLockID: 'amzn1.bindle.resource.n3bgins4u6tdfvfwsxla',
    },
    isengardDevRole: 'arn:aws:iam::134277936734:role/CarrotDevelopers',
  }
});

new CarrotControlStack(app, 'carrot-control-prod', {
  cdkProps: {
    env: {
      region: 'us-west-2',
      account: '782947612856',
    },
    terminationProtection: true,
  },
  vpcId: 'vpc-094f73121cb30db65',
  ccProps: {
    invokeFunctionRoles: [
      'arn:aws:iam::782947612856:role/support-portal-prod-PortalAppPortalLambdaServiceRo-1AZEGN7TNZZFA' // Starfruit Support Portal
    ],
    carrotStreamAnalysisLambdaARN: 'arn:aws:lambda:us-west-2:782947612856:function:carrot-stream-analysis-pr-CarrotStreamAnalysis66AA-VPB1VZ30TXWK',
    carrotAnalyticsControlLambdaARN: 'arn:aws:lambda:us-west-2:291428775132:function:carrot-analytics-prod-CarrotAnalyticsCarrotAnalyti-7F0OU9CXIRNA',
    carrotSystemHealthLambdaARN: 'arn:aws:lambda:us-west-2:782947612856:function:carrot-system-health-prod-CarrotSystemHealthCFF3E6-N4FLHJPC2BJ5',
    carrotRtmpRecorderLambdaARN: 'arn:aws:lambda:us-west-2:782947612856:function:carrot-rtmp-recorder-api-APIRecorderServiceF507BB-CT0AFJX06PWH',
    carrotOmnibarLambdaARN: 'arn:aws:lambda:us-west-2:782947612856:function:carrot-omnibar-prod-OmnibarFunction2F151B77-KOV9UFSJNDAI',
    iocpHost: "iocp.live-video.a2z.com",
    iocpStage: "prod",
    iocpArn: "*",
    bindleLockConfig: {
      systemAccessBindleLockID: 'amzn1.bindle.resource.ekm65d25656s2ds5vaqa',
      toolsAccessBindleLockID: 'amzn1.bindle.resource.aqay6nfsvtz3huav7qqq',
      twitchDataBindleLockID: 'amzn1.bindle.resource.z7nmmloavuoikqbayopa',
    },
    isengardDevRole: '',
  }
});
