import * as cdk from '@aws-cdk/core';
import * as ec2 from '@aws-cdk/aws-ec2';

import { CarrotControl, CCProps } from './carrot-control/carrot-control'

export interface CarrotControlProps {
  cdkProps: cdk.StackProps;
  ccProps: CCProps;
  vpcId: string
}

export class CarrotControlStack extends cdk.Stack {
  constructor(scope: cdk.Construct, id: string, props: CarrotControlProps) {
    super(scope, id, props.cdkProps);

    let vpc = ec2.Vpc.fromLookup(this, 'CarrotVpcRef', {
      vpcId: props.vpcId,
    })

    new CarrotControl(this, 'CarrotControl', vpc, props.ccProps)
  }
}
