package main

import (
	"code.justin.tv/event-engineering/carrot-control/pkg/svc"
	"context"
	"encoding/json"
	"fmt"

	twirpLambda "code.justin.tv/amzn/TwirpGoLangAWSTransports/lambda"
	"code.justin.tv/coleiain/isengard-dev-helper/pkg/credentials"
	ccc "code.justin.tv/event-engineering/carrot-control/pkg/client"
	rpc "code.justin.tv/event-engineering/carrot-control/pkg/rpc"
	crr "code.justin.tv/event-engineering/carrot-rtmp-recorder/pkg/rpc"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/lambda"
	"github.com/sirupsen/logrus"
)

var (
	awsAccountID = "134277936734" // starfruit-support+carrot-stg@amazon.com
	isengardRole = "Admin"
	awsRegion    = "us-west-2"
	lambdaARN    = "arn:aws:lambda:us-west-2:134277936734:function:carrot-control-stg-CarrotControl89B6CA77-3BP4UEI0KLVD"
)

func main() {
	logger := logrus.New()
	logger.SetLevel(logrus.DebugLevel)

	credentials, err := credentials.GetIsengardCredentials(awsAccountID, isengardRole)

	if err != nil {
		panic(err)
	}

	sess, err := session.NewSession(&aws.Config{
		Region:      aws.String(awsRegion),
		Credentials: credentials,
	})

	if err != nil {
		panic(err)
	}

	client := rpc.NewCarrotControlProtobufClient("https://would.you.like.a.carrot.twitch.tv", ccc.New("localdev", twirpLambda.NewClient(lambda.New(sess), lambdaARN)))

	doSomething(client)
}

func doSomething(client rpc.CarrotControl) {
	ctx := context.Background()
	ctx = svc.WithUserID(ctx, "coleiain")

	resp, err := client.ListCaptureEndpoints(ctx, &crr.ListCaptureEndpointsRequest{
		Owner: "coleiain",
	})

	if err != nil {
		fmt.Println(err)
		return
	}

	bytes, _ := json.MarshalIndent(resp, "", "  ")
	fmt.Println(string(bytes))
}
