package auditor

import (
	"github.com/sirupsen/logrus"
)

type logauditor struct {
	logger logrus.FieldLogger
}

// NewLogAuditor creates an auditor with a logger backend, this is best for working locally
func NewLogAuditor(logger logrus.FieldLogger) Auditor {
	return &logauditor{
		logger: logger.WithField("Module", "Auditor"),
	}
}

func (a *logauditor) CreateAudit(clientID, userID string, audit Audit) {
	a.logger.WithFields(logrus.Fields{
		"client_id":       clientID,
		"user_identifier": userID,
		"audit":           audit,
	}).Info("Created Audit")
}
