package client

import (
	"errors"
	"net/http"

	"code.justin.tv/event-engineering/carrot-control/pkg/svc"
)

// HTTPClient is an interface that is fulfilled by *http.Client
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

type client struct {
	baseClient HTTPClient
	clientID   string
}

func New(clientID string, baseClient HTTPClient) HTTPClient {
	return &client{
		baseClient: baseClient,
		clientID:   clientID,
	}
}

func (c *client) Do(req *http.Request) (*http.Response, error) {
	if c.clientID == "" {
		return nil, errors.New("Please provide a client ID to the carrot control client")
	}
	req.Header.Set(svc.ClientIDHeader, c.clientID)

	userID := svc.UserID(req.Context())
	if userID == "" {
		return nil, errors.New("Please provide a user ID")
	}
	req.Header.Set(svc.AuditUserIDHeader, userID)

	return c.baseClient.Do(req)
}
