// Code generated by protoc-gen-twirp v8.1.0, DO NOT EDIT.
// source: rpc.proto

package rpc

import context "context"
import fmt "fmt"
import http "net/http"
import ioutil "io/ioutil"
import json "encoding/json"
import strconv "strconv"
import strings "strings"

import protojson "google.golang.org/protobuf/encoding/protojson"
import proto "google.golang.org/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

import starfruit_carrot_analytics_control "code.justin.tv/event-engineering/carrot-analytics/control/rpc"
import starfruit_carrot_omnibar "code.justin.tv/event-engineering/carrot-omnibar/pkg/rpc"
import starfruit_carrot_rtmp_recorder "code.justin.tv/event-engineering/carrot-rtmp-recorder/pkg/rpc"
import starfruit_carrot_stream_analysis "code.justin.tv/event-engineering/carrot-stream-analysis/pkg/rpc"
import starfruit_carrot_system_health "code.justin.tv/event-engineering/carrot-system-health/pkg/rpc"
import twitch_video_starfruitiocp "code.justin.tv/amzn/StarfruitIOCPTwirp"
import twitch_video_starfruitiocp1 "code.justin.tv/amzn/StarfruitIOCPTwirp"
import twitch_video_starfruitiocp2 "code.justin.tv/amzn/StarfruitIOCPTwirp"
import twitch_video_starfruitsec "code.justin.tv/amzn/StarfruitSECTwirp"

import bytes "bytes"
import errors "errors"
import io "io"
import path "path"
import url "net/url"

// Version compatibility assertion.
// If the constant is not defined in the package, that likely means
// the package needs to be updated to work with this generated code.
// See https://twitchtv.github.io/twirp/docs/version_matrix.html
const _ = twirp.TwirpPackageMinVersion_8_1_0

// =======================
// CarrotControl Interface
// =======================

type CarrotControl interface {
	GetModuleAccess(context.Context, *GetModuleAccessRequest) (*GetModuleAccessResponse, error)

	// Carrot Stream Analysis
	GetChannelSessions(context.Context, *starfruit_carrot_stream_analysis.GetChannelSessionsRequest) (*starfruit_carrot_stream_analysis.GetChannelSessionsResponse, error)

	GetSessionData(context.Context, *starfruit_carrot_stream_analysis.GetSessionDataRequest) (*starfruit_carrot_stream_analysis.GetSessionDataResponse, error)

	GetCapturedFileDetail(context.Context, *starfruit_carrot_stream_analysis.GetCapturedFileDetailRequest) (*starfruit_carrot_stream_analysis.GetCapturedFileDetailResponse, error)

	GetCapturedFileDownloadLink(context.Context, *starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkRequest) (*starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkResponse, error)

	// IOCP
	GetStreamConfig(context.Context, *GetStreamConfigRequest) (*GetStreamConfigResponse, error)

	ListStreamConfigs(context.Context, *ListStreamConfigsRequest) (*twitch_video_starfruitiocp.ListStreamConfigsResponse, error)

	ListStreamConfigsByRecordingConfig(context.Context, *ListStreamConfigsByRecordingConfigRequest) (*twitch_video_starfruitiocp.ListStreamConfigsByRecordingConfigResponse, error)

	GetStreamKey(context.Context, *GetStreamKeyRequest) (*twitch_video_starfruitiocp1.StreamKey, error)

	ListStreamKeysForContent(context.Context, *ListStreamKeysForContentRequest) (*twitch_video_starfruitiocp1.ListStreamKeysForContentResponse, error)

	GetPlaybackKey(context.Context, *GetPlaybackKeyRequest) (*twitch_video_starfruitiocp2.GetPlaybackKeyResponse, error)

	ListPlaybackKeys(context.Context, *ListPlaybackKeysRequest) (*twitch_video_starfruitiocp2.ListPlaybackKeysResponse, error)

	GetPlaybackAuthorization(context.Context, *GetPlaybackAuthorizationRequest) (*twitch_video_starfruitiocp2.GetPlaybackAuthorizationResponse, error)

	ListStreamEvents(context.Context, *ListStreamEventsRequest) (*twitch_video_starfruitsec.ListStreamEventsResponse, error)

	ListLimitBreachEvents(context.Context, *ListLimitBreachEventsRequest) (*twitch_video_starfruitsec.ListLimitBreachEventsResponse, error)

	// Carrot Analytics
	EnqueueQuery(context.Context, *starfruit_carrot_analytics_control.EnqueueQueryRequest) (*starfruit_carrot_analytics_control.EnqueueQueryResponse, error)

	GetQueryResult(context.Context, *starfruit_carrot_analytics_control.GetQueryResultRequest) (*starfruit_carrot_analytics_control.GetQueryResultResponse, error)

	ListQueries(context.Context, *starfruit_carrot_analytics_control.ListQueriesRequest) (*starfruit_carrot_analytics_control.ListQueriesResponse, error)

	// Carrot System Health
	GetPoPHealth(context.Context, *starfruit_carrot_system_health.GetPoPHealthRequest) (*starfruit_carrot_system_health.GetPoPHealthResponse, error)

	// Carrot RTMP Recorder
	GetAvailableCaptureEndpointRegions(context.Context, *starfruit_carrot_rtmp_recorder.GetAvailableCaptureEndpointRegionsRequest) (*starfruit_carrot_rtmp_recorder.AvailableCaptureEndpointRegions, error)

	CreateCaptureEndpoint(context.Context, *starfruit_carrot_rtmp_recorder.CreateCaptureEndpointRequest) (*starfruit_carrot_rtmp_recorder.CaptureEndpointInfo, error)

	GetCaptureEndpoint(context.Context, *starfruit_carrot_rtmp_recorder.GetCaptureEndpointRequest) (*starfruit_carrot_rtmp_recorder.CaptureEndpointDetail, error)

	ListCaptureEndpoints(context.Context, *starfruit_carrot_rtmp_recorder.ListCaptureEndpointsRequest) (*starfruit_carrot_rtmp_recorder.ListCaptureEndpointsResponse, error)

	CreateRTMPDump(context.Context, *starfruit_carrot_rtmp_recorder.CreateRTMPDumpRequest) (*starfruit_carrot_rtmp_recorder.CreateRTMPDumpResponse, error)

	GetRTMPDump(context.Context, *starfruit_carrot_rtmp_recorder.GetRTMPDumpRequest) (*starfruit_carrot_rtmp_recorder.RTMPDumpSummary, error)

	ListRTMPDumps(context.Context, *starfruit_carrot_rtmp_recorder.ListRTMPDumpsRequest) (*starfruit_carrot_rtmp_recorder.ListRTMPDumpsResponse, error)

	// Omnibar
	WhatIs(context.Context, *starfruit_carrot_omnibar.This) (*starfruit_carrot_omnibar.Thing, error)
}

// =============================
// CarrotControl Protobuf Client
// =============================

type carrotControlProtobufClient struct {
	client      HTTPClient
	urls        [27]string
	interceptor twirp.Interceptor
	opts        twirp.ClientOptions
}

// NewCarrotControlProtobufClient creates a Protobuf client that implements the CarrotControl interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewCarrotControlProtobufClient(baseURL string, client HTTPClient, opts ...twirp.ClientOption) CarrotControl {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	// Using ReadOpt allows backwards and forwads compatibility with new options in the future
	literalURLs := false
	_ = clientOpts.ReadOpt("literalURLs", &literalURLs)
	var pathPrefix string
	if ok := clientOpts.ReadOpt("pathPrefix", &pathPrefix); !ok {
		pathPrefix = "/twirp" // default prefix
	}

	// Build method URLs: <baseURL>[<prefix>]/<package>.<Service>/<Method>
	serviceURL := sanitizeBaseURL(baseURL)
	serviceURL += baseServicePath(pathPrefix, "starfruit.carrot_control", "CarrotControl")
	urls := [27]string{
		serviceURL + "GetModuleAccess",
		serviceURL + "GetChannelSessions",
		serviceURL + "GetSessionData",
		serviceURL + "GetCapturedFileDetail",
		serviceURL + "GetCapturedFileDownloadLink",
		serviceURL + "GetStreamConfig",
		serviceURL + "ListStreamConfigs",
		serviceURL + "ListStreamConfigsByRecordingConfig",
		serviceURL + "GetStreamKey",
		serviceURL + "ListStreamKeysForContent",
		serviceURL + "GetPlaybackKey",
		serviceURL + "ListPlaybackKeys",
		serviceURL + "GetPlaybackAuthorization",
		serviceURL + "ListStreamEvents",
		serviceURL + "ListLimitBreachEvents",
		serviceURL + "EnqueueQuery",
		serviceURL + "GetQueryResult",
		serviceURL + "ListQueries",
		serviceURL + "GetPoPHealth",
		serviceURL + "GetAvailableCaptureEndpointRegions",
		serviceURL + "CreateCaptureEndpoint",
		serviceURL + "GetCaptureEndpoint",
		serviceURL + "ListCaptureEndpoints",
		serviceURL + "CreateRTMPDump",
		serviceURL + "GetRTMPDump",
		serviceURL + "ListRTMPDumps",
		serviceURL + "WhatIs",
	}

	return &carrotControlProtobufClient{
		client:      client,
		urls:        urls,
		interceptor: twirp.ChainInterceptors(clientOpts.Interceptors...),
		opts:        clientOpts,
	}
}

func (c *carrotControlProtobufClient) GetModuleAccess(ctx context.Context, in *GetModuleAccessRequest) (*GetModuleAccessResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "GetModuleAccess")
	caller := c.callGetModuleAccess
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetModuleAccessRequest) (*GetModuleAccessResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetModuleAccessRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetModuleAccessRequest) when calling interceptor")
					}
					return c.callGetModuleAccess(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetModuleAccessResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetModuleAccessResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlProtobufClient) callGetModuleAccess(ctx context.Context, in *GetModuleAccessRequest) (*GetModuleAccessResponse, error) {
	out := new(GetModuleAccessResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlProtobufClient) GetChannelSessions(ctx context.Context, in *starfruit_carrot_stream_analysis.GetChannelSessionsRequest) (*starfruit_carrot_stream_analysis.GetChannelSessionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelSessions")
	caller := c.callGetChannelSessions
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *starfruit_carrot_stream_analysis.GetChannelSessionsRequest) (*starfruit_carrot_stream_analysis.GetChannelSessionsResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_stream_analysis.GetChannelSessionsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_stream_analysis.GetChannelSessionsRequest) when calling interceptor")
					}
					return c.callGetChannelSessions(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_stream_analysis.GetChannelSessionsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_stream_analysis.GetChannelSessionsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlProtobufClient) callGetChannelSessions(ctx context.Context, in *starfruit_carrot_stream_analysis.GetChannelSessionsRequest) (*starfruit_carrot_stream_analysis.GetChannelSessionsResponse, error) {
	out := new(starfruit_carrot_stream_analysis.GetChannelSessionsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlProtobufClient) GetSessionData(ctx context.Context, in *starfruit_carrot_stream_analysis.GetSessionDataRequest) (*starfruit_carrot_stream_analysis.GetSessionDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "GetSessionData")
	caller := c.callGetSessionData
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *starfruit_carrot_stream_analysis.GetSessionDataRequest) (*starfruit_carrot_stream_analysis.GetSessionDataResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_stream_analysis.GetSessionDataRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_stream_analysis.GetSessionDataRequest) when calling interceptor")
					}
					return c.callGetSessionData(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_stream_analysis.GetSessionDataResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_stream_analysis.GetSessionDataResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlProtobufClient) callGetSessionData(ctx context.Context, in *starfruit_carrot_stream_analysis.GetSessionDataRequest) (*starfruit_carrot_stream_analysis.GetSessionDataResponse, error) {
	out := new(starfruit_carrot_stream_analysis.GetSessionDataResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlProtobufClient) GetCapturedFileDetail(ctx context.Context, in *starfruit_carrot_stream_analysis.GetCapturedFileDetailRequest) (*starfruit_carrot_stream_analysis.GetCapturedFileDetailResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "GetCapturedFileDetail")
	caller := c.callGetCapturedFileDetail
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *starfruit_carrot_stream_analysis.GetCapturedFileDetailRequest) (*starfruit_carrot_stream_analysis.GetCapturedFileDetailResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_stream_analysis.GetCapturedFileDetailRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_stream_analysis.GetCapturedFileDetailRequest) when calling interceptor")
					}
					return c.callGetCapturedFileDetail(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_stream_analysis.GetCapturedFileDetailResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_stream_analysis.GetCapturedFileDetailResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlProtobufClient) callGetCapturedFileDetail(ctx context.Context, in *starfruit_carrot_stream_analysis.GetCapturedFileDetailRequest) (*starfruit_carrot_stream_analysis.GetCapturedFileDetailResponse, error) {
	out := new(starfruit_carrot_stream_analysis.GetCapturedFileDetailResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlProtobufClient) GetCapturedFileDownloadLink(ctx context.Context, in *starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkRequest) (*starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "GetCapturedFileDownloadLink")
	caller := c.callGetCapturedFileDownloadLink
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkRequest) (*starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkRequest) when calling interceptor")
					}
					return c.callGetCapturedFileDownloadLink(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlProtobufClient) callGetCapturedFileDownloadLink(ctx context.Context, in *starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkRequest) (*starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkResponse, error) {
	out := new(starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlProtobufClient) GetStreamConfig(ctx context.Context, in *GetStreamConfigRequest) (*GetStreamConfigResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamConfig")
	caller := c.callGetStreamConfig
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetStreamConfigRequest) (*GetStreamConfigResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetStreamConfigRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetStreamConfigRequest) when calling interceptor")
					}
					return c.callGetStreamConfig(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetStreamConfigResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetStreamConfigResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlProtobufClient) callGetStreamConfig(ctx context.Context, in *GetStreamConfigRequest) (*GetStreamConfigResponse, error) {
	out := new(GetStreamConfigResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlProtobufClient) ListStreamConfigs(ctx context.Context, in *ListStreamConfigsRequest) (*twitch_video_starfruitiocp.ListStreamConfigsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamConfigs")
	caller := c.callListStreamConfigs
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *ListStreamConfigsRequest) (*twitch_video_starfruitiocp.ListStreamConfigsResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListStreamConfigsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListStreamConfigsRequest) when calling interceptor")
					}
					return c.callListStreamConfigs(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*twitch_video_starfruitiocp.ListStreamConfigsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*twitch_video_starfruitiocp.ListStreamConfigsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlProtobufClient) callListStreamConfigs(ctx context.Context, in *ListStreamConfigsRequest) (*twitch_video_starfruitiocp.ListStreamConfigsResponse, error) {
	out := new(twitch_video_starfruitiocp.ListStreamConfigsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlProtobufClient) ListStreamConfigsByRecordingConfig(ctx context.Context, in *ListStreamConfigsByRecordingConfigRequest) (*twitch_video_starfruitiocp.ListStreamConfigsByRecordingConfigResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamConfigsByRecordingConfig")
	caller := c.callListStreamConfigsByRecordingConfig
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *ListStreamConfigsByRecordingConfigRequest) (*twitch_video_starfruitiocp.ListStreamConfigsByRecordingConfigResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListStreamConfigsByRecordingConfigRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListStreamConfigsByRecordingConfigRequest) when calling interceptor")
					}
					return c.callListStreamConfigsByRecordingConfig(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*twitch_video_starfruitiocp.ListStreamConfigsByRecordingConfigResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*twitch_video_starfruitiocp.ListStreamConfigsByRecordingConfigResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlProtobufClient) callListStreamConfigsByRecordingConfig(ctx context.Context, in *ListStreamConfigsByRecordingConfigRequest) (*twitch_video_starfruitiocp.ListStreamConfigsByRecordingConfigResponse, error) {
	out := new(twitch_video_starfruitiocp.ListStreamConfigsByRecordingConfigResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlProtobufClient) GetStreamKey(ctx context.Context, in *GetStreamKeyRequest) (*twitch_video_starfruitiocp1.StreamKey, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamKey")
	caller := c.callGetStreamKey
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetStreamKeyRequest) (*twitch_video_starfruitiocp1.StreamKey, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetStreamKeyRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetStreamKeyRequest) when calling interceptor")
					}
					return c.callGetStreamKey(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*twitch_video_starfruitiocp1.StreamKey)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*twitch_video_starfruitiocp1.StreamKey) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlProtobufClient) callGetStreamKey(ctx context.Context, in *GetStreamKeyRequest) (*twitch_video_starfruitiocp1.StreamKey, error) {
	out := new(twitch_video_starfruitiocp1.StreamKey)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlProtobufClient) ListStreamKeysForContent(ctx context.Context, in *ListStreamKeysForContentRequest) (*twitch_video_starfruitiocp1.ListStreamKeysForContentResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamKeysForContent")
	caller := c.callListStreamKeysForContent
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *ListStreamKeysForContentRequest) (*twitch_video_starfruitiocp1.ListStreamKeysForContentResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListStreamKeysForContentRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListStreamKeysForContentRequest) when calling interceptor")
					}
					return c.callListStreamKeysForContent(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*twitch_video_starfruitiocp1.ListStreamKeysForContentResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*twitch_video_starfruitiocp1.ListStreamKeysForContentResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlProtobufClient) callListStreamKeysForContent(ctx context.Context, in *ListStreamKeysForContentRequest) (*twitch_video_starfruitiocp1.ListStreamKeysForContentResponse, error) {
	out := new(twitch_video_starfruitiocp1.ListStreamKeysForContentResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlProtobufClient) GetPlaybackKey(ctx context.Context, in *GetPlaybackKeyRequest) (*twitch_video_starfruitiocp2.GetPlaybackKeyResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "GetPlaybackKey")
	caller := c.callGetPlaybackKey
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetPlaybackKeyRequest) (*twitch_video_starfruitiocp2.GetPlaybackKeyResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetPlaybackKeyRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetPlaybackKeyRequest) when calling interceptor")
					}
					return c.callGetPlaybackKey(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*twitch_video_starfruitiocp2.GetPlaybackKeyResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*twitch_video_starfruitiocp2.GetPlaybackKeyResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlProtobufClient) callGetPlaybackKey(ctx context.Context, in *GetPlaybackKeyRequest) (*twitch_video_starfruitiocp2.GetPlaybackKeyResponse, error) {
	out := new(twitch_video_starfruitiocp2.GetPlaybackKeyResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlProtobufClient) ListPlaybackKeys(ctx context.Context, in *ListPlaybackKeysRequest) (*twitch_video_starfruitiocp2.ListPlaybackKeysResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "ListPlaybackKeys")
	caller := c.callListPlaybackKeys
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *ListPlaybackKeysRequest) (*twitch_video_starfruitiocp2.ListPlaybackKeysResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListPlaybackKeysRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListPlaybackKeysRequest) when calling interceptor")
					}
					return c.callListPlaybackKeys(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*twitch_video_starfruitiocp2.ListPlaybackKeysResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*twitch_video_starfruitiocp2.ListPlaybackKeysResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlProtobufClient) callListPlaybackKeys(ctx context.Context, in *ListPlaybackKeysRequest) (*twitch_video_starfruitiocp2.ListPlaybackKeysResponse, error) {
	out := new(twitch_video_starfruitiocp2.ListPlaybackKeysResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlProtobufClient) GetPlaybackAuthorization(ctx context.Context, in *GetPlaybackAuthorizationRequest) (*twitch_video_starfruitiocp2.GetPlaybackAuthorizationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "GetPlaybackAuthorization")
	caller := c.callGetPlaybackAuthorization
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetPlaybackAuthorizationRequest) (*twitch_video_starfruitiocp2.GetPlaybackAuthorizationResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetPlaybackAuthorizationRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetPlaybackAuthorizationRequest) when calling interceptor")
					}
					return c.callGetPlaybackAuthorization(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*twitch_video_starfruitiocp2.GetPlaybackAuthorizationResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*twitch_video_starfruitiocp2.GetPlaybackAuthorizationResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlProtobufClient) callGetPlaybackAuthorization(ctx context.Context, in *GetPlaybackAuthorizationRequest) (*twitch_video_starfruitiocp2.GetPlaybackAuthorizationResponse, error) {
	out := new(twitch_video_starfruitiocp2.GetPlaybackAuthorizationResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlProtobufClient) ListStreamEvents(ctx context.Context, in *ListStreamEventsRequest) (*twitch_video_starfruitsec.ListStreamEventsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamEvents")
	caller := c.callListStreamEvents
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *ListStreamEventsRequest) (*twitch_video_starfruitsec.ListStreamEventsResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListStreamEventsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListStreamEventsRequest) when calling interceptor")
					}
					return c.callListStreamEvents(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*twitch_video_starfruitsec.ListStreamEventsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*twitch_video_starfruitsec.ListStreamEventsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlProtobufClient) callListStreamEvents(ctx context.Context, in *ListStreamEventsRequest) (*twitch_video_starfruitsec.ListStreamEventsResponse, error) {
	out := new(twitch_video_starfruitsec.ListStreamEventsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlProtobufClient) ListLimitBreachEvents(ctx context.Context, in *ListLimitBreachEventsRequest) (*twitch_video_starfruitsec.ListLimitBreachEventsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "ListLimitBreachEvents")
	caller := c.callListLimitBreachEvents
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *ListLimitBreachEventsRequest) (*twitch_video_starfruitsec.ListLimitBreachEventsResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListLimitBreachEventsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListLimitBreachEventsRequest) when calling interceptor")
					}
					return c.callListLimitBreachEvents(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*twitch_video_starfruitsec.ListLimitBreachEventsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*twitch_video_starfruitsec.ListLimitBreachEventsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlProtobufClient) callListLimitBreachEvents(ctx context.Context, in *ListLimitBreachEventsRequest) (*twitch_video_starfruitsec.ListLimitBreachEventsResponse, error) {
	out := new(twitch_video_starfruitsec.ListLimitBreachEventsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[14], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlProtobufClient) EnqueueQuery(ctx context.Context, in *starfruit_carrot_analytics_control.EnqueueQueryRequest) (*starfruit_carrot_analytics_control.EnqueueQueryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "EnqueueQuery")
	caller := c.callEnqueueQuery
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *starfruit_carrot_analytics_control.EnqueueQueryRequest) (*starfruit_carrot_analytics_control.EnqueueQueryResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_analytics_control.EnqueueQueryRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_analytics_control.EnqueueQueryRequest) when calling interceptor")
					}
					return c.callEnqueueQuery(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_analytics_control.EnqueueQueryResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_analytics_control.EnqueueQueryResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlProtobufClient) callEnqueueQuery(ctx context.Context, in *starfruit_carrot_analytics_control.EnqueueQueryRequest) (*starfruit_carrot_analytics_control.EnqueueQueryResponse, error) {
	out := new(starfruit_carrot_analytics_control.EnqueueQueryResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[15], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlProtobufClient) GetQueryResult(ctx context.Context, in *starfruit_carrot_analytics_control.GetQueryResultRequest) (*starfruit_carrot_analytics_control.GetQueryResultResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "GetQueryResult")
	caller := c.callGetQueryResult
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *starfruit_carrot_analytics_control.GetQueryResultRequest) (*starfruit_carrot_analytics_control.GetQueryResultResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_analytics_control.GetQueryResultRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_analytics_control.GetQueryResultRequest) when calling interceptor")
					}
					return c.callGetQueryResult(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_analytics_control.GetQueryResultResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_analytics_control.GetQueryResultResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlProtobufClient) callGetQueryResult(ctx context.Context, in *starfruit_carrot_analytics_control.GetQueryResultRequest) (*starfruit_carrot_analytics_control.GetQueryResultResponse, error) {
	out := new(starfruit_carrot_analytics_control.GetQueryResultResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[16], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlProtobufClient) ListQueries(ctx context.Context, in *starfruit_carrot_analytics_control.ListQueriesRequest) (*starfruit_carrot_analytics_control.ListQueriesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "ListQueries")
	caller := c.callListQueries
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *starfruit_carrot_analytics_control.ListQueriesRequest) (*starfruit_carrot_analytics_control.ListQueriesResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_analytics_control.ListQueriesRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_analytics_control.ListQueriesRequest) when calling interceptor")
					}
					return c.callListQueries(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_analytics_control.ListQueriesResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_analytics_control.ListQueriesResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlProtobufClient) callListQueries(ctx context.Context, in *starfruit_carrot_analytics_control.ListQueriesRequest) (*starfruit_carrot_analytics_control.ListQueriesResponse, error) {
	out := new(starfruit_carrot_analytics_control.ListQueriesResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[17], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlProtobufClient) GetPoPHealth(ctx context.Context, in *starfruit_carrot_system_health.GetPoPHealthRequest) (*starfruit_carrot_system_health.GetPoPHealthResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "GetPoPHealth")
	caller := c.callGetPoPHealth
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *starfruit_carrot_system_health.GetPoPHealthRequest) (*starfruit_carrot_system_health.GetPoPHealthResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_system_health.GetPoPHealthRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_system_health.GetPoPHealthRequest) when calling interceptor")
					}
					return c.callGetPoPHealth(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_system_health.GetPoPHealthResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_system_health.GetPoPHealthResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlProtobufClient) callGetPoPHealth(ctx context.Context, in *starfruit_carrot_system_health.GetPoPHealthRequest) (*starfruit_carrot_system_health.GetPoPHealthResponse, error) {
	out := new(starfruit_carrot_system_health.GetPoPHealthResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[18], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlProtobufClient) GetAvailableCaptureEndpointRegions(ctx context.Context, in *starfruit_carrot_rtmp_recorder.GetAvailableCaptureEndpointRegionsRequest) (*starfruit_carrot_rtmp_recorder.AvailableCaptureEndpointRegions, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "GetAvailableCaptureEndpointRegions")
	caller := c.callGetAvailableCaptureEndpointRegions
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *starfruit_carrot_rtmp_recorder.GetAvailableCaptureEndpointRegionsRequest) (*starfruit_carrot_rtmp_recorder.AvailableCaptureEndpointRegions, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_rtmp_recorder.GetAvailableCaptureEndpointRegionsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_rtmp_recorder.GetAvailableCaptureEndpointRegionsRequest) when calling interceptor")
					}
					return c.callGetAvailableCaptureEndpointRegions(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_rtmp_recorder.AvailableCaptureEndpointRegions)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_rtmp_recorder.AvailableCaptureEndpointRegions) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlProtobufClient) callGetAvailableCaptureEndpointRegions(ctx context.Context, in *starfruit_carrot_rtmp_recorder.GetAvailableCaptureEndpointRegionsRequest) (*starfruit_carrot_rtmp_recorder.AvailableCaptureEndpointRegions, error) {
	out := new(starfruit_carrot_rtmp_recorder.AvailableCaptureEndpointRegions)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[19], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlProtobufClient) CreateCaptureEndpoint(ctx context.Context, in *starfruit_carrot_rtmp_recorder.CreateCaptureEndpointRequest) (*starfruit_carrot_rtmp_recorder.CaptureEndpointInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "CreateCaptureEndpoint")
	caller := c.callCreateCaptureEndpoint
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *starfruit_carrot_rtmp_recorder.CreateCaptureEndpointRequest) (*starfruit_carrot_rtmp_recorder.CaptureEndpointInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_rtmp_recorder.CreateCaptureEndpointRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_rtmp_recorder.CreateCaptureEndpointRequest) when calling interceptor")
					}
					return c.callCreateCaptureEndpoint(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_rtmp_recorder.CaptureEndpointInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_rtmp_recorder.CaptureEndpointInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlProtobufClient) callCreateCaptureEndpoint(ctx context.Context, in *starfruit_carrot_rtmp_recorder.CreateCaptureEndpointRequest) (*starfruit_carrot_rtmp_recorder.CaptureEndpointInfo, error) {
	out := new(starfruit_carrot_rtmp_recorder.CaptureEndpointInfo)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[20], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlProtobufClient) GetCaptureEndpoint(ctx context.Context, in *starfruit_carrot_rtmp_recorder.GetCaptureEndpointRequest) (*starfruit_carrot_rtmp_recorder.CaptureEndpointDetail, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "GetCaptureEndpoint")
	caller := c.callGetCaptureEndpoint
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *starfruit_carrot_rtmp_recorder.GetCaptureEndpointRequest) (*starfruit_carrot_rtmp_recorder.CaptureEndpointDetail, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_rtmp_recorder.GetCaptureEndpointRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_rtmp_recorder.GetCaptureEndpointRequest) when calling interceptor")
					}
					return c.callGetCaptureEndpoint(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_rtmp_recorder.CaptureEndpointDetail)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_rtmp_recorder.CaptureEndpointDetail) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlProtobufClient) callGetCaptureEndpoint(ctx context.Context, in *starfruit_carrot_rtmp_recorder.GetCaptureEndpointRequest) (*starfruit_carrot_rtmp_recorder.CaptureEndpointDetail, error) {
	out := new(starfruit_carrot_rtmp_recorder.CaptureEndpointDetail)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[21], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlProtobufClient) ListCaptureEndpoints(ctx context.Context, in *starfruit_carrot_rtmp_recorder.ListCaptureEndpointsRequest) (*starfruit_carrot_rtmp_recorder.ListCaptureEndpointsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "ListCaptureEndpoints")
	caller := c.callListCaptureEndpoints
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *starfruit_carrot_rtmp_recorder.ListCaptureEndpointsRequest) (*starfruit_carrot_rtmp_recorder.ListCaptureEndpointsResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_rtmp_recorder.ListCaptureEndpointsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_rtmp_recorder.ListCaptureEndpointsRequest) when calling interceptor")
					}
					return c.callListCaptureEndpoints(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_rtmp_recorder.ListCaptureEndpointsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_rtmp_recorder.ListCaptureEndpointsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlProtobufClient) callListCaptureEndpoints(ctx context.Context, in *starfruit_carrot_rtmp_recorder.ListCaptureEndpointsRequest) (*starfruit_carrot_rtmp_recorder.ListCaptureEndpointsResponse, error) {
	out := new(starfruit_carrot_rtmp_recorder.ListCaptureEndpointsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[22], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlProtobufClient) CreateRTMPDump(ctx context.Context, in *starfruit_carrot_rtmp_recorder.CreateRTMPDumpRequest) (*starfruit_carrot_rtmp_recorder.CreateRTMPDumpResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "CreateRTMPDump")
	caller := c.callCreateRTMPDump
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *starfruit_carrot_rtmp_recorder.CreateRTMPDumpRequest) (*starfruit_carrot_rtmp_recorder.CreateRTMPDumpResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_rtmp_recorder.CreateRTMPDumpRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_rtmp_recorder.CreateRTMPDumpRequest) when calling interceptor")
					}
					return c.callCreateRTMPDump(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_rtmp_recorder.CreateRTMPDumpResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_rtmp_recorder.CreateRTMPDumpResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlProtobufClient) callCreateRTMPDump(ctx context.Context, in *starfruit_carrot_rtmp_recorder.CreateRTMPDumpRequest) (*starfruit_carrot_rtmp_recorder.CreateRTMPDumpResponse, error) {
	out := new(starfruit_carrot_rtmp_recorder.CreateRTMPDumpResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[23], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlProtobufClient) GetRTMPDump(ctx context.Context, in *starfruit_carrot_rtmp_recorder.GetRTMPDumpRequest) (*starfruit_carrot_rtmp_recorder.RTMPDumpSummary, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "GetRTMPDump")
	caller := c.callGetRTMPDump
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *starfruit_carrot_rtmp_recorder.GetRTMPDumpRequest) (*starfruit_carrot_rtmp_recorder.RTMPDumpSummary, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_rtmp_recorder.GetRTMPDumpRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_rtmp_recorder.GetRTMPDumpRequest) when calling interceptor")
					}
					return c.callGetRTMPDump(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_rtmp_recorder.RTMPDumpSummary)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_rtmp_recorder.RTMPDumpSummary) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlProtobufClient) callGetRTMPDump(ctx context.Context, in *starfruit_carrot_rtmp_recorder.GetRTMPDumpRequest) (*starfruit_carrot_rtmp_recorder.RTMPDumpSummary, error) {
	out := new(starfruit_carrot_rtmp_recorder.RTMPDumpSummary)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[24], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlProtobufClient) ListRTMPDumps(ctx context.Context, in *starfruit_carrot_rtmp_recorder.ListRTMPDumpsRequest) (*starfruit_carrot_rtmp_recorder.ListRTMPDumpsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "ListRTMPDumps")
	caller := c.callListRTMPDumps
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *starfruit_carrot_rtmp_recorder.ListRTMPDumpsRequest) (*starfruit_carrot_rtmp_recorder.ListRTMPDumpsResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_rtmp_recorder.ListRTMPDumpsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_rtmp_recorder.ListRTMPDumpsRequest) when calling interceptor")
					}
					return c.callListRTMPDumps(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_rtmp_recorder.ListRTMPDumpsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_rtmp_recorder.ListRTMPDumpsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlProtobufClient) callListRTMPDumps(ctx context.Context, in *starfruit_carrot_rtmp_recorder.ListRTMPDumpsRequest) (*starfruit_carrot_rtmp_recorder.ListRTMPDumpsResponse, error) {
	out := new(starfruit_carrot_rtmp_recorder.ListRTMPDumpsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[25], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlProtobufClient) WhatIs(ctx context.Context, in *starfruit_carrot_omnibar.This) (*starfruit_carrot_omnibar.Thing, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "WhatIs")
	caller := c.callWhatIs
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *starfruit_carrot_omnibar.This) (*starfruit_carrot_omnibar.Thing, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_omnibar.This)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_omnibar.This) when calling interceptor")
					}
					return c.callWhatIs(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_omnibar.Thing)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_omnibar.Thing) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlProtobufClient) callWhatIs(ctx context.Context, in *starfruit_carrot_omnibar.This) (*starfruit_carrot_omnibar.Thing, error) {
	out := new(starfruit_carrot_omnibar.Thing)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[26], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// =========================
// CarrotControl JSON Client
// =========================

type carrotControlJSONClient struct {
	client      HTTPClient
	urls        [27]string
	interceptor twirp.Interceptor
	opts        twirp.ClientOptions
}

// NewCarrotControlJSONClient creates a JSON client that implements the CarrotControl interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewCarrotControlJSONClient(baseURL string, client HTTPClient, opts ...twirp.ClientOption) CarrotControl {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	// Using ReadOpt allows backwards and forwads compatibility with new options in the future
	literalURLs := false
	_ = clientOpts.ReadOpt("literalURLs", &literalURLs)
	var pathPrefix string
	if ok := clientOpts.ReadOpt("pathPrefix", &pathPrefix); !ok {
		pathPrefix = "/twirp" // default prefix
	}

	// Build method URLs: <baseURL>[<prefix>]/<package>.<Service>/<Method>
	serviceURL := sanitizeBaseURL(baseURL)
	serviceURL += baseServicePath(pathPrefix, "starfruit.carrot_control", "CarrotControl")
	urls := [27]string{
		serviceURL + "GetModuleAccess",
		serviceURL + "GetChannelSessions",
		serviceURL + "GetSessionData",
		serviceURL + "GetCapturedFileDetail",
		serviceURL + "GetCapturedFileDownloadLink",
		serviceURL + "GetStreamConfig",
		serviceURL + "ListStreamConfigs",
		serviceURL + "ListStreamConfigsByRecordingConfig",
		serviceURL + "GetStreamKey",
		serviceURL + "ListStreamKeysForContent",
		serviceURL + "GetPlaybackKey",
		serviceURL + "ListPlaybackKeys",
		serviceURL + "GetPlaybackAuthorization",
		serviceURL + "ListStreamEvents",
		serviceURL + "ListLimitBreachEvents",
		serviceURL + "EnqueueQuery",
		serviceURL + "GetQueryResult",
		serviceURL + "ListQueries",
		serviceURL + "GetPoPHealth",
		serviceURL + "GetAvailableCaptureEndpointRegions",
		serviceURL + "CreateCaptureEndpoint",
		serviceURL + "GetCaptureEndpoint",
		serviceURL + "ListCaptureEndpoints",
		serviceURL + "CreateRTMPDump",
		serviceURL + "GetRTMPDump",
		serviceURL + "ListRTMPDumps",
		serviceURL + "WhatIs",
	}

	return &carrotControlJSONClient{
		client:      client,
		urls:        urls,
		interceptor: twirp.ChainInterceptors(clientOpts.Interceptors...),
		opts:        clientOpts,
	}
}

func (c *carrotControlJSONClient) GetModuleAccess(ctx context.Context, in *GetModuleAccessRequest) (*GetModuleAccessResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "GetModuleAccess")
	caller := c.callGetModuleAccess
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetModuleAccessRequest) (*GetModuleAccessResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetModuleAccessRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetModuleAccessRequest) when calling interceptor")
					}
					return c.callGetModuleAccess(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetModuleAccessResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetModuleAccessResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlJSONClient) callGetModuleAccess(ctx context.Context, in *GetModuleAccessRequest) (*GetModuleAccessResponse, error) {
	out := new(GetModuleAccessResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlJSONClient) GetChannelSessions(ctx context.Context, in *starfruit_carrot_stream_analysis.GetChannelSessionsRequest) (*starfruit_carrot_stream_analysis.GetChannelSessionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelSessions")
	caller := c.callGetChannelSessions
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *starfruit_carrot_stream_analysis.GetChannelSessionsRequest) (*starfruit_carrot_stream_analysis.GetChannelSessionsResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_stream_analysis.GetChannelSessionsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_stream_analysis.GetChannelSessionsRequest) when calling interceptor")
					}
					return c.callGetChannelSessions(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_stream_analysis.GetChannelSessionsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_stream_analysis.GetChannelSessionsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlJSONClient) callGetChannelSessions(ctx context.Context, in *starfruit_carrot_stream_analysis.GetChannelSessionsRequest) (*starfruit_carrot_stream_analysis.GetChannelSessionsResponse, error) {
	out := new(starfruit_carrot_stream_analysis.GetChannelSessionsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlJSONClient) GetSessionData(ctx context.Context, in *starfruit_carrot_stream_analysis.GetSessionDataRequest) (*starfruit_carrot_stream_analysis.GetSessionDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "GetSessionData")
	caller := c.callGetSessionData
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *starfruit_carrot_stream_analysis.GetSessionDataRequest) (*starfruit_carrot_stream_analysis.GetSessionDataResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_stream_analysis.GetSessionDataRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_stream_analysis.GetSessionDataRequest) when calling interceptor")
					}
					return c.callGetSessionData(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_stream_analysis.GetSessionDataResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_stream_analysis.GetSessionDataResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlJSONClient) callGetSessionData(ctx context.Context, in *starfruit_carrot_stream_analysis.GetSessionDataRequest) (*starfruit_carrot_stream_analysis.GetSessionDataResponse, error) {
	out := new(starfruit_carrot_stream_analysis.GetSessionDataResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlJSONClient) GetCapturedFileDetail(ctx context.Context, in *starfruit_carrot_stream_analysis.GetCapturedFileDetailRequest) (*starfruit_carrot_stream_analysis.GetCapturedFileDetailResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "GetCapturedFileDetail")
	caller := c.callGetCapturedFileDetail
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *starfruit_carrot_stream_analysis.GetCapturedFileDetailRequest) (*starfruit_carrot_stream_analysis.GetCapturedFileDetailResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_stream_analysis.GetCapturedFileDetailRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_stream_analysis.GetCapturedFileDetailRequest) when calling interceptor")
					}
					return c.callGetCapturedFileDetail(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_stream_analysis.GetCapturedFileDetailResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_stream_analysis.GetCapturedFileDetailResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlJSONClient) callGetCapturedFileDetail(ctx context.Context, in *starfruit_carrot_stream_analysis.GetCapturedFileDetailRequest) (*starfruit_carrot_stream_analysis.GetCapturedFileDetailResponse, error) {
	out := new(starfruit_carrot_stream_analysis.GetCapturedFileDetailResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlJSONClient) GetCapturedFileDownloadLink(ctx context.Context, in *starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkRequest) (*starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "GetCapturedFileDownloadLink")
	caller := c.callGetCapturedFileDownloadLink
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkRequest) (*starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkRequest) when calling interceptor")
					}
					return c.callGetCapturedFileDownloadLink(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlJSONClient) callGetCapturedFileDownloadLink(ctx context.Context, in *starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkRequest) (*starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkResponse, error) {
	out := new(starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlJSONClient) GetStreamConfig(ctx context.Context, in *GetStreamConfigRequest) (*GetStreamConfigResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamConfig")
	caller := c.callGetStreamConfig
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetStreamConfigRequest) (*GetStreamConfigResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetStreamConfigRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetStreamConfigRequest) when calling interceptor")
					}
					return c.callGetStreamConfig(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetStreamConfigResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetStreamConfigResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlJSONClient) callGetStreamConfig(ctx context.Context, in *GetStreamConfigRequest) (*GetStreamConfigResponse, error) {
	out := new(GetStreamConfigResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlJSONClient) ListStreamConfigs(ctx context.Context, in *ListStreamConfigsRequest) (*twitch_video_starfruitiocp.ListStreamConfigsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamConfigs")
	caller := c.callListStreamConfigs
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *ListStreamConfigsRequest) (*twitch_video_starfruitiocp.ListStreamConfigsResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListStreamConfigsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListStreamConfigsRequest) when calling interceptor")
					}
					return c.callListStreamConfigs(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*twitch_video_starfruitiocp.ListStreamConfigsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*twitch_video_starfruitiocp.ListStreamConfigsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlJSONClient) callListStreamConfigs(ctx context.Context, in *ListStreamConfigsRequest) (*twitch_video_starfruitiocp.ListStreamConfigsResponse, error) {
	out := new(twitch_video_starfruitiocp.ListStreamConfigsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlJSONClient) ListStreamConfigsByRecordingConfig(ctx context.Context, in *ListStreamConfigsByRecordingConfigRequest) (*twitch_video_starfruitiocp.ListStreamConfigsByRecordingConfigResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamConfigsByRecordingConfig")
	caller := c.callListStreamConfigsByRecordingConfig
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *ListStreamConfigsByRecordingConfigRequest) (*twitch_video_starfruitiocp.ListStreamConfigsByRecordingConfigResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListStreamConfigsByRecordingConfigRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListStreamConfigsByRecordingConfigRequest) when calling interceptor")
					}
					return c.callListStreamConfigsByRecordingConfig(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*twitch_video_starfruitiocp.ListStreamConfigsByRecordingConfigResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*twitch_video_starfruitiocp.ListStreamConfigsByRecordingConfigResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlJSONClient) callListStreamConfigsByRecordingConfig(ctx context.Context, in *ListStreamConfigsByRecordingConfigRequest) (*twitch_video_starfruitiocp.ListStreamConfigsByRecordingConfigResponse, error) {
	out := new(twitch_video_starfruitiocp.ListStreamConfigsByRecordingConfigResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[7], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlJSONClient) GetStreamKey(ctx context.Context, in *GetStreamKeyRequest) (*twitch_video_starfruitiocp1.StreamKey, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamKey")
	caller := c.callGetStreamKey
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetStreamKeyRequest) (*twitch_video_starfruitiocp1.StreamKey, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetStreamKeyRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetStreamKeyRequest) when calling interceptor")
					}
					return c.callGetStreamKey(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*twitch_video_starfruitiocp1.StreamKey)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*twitch_video_starfruitiocp1.StreamKey) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlJSONClient) callGetStreamKey(ctx context.Context, in *GetStreamKeyRequest) (*twitch_video_starfruitiocp1.StreamKey, error) {
	out := new(twitch_video_starfruitiocp1.StreamKey)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[8], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlJSONClient) ListStreamKeysForContent(ctx context.Context, in *ListStreamKeysForContentRequest) (*twitch_video_starfruitiocp1.ListStreamKeysForContentResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamKeysForContent")
	caller := c.callListStreamKeysForContent
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *ListStreamKeysForContentRequest) (*twitch_video_starfruitiocp1.ListStreamKeysForContentResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListStreamKeysForContentRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListStreamKeysForContentRequest) when calling interceptor")
					}
					return c.callListStreamKeysForContent(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*twitch_video_starfruitiocp1.ListStreamKeysForContentResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*twitch_video_starfruitiocp1.ListStreamKeysForContentResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlJSONClient) callListStreamKeysForContent(ctx context.Context, in *ListStreamKeysForContentRequest) (*twitch_video_starfruitiocp1.ListStreamKeysForContentResponse, error) {
	out := new(twitch_video_starfruitiocp1.ListStreamKeysForContentResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[9], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlJSONClient) GetPlaybackKey(ctx context.Context, in *GetPlaybackKeyRequest) (*twitch_video_starfruitiocp2.GetPlaybackKeyResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "GetPlaybackKey")
	caller := c.callGetPlaybackKey
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetPlaybackKeyRequest) (*twitch_video_starfruitiocp2.GetPlaybackKeyResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetPlaybackKeyRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetPlaybackKeyRequest) when calling interceptor")
					}
					return c.callGetPlaybackKey(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*twitch_video_starfruitiocp2.GetPlaybackKeyResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*twitch_video_starfruitiocp2.GetPlaybackKeyResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlJSONClient) callGetPlaybackKey(ctx context.Context, in *GetPlaybackKeyRequest) (*twitch_video_starfruitiocp2.GetPlaybackKeyResponse, error) {
	out := new(twitch_video_starfruitiocp2.GetPlaybackKeyResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[10], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlJSONClient) ListPlaybackKeys(ctx context.Context, in *ListPlaybackKeysRequest) (*twitch_video_starfruitiocp2.ListPlaybackKeysResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "ListPlaybackKeys")
	caller := c.callListPlaybackKeys
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *ListPlaybackKeysRequest) (*twitch_video_starfruitiocp2.ListPlaybackKeysResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListPlaybackKeysRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListPlaybackKeysRequest) when calling interceptor")
					}
					return c.callListPlaybackKeys(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*twitch_video_starfruitiocp2.ListPlaybackKeysResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*twitch_video_starfruitiocp2.ListPlaybackKeysResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlJSONClient) callListPlaybackKeys(ctx context.Context, in *ListPlaybackKeysRequest) (*twitch_video_starfruitiocp2.ListPlaybackKeysResponse, error) {
	out := new(twitch_video_starfruitiocp2.ListPlaybackKeysResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[11], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlJSONClient) GetPlaybackAuthorization(ctx context.Context, in *GetPlaybackAuthorizationRequest) (*twitch_video_starfruitiocp2.GetPlaybackAuthorizationResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "GetPlaybackAuthorization")
	caller := c.callGetPlaybackAuthorization
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetPlaybackAuthorizationRequest) (*twitch_video_starfruitiocp2.GetPlaybackAuthorizationResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetPlaybackAuthorizationRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetPlaybackAuthorizationRequest) when calling interceptor")
					}
					return c.callGetPlaybackAuthorization(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*twitch_video_starfruitiocp2.GetPlaybackAuthorizationResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*twitch_video_starfruitiocp2.GetPlaybackAuthorizationResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlJSONClient) callGetPlaybackAuthorization(ctx context.Context, in *GetPlaybackAuthorizationRequest) (*twitch_video_starfruitiocp2.GetPlaybackAuthorizationResponse, error) {
	out := new(twitch_video_starfruitiocp2.GetPlaybackAuthorizationResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[12], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlJSONClient) ListStreamEvents(ctx context.Context, in *ListStreamEventsRequest) (*twitch_video_starfruitsec.ListStreamEventsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamEvents")
	caller := c.callListStreamEvents
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *ListStreamEventsRequest) (*twitch_video_starfruitsec.ListStreamEventsResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListStreamEventsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListStreamEventsRequest) when calling interceptor")
					}
					return c.callListStreamEvents(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*twitch_video_starfruitsec.ListStreamEventsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*twitch_video_starfruitsec.ListStreamEventsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlJSONClient) callListStreamEvents(ctx context.Context, in *ListStreamEventsRequest) (*twitch_video_starfruitsec.ListStreamEventsResponse, error) {
	out := new(twitch_video_starfruitsec.ListStreamEventsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[13], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlJSONClient) ListLimitBreachEvents(ctx context.Context, in *ListLimitBreachEventsRequest) (*twitch_video_starfruitsec.ListLimitBreachEventsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "ListLimitBreachEvents")
	caller := c.callListLimitBreachEvents
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *ListLimitBreachEventsRequest) (*twitch_video_starfruitsec.ListLimitBreachEventsResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListLimitBreachEventsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListLimitBreachEventsRequest) when calling interceptor")
					}
					return c.callListLimitBreachEvents(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*twitch_video_starfruitsec.ListLimitBreachEventsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*twitch_video_starfruitsec.ListLimitBreachEventsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlJSONClient) callListLimitBreachEvents(ctx context.Context, in *ListLimitBreachEventsRequest) (*twitch_video_starfruitsec.ListLimitBreachEventsResponse, error) {
	out := new(twitch_video_starfruitsec.ListLimitBreachEventsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[14], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlJSONClient) EnqueueQuery(ctx context.Context, in *starfruit_carrot_analytics_control.EnqueueQueryRequest) (*starfruit_carrot_analytics_control.EnqueueQueryResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "EnqueueQuery")
	caller := c.callEnqueueQuery
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *starfruit_carrot_analytics_control.EnqueueQueryRequest) (*starfruit_carrot_analytics_control.EnqueueQueryResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_analytics_control.EnqueueQueryRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_analytics_control.EnqueueQueryRequest) when calling interceptor")
					}
					return c.callEnqueueQuery(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_analytics_control.EnqueueQueryResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_analytics_control.EnqueueQueryResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlJSONClient) callEnqueueQuery(ctx context.Context, in *starfruit_carrot_analytics_control.EnqueueQueryRequest) (*starfruit_carrot_analytics_control.EnqueueQueryResponse, error) {
	out := new(starfruit_carrot_analytics_control.EnqueueQueryResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[15], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlJSONClient) GetQueryResult(ctx context.Context, in *starfruit_carrot_analytics_control.GetQueryResultRequest) (*starfruit_carrot_analytics_control.GetQueryResultResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "GetQueryResult")
	caller := c.callGetQueryResult
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *starfruit_carrot_analytics_control.GetQueryResultRequest) (*starfruit_carrot_analytics_control.GetQueryResultResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_analytics_control.GetQueryResultRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_analytics_control.GetQueryResultRequest) when calling interceptor")
					}
					return c.callGetQueryResult(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_analytics_control.GetQueryResultResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_analytics_control.GetQueryResultResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlJSONClient) callGetQueryResult(ctx context.Context, in *starfruit_carrot_analytics_control.GetQueryResultRequest) (*starfruit_carrot_analytics_control.GetQueryResultResponse, error) {
	out := new(starfruit_carrot_analytics_control.GetQueryResultResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[16], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlJSONClient) ListQueries(ctx context.Context, in *starfruit_carrot_analytics_control.ListQueriesRequest) (*starfruit_carrot_analytics_control.ListQueriesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "ListQueries")
	caller := c.callListQueries
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *starfruit_carrot_analytics_control.ListQueriesRequest) (*starfruit_carrot_analytics_control.ListQueriesResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_analytics_control.ListQueriesRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_analytics_control.ListQueriesRequest) when calling interceptor")
					}
					return c.callListQueries(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_analytics_control.ListQueriesResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_analytics_control.ListQueriesResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlJSONClient) callListQueries(ctx context.Context, in *starfruit_carrot_analytics_control.ListQueriesRequest) (*starfruit_carrot_analytics_control.ListQueriesResponse, error) {
	out := new(starfruit_carrot_analytics_control.ListQueriesResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[17], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlJSONClient) GetPoPHealth(ctx context.Context, in *starfruit_carrot_system_health.GetPoPHealthRequest) (*starfruit_carrot_system_health.GetPoPHealthResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "GetPoPHealth")
	caller := c.callGetPoPHealth
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *starfruit_carrot_system_health.GetPoPHealthRequest) (*starfruit_carrot_system_health.GetPoPHealthResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_system_health.GetPoPHealthRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_system_health.GetPoPHealthRequest) when calling interceptor")
					}
					return c.callGetPoPHealth(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_system_health.GetPoPHealthResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_system_health.GetPoPHealthResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlJSONClient) callGetPoPHealth(ctx context.Context, in *starfruit_carrot_system_health.GetPoPHealthRequest) (*starfruit_carrot_system_health.GetPoPHealthResponse, error) {
	out := new(starfruit_carrot_system_health.GetPoPHealthResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[18], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlJSONClient) GetAvailableCaptureEndpointRegions(ctx context.Context, in *starfruit_carrot_rtmp_recorder.GetAvailableCaptureEndpointRegionsRequest) (*starfruit_carrot_rtmp_recorder.AvailableCaptureEndpointRegions, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "GetAvailableCaptureEndpointRegions")
	caller := c.callGetAvailableCaptureEndpointRegions
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *starfruit_carrot_rtmp_recorder.GetAvailableCaptureEndpointRegionsRequest) (*starfruit_carrot_rtmp_recorder.AvailableCaptureEndpointRegions, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_rtmp_recorder.GetAvailableCaptureEndpointRegionsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_rtmp_recorder.GetAvailableCaptureEndpointRegionsRequest) when calling interceptor")
					}
					return c.callGetAvailableCaptureEndpointRegions(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_rtmp_recorder.AvailableCaptureEndpointRegions)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_rtmp_recorder.AvailableCaptureEndpointRegions) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlJSONClient) callGetAvailableCaptureEndpointRegions(ctx context.Context, in *starfruit_carrot_rtmp_recorder.GetAvailableCaptureEndpointRegionsRequest) (*starfruit_carrot_rtmp_recorder.AvailableCaptureEndpointRegions, error) {
	out := new(starfruit_carrot_rtmp_recorder.AvailableCaptureEndpointRegions)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[19], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlJSONClient) CreateCaptureEndpoint(ctx context.Context, in *starfruit_carrot_rtmp_recorder.CreateCaptureEndpointRequest) (*starfruit_carrot_rtmp_recorder.CaptureEndpointInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "CreateCaptureEndpoint")
	caller := c.callCreateCaptureEndpoint
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *starfruit_carrot_rtmp_recorder.CreateCaptureEndpointRequest) (*starfruit_carrot_rtmp_recorder.CaptureEndpointInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_rtmp_recorder.CreateCaptureEndpointRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_rtmp_recorder.CreateCaptureEndpointRequest) when calling interceptor")
					}
					return c.callCreateCaptureEndpoint(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_rtmp_recorder.CaptureEndpointInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_rtmp_recorder.CaptureEndpointInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlJSONClient) callCreateCaptureEndpoint(ctx context.Context, in *starfruit_carrot_rtmp_recorder.CreateCaptureEndpointRequest) (*starfruit_carrot_rtmp_recorder.CaptureEndpointInfo, error) {
	out := new(starfruit_carrot_rtmp_recorder.CaptureEndpointInfo)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[20], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlJSONClient) GetCaptureEndpoint(ctx context.Context, in *starfruit_carrot_rtmp_recorder.GetCaptureEndpointRequest) (*starfruit_carrot_rtmp_recorder.CaptureEndpointDetail, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "GetCaptureEndpoint")
	caller := c.callGetCaptureEndpoint
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *starfruit_carrot_rtmp_recorder.GetCaptureEndpointRequest) (*starfruit_carrot_rtmp_recorder.CaptureEndpointDetail, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_rtmp_recorder.GetCaptureEndpointRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_rtmp_recorder.GetCaptureEndpointRequest) when calling interceptor")
					}
					return c.callGetCaptureEndpoint(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_rtmp_recorder.CaptureEndpointDetail)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_rtmp_recorder.CaptureEndpointDetail) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlJSONClient) callGetCaptureEndpoint(ctx context.Context, in *starfruit_carrot_rtmp_recorder.GetCaptureEndpointRequest) (*starfruit_carrot_rtmp_recorder.CaptureEndpointDetail, error) {
	out := new(starfruit_carrot_rtmp_recorder.CaptureEndpointDetail)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[21], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlJSONClient) ListCaptureEndpoints(ctx context.Context, in *starfruit_carrot_rtmp_recorder.ListCaptureEndpointsRequest) (*starfruit_carrot_rtmp_recorder.ListCaptureEndpointsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "ListCaptureEndpoints")
	caller := c.callListCaptureEndpoints
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *starfruit_carrot_rtmp_recorder.ListCaptureEndpointsRequest) (*starfruit_carrot_rtmp_recorder.ListCaptureEndpointsResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_rtmp_recorder.ListCaptureEndpointsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_rtmp_recorder.ListCaptureEndpointsRequest) when calling interceptor")
					}
					return c.callListCaptureEndpoints(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_rtmp_recorder.ListCaptureEndpointsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_rtmp_recorder.ListCaptureEndpointsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlJSONClient) callListCaptureEndpoints(ctx context.Context, in *starfruit_carrot_rtmp_recorder.ListCaptureEndpointsRequest) (*starfruit_carrot_rtmp_recorder.ListCaptureEndpointsResponse, error) {
	out := new(starfruit_carrot_rtmp_recorder.ListCaptureEndpointsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[22], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlJSONClient) CreateRTMPDump(ctx context.Context, in *starfruit_carrot_rtmp_recorder.CreateRTMPDumpRequest) (*starfruit_carrot_rtmp_recorder.CreateRTMPDumpResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "CreateRTMPDump")
	caller := c.callCreateRTMPDump
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *starfruit_carrot_rtmp_recorder.CreateRTMPDumpRequest) (*starfruit_carrot_rtmp_recorder.CreateRTMPDumpResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_rtmp_recorder.CreateRTMPDumpRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_rtmp_recorder.CreateRTMPDumpRequest) when calling interceptor")
					}
					return c.callCreateRTMPDump(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_rtmp_recorder.CreateRTMPDumpResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_rtmp_recorder.CreateRTMPDumpResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlJSONClient) callCreateRTMPDump(ctx context.Context, in *starfruit_carrot_rtmp_recorder.CreateRTMPDumpRequest) (*starfruit_carrot_rtmp_recorder.CreateRTMPDumpResponse, error) {
	out := new(starfruit_carrot_rtmp_recorder.CreateRTMPDumpResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[23], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlJSONClient) GetRTMPDump(ctx context.Context, in *starfruit_carrot_rtmp_recorder.GetRTMPDumpRequest) (*starfruit_carrot_rtmp_recorder.RTMPDumpSummary, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "GetRTMPDump")
	caller := c.callGetRTMPDump
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *starfruit_carrot_rtmp_recorder.GetRTMPDumpRequest) (*starfruit_carrot_rtmp_recorder.RTMPDumpSummary, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_rtmp_recorder.GetRTMPDumpRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_rtmp_recorder.GetRTMPDumpRequest) when calling interceptor")
					}
					return c.callGetRTMPDump(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_rtmp_recorder.RTMPDumpSummary)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_rtmp_recorder.RTMPDumpSummary) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlJSONClient) callGetRTMPDump(ctx context.Context, in *starfruit_carrot_rtmp_recorder.GetRTMPDumpRequest) (*starfruit_carrot_rtmp_recorder.RTMPDumpSummary, error) {
	out := new(starfruit_carrot_rtmp_recorder.RTMPDumpSummary)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[24], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlJSONClient) ListRTMPDumps(ctx context.Context, in *starfruit_carrot_rtmp_recorder.ListRTMPDumpsRequest) (*starfruit_carrot_rtmp_recorder.ListRTMPDumpsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "ListRTMPDumps")
	caller := c.callListRTMPDumps
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *starfruit_carrot_rtmp_recorder.ListRTMPDumpsRequest) (*starfruit_carrot_rtmp_recorder.ListRTMPDumpsResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_rtmp_recorder.ListRTMPDumpsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_rtmp_recorder.ListRTMPDumpsRequest) when calling interceptor")
					}
					return c.callListRTMPDumps(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_rtmp_recorder.ListRTMPDumpsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_rtmp_recorder.ListRTMPDumpsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlJSONClient) callListRTMPDumps(ctx context.Context, in *starfruit_carrot_rtmp_recorder.ListRTMPDumpsRequest) (*starfruit_carrot_rtmp_recorder.ListRTMPDumpsResponse, error) {
	out := new(starfruit_carrot_rtmp_recorder.ListRTMPDumpsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[25], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotControlJSONClient) WhatIs(ctx context.Context, in *starfruit_carrot_omnibar.This) (*starfruit_carrot_omnibar.Thing, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithMethodName(ctx, "WhatIs")
	caller := c.callWhatIs
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *starfruit_carrot_omnibar.This) (*starfruit_carrot_omnibar.Thing, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_omnibar.This)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_omnibar.This) when calling interceptor")
					}
					return c.callWhatIs(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_omnibar.Thing)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_omnibar.Thing) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotControlJSONClient) callWhatIs(ctx context.Context, in *starfruit_carrot_omnibar.This) (*starfruit_carrot_omnibar.Thing, error) {
	out := new(starfruit_carrot_omnibar.Thing)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[26], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ============================
// CarrotControl Server Handler
// ============================

type carrotControlServer struct {
	CarrotControl
	interceptor      twirp.Interceptor
	hooks            *twirp.ServerHooks
	pathPrefix       string // prefix for routing
	jsonSkipDefaults bool   // do not include unpopulated fields (default values) in the response
	jsonCamelCase    bool   // JSON fields are serialized as lowerCamelCase rather than keeping the original proto names
}

// NewCarrotControlServer builds a TwirpServer that can be used as an http.Handler to handle
// HTTP requests that are routed to the right method in the provided svc implementation.
// The opts are twirp.ServerOption modifiers, for example twirp.WithServerHooks(hooks).
func NewCarrotControlServer(svc CarrotControl, opts ...interface{}) TwirpServer {
	serverOpts := newServerOpts(opts)

	// Using ReadOpt allows backwards and forwads compatibility with new options in the future
	jsonSkipDefaults := false
	_ = serverOpts.ReadOpt("jsonSkipDefaults", &jsonSkipDefaults)
	jsonCamelCase := false
	_ = serverOpts.ReadOpt("jsonCamelCase", &jsonCamelCase)
	var pathPrefix string
	if ok := serverOpts.ReadOpt("pathPrefix", &pathPrefix); !ok {
		pathPrefix = "/twirp" // default prefix
	}

	return &carrotControlServer{
		CarrotControl:    svc,
		hooks:            serverOpts.Hooks,
		interceptor:      twirp.ChainInterceptors(serverOpts.Interceptors...),
		pathPrefix:       pathPrefix,
		jsonSkipDefaults: jsonSkipDefaults,
		jsonCamelCase:    jsonCamelCase,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *carrotControlServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// handleRequestBodyError is used to handle error when the twirp server cannot read request
func (s *carrotControlServer) handleRequestBodyError(ctx context.Context, resp http.ResponseWriter, msg string, err error) {
	if context.Canceled == ctx.Err() {
		s.writeError(ctx, resp, twirp.NewError(twirp.Canceled, "failed to read request: context canceled"))
		return
	}
	if context.DeadlineExceeded == ctx.Err() {
		s.writeError(ctx, resp, twirp.NewError(twirp.DeadlineExceeded, "failed to read request: deadline exceeded"))
		return
	}
	s.writeError(ctx, resp, twirp.WrapError(malformedRequestError(msg), err))
}

// CarrotControlPathPrefix is a convenience constant that may identify URL paths.
// Should be used with caution, it only matches routes generated by Twirp Go clients,
// with the default "/twirp" prefix and default CamelCase service and method names.
// More info: https://twitchtv.github.io/twirp/docs/routing.html
const CarrotControlPathPrefix = "/twirp/starfruit.carrot_control.CarrotControl/"

func (s *carrotControlServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_control")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotControl")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}

	// Verify path format: [<prefix>]/<package>.<Service>/<Method>
	prefix, pkgService, method := parseTwirpPath(req.URL.Path)
	if pkgService != "starfruit.carrot_control.CarrotControl" {
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}
	if prefix != s.pathPrefix {
		msg := fmt.Sprintf("invalid path prefix %q, expected %q, on path %q", prefix, s.pathPrefix, req.URL.Path)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}

	switch method {
	case "GetModuleAccess":
		s.serveGetModuleAccess(ctx, resp, req)
		return
	case "GetChannelSessions":
		s.serveGetChannelSessions(ctx, resp, req)
		return
	case "GetSessionData":
		s.serveGetSessionData(ctx, resp, req)
		return
	case "GetCapturedFileDetail":
		s.serveGetCapturedFileDetail(ctx, resp, req)
		return
	case "GetCapturedFileDownloadLink":
		s.serveGetCapturedFileDownloadLink(ctx, resp, req)
		return
	case "GetStreamConfig":
		s.serveGetStreamConfig(ctx, resp, req)
		return
	case "ListStreamConfigs":
		s.serveListStreamConfigs(ctx, resp, req)
		return
	case "ListStreamConfigsByRecordingConfig":
		s.serveListStreamConfigsByRecordingConfig(ctx, resp, req)
		return
	case "GetStreamKey":
		s.serveGetStreamKey(ctx, resp, req)
		return
	case "ListStreamKeysForContent":
		s.serveListStreamKeysForContent(ctx, resp, req)
		return
	case "GetPlaybackKey":
		s.serveGetPlaybackKey(ctx, resp, req)
		return
	case "ListPlaybackKeys":
		s.serveListPlaybackKeys(ctx, resp, req)
		return
	case "GetPlaybackAuthorization":
		s.serveGetPlaybackAuthorization(ctx, resp, req)
		return
	case "ListStreamEvents":
		s.serveListStreamEvents(ctx, resp, req)
		return
	case "ListLimitBreachEvents":
		s.serveListLimitBreachEvents(ctx, resp, req)
		return
	case "EnqueueQuery":
		s.serveEnqueueQuery(ctx, resp, req)
		return
	case "GetQueryResult":
		s.serveGetQueryResult(ctx, resp, req)
		return
	case "ListQueries":
		s.serveListQueries(ctx, resp, req)
		return
	case "GetPoPHealth":
		s.serveGetPoPHealth(ctx, resp, req)
		return
	case "GetAvailableCaptureEndpointRegions":
		s.serveGetAvailableCaptureEndpointRegions(ctx, resp, req)
		return
	case "CreateCaptureEndpoint":
		s.serveCreateCaptureEndpoint(ctx, resp, req)
		return
	case "GetCaptureEndpoint":
		s.serveGetCaptureEndpoint(ctx, resp, req)
		return
	case "ListCaptureEndpoints":
		s.serveListCaptureEndpoints(ctx, resp, req)
		return
	case "CreateRTMPDump":
		s.serveCreateRTMPDump(ctx, resp, req)
		return
	case "GetRTMPDump":
		s.serveGetRTMPDump(ctx, resp, req)
		return
	case "ListRTMPDumps":
		s.serveListRTMPDumps(ctx, resp, req)
		return
	case "WhatIs":
		s.serveWhatIs(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}
}

func (s *carrotControlServer) serveGetModuleAccess(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetModuleAccessJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetModuleAccessProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *carrotControlServer) serveGetModuleAccessJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetModuleAccess")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(GetModuleAccessRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.CarrotControl.GetModuleAccess
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetModuleAccessRequest) (*GetModuleAccessResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetModuleAccessRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetModuleAccessRequest) when calling interceptor")
					}
					return s.CarrotControl.GetModuleAccess(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetModuleAccessResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetModuleAccessResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *GetModuleAccessResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetModuleAccessResponse and nil error while calling GetModuleAccess. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveGetModuleAccessProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetModuleAccess")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(GetModuleAccessRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.CarrotControl.GetModuleAccess
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetModuleAccessRequest) (*GetModuleAccessResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetModuleAccessRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetModuleAccessRequest) when calling interceptor")
					}
					return s.CarrotControl.GetModuleAccess(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetModuleAccessResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetModuleAccessResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *GetModuleAccessResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetModuleAccessResponse and nil error while calling GetModuleAccess. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveGetChannelSessions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetChannelSessionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetChannelSessionsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *carrotControlServer) serveGetChannelSessionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelSessions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(starfruit_carrot_stream_analysis.GetChannelSessionsRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.CarrotControl.GetChannelSessions
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *starfruit_carrot_stream_analysis.GetChannelSessionsRequest) (*starfruit_carrot_stream_analysis.GetChannelSessionsResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_stream_analysis.GetChannelSessionsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_stream_analysis.GetChannelSessionsRequest) when calling interceptor")
					}
					return s.CarrotControl.GetChannelSessions(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_stream_analysis.GetChannelSessionsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_stream_analysis.GetChannelSessionsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *starfruit_carrot_stream_analysis.GetChannelSessionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *starfruit_carrot_stream_analysis.GetChannelSessionsResponse and nil error while calling GetChannelSessions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveGetChannelSessionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelSessions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(starfruit_carrot_stream_analysis.GetChannelSessionsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.CarrotControl.GetChannelSessions
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *starfruit_carrot_stream_analysis.GetChannelSessionsRequest) (*starfruit_carrot_stream_analysis.GetChannelSessionsResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_stream_analysis.GetChannelSessionsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_stream_analysis.GetChannelSessionsRequest) when calling interceptor")
					}
					return s.CarrotControl.GetChannelSessions(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_stream_analysis.GetChannelSessionsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_stream_analysis.GetChannelSessionsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *starfruit_carrot_stream_analysis.GetChannelSessionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *starfruit_carrot_stream_analysis.GetChannelSessionsResponse and nil error while calling GetChannelSessions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveGetSessionData(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetSessionDataJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetSessionDataProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *carrotControlServer) serveGetSessionDataJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetSessionData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(starfruit_carrot_stream_analysis.GetSessionDataRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.CarrotControl.GetSessionData
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *starfruit_carrot_stream_analysis.GetSessionDataRequest) (*starfruit_carrot_stream_analysis.GetSessionDataResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_stream_analysis.GetSessionDataRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_stream_analysis.GetSessionDataRequest) when calling interceptor")
					}
					return s.CarrotControl.GetSessionData(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_stream_analysis.GetSessionDataResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_stream_analysis.GetSessionDataResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *starfruit_carrot_stream_analysis.GetSessionDataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *starfruit_carrot_stream_analysis.GetSessionDataResponse and nil error while calling GetSessionData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveGetSessionDataProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetSessionData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(starfruit_carrot_stream_analysis.GetSessionDataRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.CarrotControl.GetSessionData
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *starfruit_carrot_stream_analysis.GetSessionDataRequest) (*starfruit_carrot_stream_analysis.GetSessionDataResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_stream_analysis.GetSessionDataRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_stream_analysis.GetSessionDataRequest) when calling interceptor")
					}
					return s.CarrotControl.GetSessionData(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_stream_analysis.GetSessionDataResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_stream_analysis.GetSessionDataResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *starfruit_carrot_stream_analysis.GetSessionDataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *starfruit_carrot_stream_analysis.GetSessionDataResponse and nil error while calling GetSessionData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveGetCapturedFileDetail(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetCapturedFileDetailJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetCapturedFileDetailProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *carrotControlServer) serveGetCapturedFileDetailJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCapturedFileDetail")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(starfruit_carrot_stream_analysis.GetCapturedFileDetailRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.CarrotControl.GetCapturedFileDetail
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *starfruit_carrot_stream_analysis.GetCapturedFileDetailRequest) (*starfruit_carrot_stream_analysis.GetCapturedFileDetailResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_stream_analysis.GetCapturedFileDetailRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_stream_analysis.GetCapturedFileDetailRequest) when calling interceptor")
					}
					return s.CarrotControl.GetCapturedFileDetail(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_stream_analysis.GetCapturedFileDetailResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_stream_analysis.GetCapturedFileDetailResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *starfruit_carrot_stream_analysis.GetCapturedFileDetailResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *starfruit_carrot_stream_analysis.GetCapturedFileDetailResponse and nil error while calling GetCapturedFileDetail. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveGetCapturedFileDetailProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCapturedFileDetail")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(starfruit_carrot_stream_analysis.GetCapturedFileDetailRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.CarrotControl.GetCapturedFileDetail
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *starfruit_carrot_stream_analysis.GetCapturedFileDetailRequest) (*starfruit_carrot_stream_analysis.GetCapturedFileDetailResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_stream_analysis.GetCapturedFileDetailRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_stream_analysis.GetCapturedFileDetailRequest) when calling interceptor")
					}
					return s.CarrotControl.GetCapturedFileDetail(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_stream_analysis.GetCapturedFileDetailResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_stream_analysis.GetCapturedFileDetailResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *starfruit_carrot_stream_analysis.GetCapturedFileDetailResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *starfruit_carrot_stream_analysis.GetCapturedFileDetailResponse and nil error while calling GetCapturedFileDetail. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveGetCapturedFileDownloadLink(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetCapturedFileDownloadLinkJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetCapturedFileDownloadLinkProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *carrotControlServer) serveGetCapturedFileDownloadLinkJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCapturedFileDownloadLink")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.CarrotControl.GetCapturedFileDownloadLink
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkRequest) (*starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkRequest) when calling interceptor")
					}
					return s.CarrotControl.GetCapturedFileDownloadLink(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkResponse and nil error while calling GetCapturedFileDownloadLink. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveGetCapturedFileDownloadLinkProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCapturedFileDownloadLink")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.CarrotControl.GetCapturedFileDownloadLink
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkRequest) (*starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkRequest) when calling interceptor")
					}
					return s.CarrotControl.GetCapturedFileDownloadLink(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *starfruit_carrot_stream_analysis.GetCapturedFileDownloadLinkResponse and nil error while calling GetCapturedFileDownloadLink. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveGetStreamConfig(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetStreamConfigJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetStreamConfigProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *carrotControlServer) serveGetStreamConfigJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamConfig")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(GetStreamConfigRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.CarrotControl.GetStreamConfig
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetStreamConfigRequest) (*GetStreamConfigResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetStreamConfigRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetStreamConfigRequest) when calling interceptor")
					}
					return s.CarrotControl.GetStreamConfig(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetStreamConfigResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetStreamConfigResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *GetStreamConfigResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetStreamConfigResponse and nil error while calling GetStreamConfig. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveGetStreamConfigProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamConfig")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(GetStreamConfigRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.CarrotControl.GetStreamConfig
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetStreamConfigRequest) (*GetStreamConfigResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetStreamConfigRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetStreamConfigRequest) when calling interceptor")
					}
					return s.CarrotControl.GetStreamConfig(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetStreamConfigResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetStreamConfigResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *GetStreamConfigResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetStreamConfigResponse and nil error while calling GetStreamConfig. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveListStreamConfigs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListStreamConfigsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListStreamConfigsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *carrotControlServer) serveListStreamConfigsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamConfigs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(ListStreamConfigsRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.CarrotControl.ListStreamConfigs
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *ListStreamConfigsRequest) (*twitch_video_starfruitiocp.ListStreamConfigsResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListStreamConfigsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListStreamConfigsRequest) when calling interceptor")
					}
					return s.CarrotControl.ListStreamConfigs(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*twitch_video_starfruitiocp.ListStreamConfigsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*twitch_video_starfruitiocp.ListStreamConfigsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *twitch_video_starfruitiocp.ListStreamConfigsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *twitch_video_starfruitiocp.ListStreamConfigsResponse and nil error while calling ListStreamConfigs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveListStreamConfigsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamConfigs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(ListStreamConfigsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.CarrotControl.ListStreamConfigs
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *ListStreamConfigsRequest) (*twitch_video_starfruitiocp.ListStreamConfigsResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListStreamConfigsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListStreamConfigsRequest) when calling interceptor")
					}
					return s.CarrotControl.ListStreamConfigs(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*twitch_video_starfruitiocp.ListStreamConfigsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*twitch_video_starfruitiocp.ListStreamConfigsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *twitch_video_starfruitiocp.ListStreamConfigsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *twitch_video_starfruitiocp.ListStreamConfigsResponse and nil error while calling ListStreamConfigs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveListStreamConfigsByRecordingConfig(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListStreamConfigsByRecordingConfigJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListStreamConfigsByRecordingConfigProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *carrotControlServer) serveListStreamConfigsByRecordingConfigJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamConfigsByRecordingConfig")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(ListStreamConfigsByRecordingConfigRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.CarrotControl.ListStreamConfigsByRecordingConfig
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *ListStreamConfigsByRecordingConfigRequest) (*twitch_video_starfruitiocp.ListStreamConfigsByRecordingConfigResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListStreamConfigsByRecordingConfigRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListStreamConfigsByRecordingConfigRequest) when calling interceptor")
					}
					return s.CarrotControl.ListStreamConfigsByRecordingConfig(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*twitch_video_starfruitiocp.ListStreamConfigsByRecordingConfigResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*twitch_video_starfruitiocp.ListStreamConfigsByRecordingConfigResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *twitch_video_starfruitiocp.ListStreamConfigsByRecordingConfigResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *twitch_video_starfruitiocp.ListStreamConfigsByRecordingConfigResponse and nil error while calling ListStreamConfigsByRecordingConfig. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveListStreamConfigsByRecordingConfigProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamConfigsByRecordingConfig")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(ListStreamConfigsByRecordingConfigRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.CarrotControl.ListStreamConfigsByRecordingConfig
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *ListStreamConfigsByRecordingConfigRequest) (*twitch_video_starfruitiocp.ListStreamConfigsByRecordingConfigResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListStreamConfigsByRecordingConfigRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListStreamConfigsByRecordingConfigRequest) when calling interceptor")
					}
					return s.CarrotControl.ListStreamConfigsByRecordingConfig(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*twitch_video_starfruitiocp.ListStreamConfigsByRecordingConfigResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*twitch_video_starfruitiocp.ListStreamConfigsByRecordingConfigResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *twitch_video_starfruitiocp.ListStreamConfigsByRecordingConfigResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *twitch_video_starfruitiocp.ListStreamConfigsByRecordingConfigResponse and nil error while calling ListStreamConfigsByRecordingConfig. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveGetStreamKey(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetStreamKeyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetStreamKeyProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *carrotControlServer) serveGetStreamKeyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(GetStreamKeyRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.CarrotControl.GetStreamKey
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetStreamKeyRequest) (*twitch_video_starfruitiocp1.StreamKey, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetStreamKeyRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetStreamKeyRequest) when calling interceptor")
					}
					return s.CarrotControl.GetStreamKey(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*twitch_video_starfruitiocp1.StreamKey)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*twitch_video_starfruitiocp1.StreamKey) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *twitch_video_starfruitiocp1.StreamKey
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *twitch_video_starfruitiocp1.StreamKey and nil error while calling GetStreamKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveGetStreamKeyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStreamKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(GetStreamKeyRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.CarrotControl.GetStreamKey
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetStreamKeyRequest) (*twitch_video_starfruitiocp1.StreamKey, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetStreamKeyRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetStreamKeyRequest) when calling interceptor")
					}
					return s.CarrotControl.GetStreamKey(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*twitch_video_starfruitiocp1.StreamKey)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*twitch_video_starfruitiocp1.StreamKey) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *twitch_video_starfruitiocp1.StreamKey
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *twitch_video_starfruitiocp1.StreamKey and nil error while calling GetStreamKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveListStreamKeysForContent(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListStreamKeysForContentJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListStreamKeysForContentProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *carrotControlServer) serveListStreamKeysForContentJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamKeysForContent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(ListStreamKeysForContentRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.CarrotControl.ListStreamKeysForContent
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *ListStreamKeysForContentRequest) (*twitch_video_starfruitiocp1.ListStreamKeysForContentResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListStreamKeysForContentRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListStreamKeysForContentRequest) when calling interceptor")
					}
					return s.CarrotControl.ListStreamKeysForContent(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*twitch_video_starfruitiocp1.ListStreamKeysForContentResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*twitch_video_starfruitiocp1.ListStreamKeysForContentResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *twitch_video_starfruitiocp1.ListStreamKeysForContentResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *twitch_video_starfruitiocp1.ListStreamKeysForContentResponse and nil error while calling ListStreamKeysForContent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveListStreamKeysForContentProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamKeysForContent")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(ListStreamKeysForContentRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.CarrotControl.ListStreamKeysForContent
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *ListStreamKeysForContentRequest) (*twitch_video_starfruitiocp1.ListStreamKeysForContentResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListStreamKeysForContentRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListStreamKeysForContentRequest) when calling interceptor")
					}
					return s.CarrotControl.ListStreamKeysForContent(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*twitch_video_starfruitiocp1.ListStreamKeysForContentResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*twitch_video_starfruitiocp1.ListStreamKeysForContentResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *twitch_video_starfruitiocp1.ListStreamKeysForContentResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *twitch_video_starfruitiocp1.ListStreamKeysForContentResponse and nil error while calling ListStreamKeysForContent. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveGetPlaybackKey(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetPlaybackKeyJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetPlaybackKeyProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *carrotControlServer) serveGetPlaybackKeyJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPlaybackKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(GetPlaybackKeyRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.CarrotControl.GetPlaybackKey
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetPlaybackKeyRequest) (*twitch_video_starfruitiocp2.GetPlaybackKeyResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetPlaybackKeyRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetPlaybackKeyRequest) when calling interceptor")
					}
					return s.CarrotControl.GetPlaybackKey(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*twitch_video_starfruitiocp2.GetPlaybackKeyResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*twitch_video_starfruitiocp2.GetPlaybackKeyResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *twitch_video_starfruitiocp2.GetPlaybackKeyResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *twitch_video_starfruitiocp2.GetPlaybackKeyResponse and nil error while calling GetPlaybackKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveGetPlaybackKeyProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPlaybackKey")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(GetPlaybackKeyRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.CarrotControl.GetPlaybackKey
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetPlaybackKeyRequest) (*twitch_video_starfruitiocp2.GetPlaybackKeyResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetPlaybackKeyRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetPlaybackKeyRequest) when calling interceptor")
					}
					return s.CarrotControl.GetPlaybackKey(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*twitch_video_starfruitiocp2.GetPlaybackKeyResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*twitch_video_starfruitiocp2.GetPlaybackKeyResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *twitch_video_starfruitiocp2.GetPlaybackKeyResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *twitch_video_starfruitiocp2.GetPlaybackKeyResponse and nil error while calling GetPlaybackKey. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveListPlaybackKeys(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListPlaybackKeysJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListPlaybackKeysProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *carrotControlServer) serveListPlaybackKeysJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListPlaybackKeys")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(ListPlaybackKeysRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.CarrotControl.ListPlaybackKeys
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *ListPlaybackKeysRequest) (*twitch_video_starfruitiocp2.ListPlaybackKeysResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListPlaybackKeysRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListPlaybackKeysRequest) when calling interceptor")
					}
					return s.CarrotControl.ListPlaybackKeys(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*twitch_video_starfruitiocp2.ListPlaybackKeysResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*twitch_video_starfruitiocp2.ListPlaybackKeysResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *twitch_video_starfruitiocp2.ListPlaybackKeysResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *twitch_video_starfruitiocp2.ListPlaybackKeysResponse and nil error while calling ListPlaybackKeys. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveListPlaybackKeysProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListPlaybackKeys")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(ListPlaybackKeysRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.CarrotControl.ListPlaybackKeys
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *ListPlaybackKeysRequest) (*twitch_video_starfruitiocp2.ListPlaybackKeysResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListPlaybackKeysRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListPlaybackKeysRequest) when calling interceptor")
					}
					return s.CarrotControl.ListPlaybackKeys(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*twitch_video_starfruitiocp2.ListPlaybackKeysResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*twitch_video_starfruitiocp2.ListPlaybackKeysResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *twitch_video_starfruitiocp2.ListPlaybackKeysResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *twitch_video_starfruitiocp2.ListPlaybackKeysResponse and nil error while calling ListPlaybackKeys. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveGetPlaybackAuthorization(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetPlaybackAuthorizationJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetPlaybackAuthorizationProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *carrotControlServer) serveGetPlaybackAuthorizationJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPlaybackAuthorization")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(GetPlaybackAuthorizationRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.CarrotControl.GetPlaybackAuthorization
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetPlaybackAuthorizationRequest) (*twitch_video_starfruitiocp2.GetPlaybackAuthorizationResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetPlaybackAuthorizationRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetPlaybackAuthorizationRequest) when calling interceptor")
					}
					return s.CarrotControl.GetPlaybackAuthorization(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*twitch_video_starfruitiocp2.GetPlaybackAuthorizationResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*twitch_video_starfruitiocp2.GetPlaybackAuthorizationResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *twitch_video_starfruitiocp2.GetPlaybackAuthorizationResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *twitch_video_starfruitiocp2.GetPlaybackAuthorizationResponse and nil error while calling GetPlaybackAuthorization. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveGetPlaybackAuthorizationProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPlaybackAuthorization")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(GetPlaybackAuthorizationRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.CarrotControl.GetPlaybackAuthorization
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetPlaybackAuthorizationRequest) (*twitch_video_starfruitiocp2.GetPlaybackAuthorizationResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetPlaybackAuthorizationRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetPlaybackAuthorizationRequest) when calling interceptor")
					}
					return s.CarrotControl.GetPlaybackAuthorization(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*twitch_video_starfruitiocp2.GetPlaybackAuthorizationResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*twitch_video_starfruitiocp2.GetPlaybackAuthorizationResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *twitch_video_starfruitiocp2.GetPlaybackAuthorizationResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *twitch_video_starfruitiocp2.GetPlaybackAuthorizationResponse and nil error while calling GetPlaybackAuthorization. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveListStreamEvents(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListStreamEventsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListStreamEventsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *carrotControlServer) serveListStreamEventsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamEvents")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(ListStreamEventsRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.CarrotControl.ListStreamEvents
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *ListStreamEventsRequest) (*twitch_video_starfruitsec.ListStreamEventsResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListStreamEventsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListStreamEventsRequest) when calling interceptor")
					}
					return s.CarrotControl.ListStreamEvents(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*twitch_video_starfruitsec.ListStreamEventsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*twitch_video_starfruitsec.ListStreamEventsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *twitch_video_starfruitsec.ListStreamEventsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *twitch_video_starfruitsec.ListStreamEventsResponse and nil error while calling ListStreamEvents. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveListStreamEventsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListStreamEvents")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(ListStreamEventsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.CarrotControl.ListStreamEvents
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *ListStreamEventsRequest) (*twitch_video_starfruitsec.ListStreamEventsResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListStreamEventsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListStreamEventsRequest) when calling interceptor")
					}
					return s.CarrotControl.ListStreamEvents(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*twitch_video_starfruitsec.ListStreamEventsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*twitch_video_starfruitsec.ListStreamEventsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *twitch_video_starfruitsec.ListStreamEventsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *twitch_video_starfruitsec.ListStreamEventsResponse and nil error while calling ListStreamEvents. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveListLimitBreachEvents(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListLimitBreachEventsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListLimitBreachEventsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *carrotControlServer) serveListLimitBreachEventsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListLimitBreachEvents")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(ListLimitBreachEventsRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.CarrotControl.ListLimitBreachEvents
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *ListLimitBreachEventsRequest) (*twitch_video_starfruitsec.ListLimitBreachEventsResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListLimitBreachEventsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListLimitBreachEventsRequest) when calling interceptor")
					}
					return s.CarrotControl.ListLimitBreachEvents(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*twitch_video_starfruitsec.ListLimitBreachEventsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*twitch_video_starfruitsec.ListLimitBreachEventsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *twitch_video_starfruitsec.ListLimitBreachEventsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *twitch_video_starfruitsec.ListLimitBreachEventsResponse and nil error while calling ListLimitBreachEvents. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveListLimitBreachEventsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListLimitBreachEvents")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(ListLimitBreachEventsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.CarrotControl.ListLimitBreachEvents
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *ListLimitBreachEventsRequest) (*twitch_video_starfruitsec.ListLimitBreachEventsResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListLimitBreachEventsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListLimitBreachEventsRequest) when calling interceptor")
					}
					return s.CarrotControl.ListLimitBreachEvents(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*twitch_video_starfruitsec.ListLimitBreachEventsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*twitch_video_starfruitsec.ListLimitBreachEventsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *twitch_video_starfruitsec.ListLimitBreachEventsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *twitch_video_starfruitsec.ListLimitBreachEventsResponse and nil error while calling ListLimitBreachEvents. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveEnqueueQuery(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveEnqueueQueryJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveEnqueueQueryProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *carrotControlServer) serveEnqueueQueryJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EnqueueQuery")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(starfruit_carrot_analytics_control.EnqueueQueryRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.CarrotControl.EnqueueQuery
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *starfruit_carrot_analytics_control.EnqueueQueryRequest) (*starfruit_carrot_analytics_control.EnqueueQueryResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_analytics_control.EnqueueQueryRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_analytics_control.EnqueueQueryRequest) when calling interceptor")
					}
					return s.CarrotControl.EnqueueQuery(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_analytics_control.EnqueueQueryResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_analytics_control.EnqueueQueryResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *starfruit_carrot_analytics_control.EnqueueQueryResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *starfruit_carrot_analytics_control.EnqueueQueryResponse and nil error while calling EnqueueQuery. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveEnqueueQueryProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "EnqueueQuery")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(starfruit_carrot_analytics_control.EnqueueQueryRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.CarrotControl.EnqueueQuery
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *starfruit_carrot_analytics_control.EnqueueQueryRequest) (*starfruit_carrot_analytics_control.EnqueueQueryResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_analytics_control.EnqueueQueryRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_analytics_control.EnqueueQueryRequest) when calling interceptor")
					}
					return s.CarrotControl.EnqueueQuery(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_analytics_control.EnqueueQueryResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_analytics_control.EnqueueQueryResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *starfruit_carrot_analytics_control.EnqueueQueryResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *starfruit_carrot_analytics_control.EnqueueQueryResponse and nil error while calling EnqueueQuery. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveGetQueryResult(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetQueryResultJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetQueryResultProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *carrotControlServer) serveGetQueryResultJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetQueryResult")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(starfruit_carrot_analytics_control.GetQueryResultRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.CarrotControl.GetQueryResult
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *starfruit_carrot_analytics_control.GetQueryResultRequest) (*starfruit_carrot_analytics_control.GetQueryResultResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_analytics_control.GetQueryResultRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_analytics_control.GetQueryResultRequest) when calling interceptor")
					}
					return s.CarrotControl.GetQueryResult(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_analytics_control.GetQueryResultResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_analytics_control.GetQueryResultResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *starfruit_carrot_analytics_control.GetQueryResultResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *starfruit_carrot_analytics_control.GetQueryResultResponse and nil error while calling GetQueryResult. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveGetQueryResultProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetQueryResult")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(starfruit_carrot_analytics_control.GetQueryResultRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.CarrotControl.GetQueryResult
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *starfruit_carrot_analytics_control.GetQueryResultRequest) (*starfruit_carrot_analytics_control.GetQueryResultResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_analytics_control.GetQueryResultRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_analytics_control.GetQueryResultRequest) when calling interceptor")
					}
					return s.CarrotControl.GetQueryResult(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_analytics_control.GetQueryResultResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_analytics_control.GetQueryResultResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *starfruit_carrot_analytics_control.GetQueryResultResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *starfruit_carrot_analytics_control.GetQueryResultResponse and nil error while calling GetQueryResult. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveListQueries(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListQueriesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListQueriesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *carrotControlServer) serveListQueriesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListQueries")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(starfruit_carrot_analytics_control.ListQueriesRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.CarrotControl.ListQueries
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *starfruit_carrot_analytics_control.ListQueriesRequest) (*starfruit_carrot_analytics_control.ListQueriesResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_analytics_control.ListQueriesRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_analytics_control.ListQueriesRequest) when calling interceptor")
					}
					return s.CarrotControl.ListQueries(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_analytics_control.ListQueriesResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_analytics_control.ListQueriesResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *starfruit_carrot_analytics_control.ListQueriesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *starfruit_carrot_analytics_control.ListQueriesResponse and nil error while calling ListQueries. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveListQueriesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListQueries")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(starfruit_carrot_analytics_control.ListQueriesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.CarrotControl.ListQueries
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *starfruit_carrot_analytics_control.ListQueriesRequest) (*starfruit_carrot_analytics_control.ListQueriesResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_analytics_control.ListQueriesRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_analytics_control.ListQueriesRequest) when calling interceptor")
					}
					return s.CarrotControl.ListQueries(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_analytics_control.ListQueriesResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_analytics_control.ListQueriesResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *starfruit_carrot_analytics_control.ListQueriesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *starfruit_carrot_analytics_control.ListQueriesResponse and nil error while calling ListQueries. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveGetPoPHealth(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetPoPHealthJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetPoPHealthProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *carrotControlServer) serveGetPoPHealthJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPoPHealth")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(starfruit_carrot_system_health.GetPoPHealthRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.CarrotControl.GetPoPHealth
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *starfruit_carrot_system_health.GetPoPHealthRequest) (*starfruit_carrot_system_health.GetPoPHealthResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_system_health.GetPoPHealthRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_system_health.GetPoPHealthRequest) when calling interceptor")
					}
					return s.CarrotControl.GetPoPHealth(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_system_health.GetPoPHealthResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_system_health.GetPoPHealthResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *starfruit_carrot_system_health.GetPoPHealthResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *starfruit_carrot_system_health.GetPoPHealthResponse and nil error while calling GetPoPHealth. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveGetPoPHealthProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPoPHealth")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(starfruit_carrot_system_health.GetPoPHealthRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.CarrotControl.GetPoPHealth
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *starfruit_carrot_system_health.GetPoPHealthRequest) (*starfruit_carrot_system_health.GetPoPHealthResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_system_health.GetPoPHealthRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_system_health.GetPoPHealthRequest) when calling interceptor")
					}
					return s.CarrotControl.GetPoPHealth(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_system_health.GetPoPHealthResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_system_health.GetPoPHealthResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *starfruit_carrot_system_health.GetPoPHealthResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *starfruit_carrot_system_health.GetPoPHealthResponse and nil error while calling GetPoPHealth. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveGetAvailableCaptureEndpointRegions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetAvailableCaptureEndpointRegionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetAvailableCaptureEndpointRegionsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *carrotControlServer) serveGetAvailableCaptureEndpointRegionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAvailableCaptureEndpointRegions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(starfruit_carrot_rtmp_recorder.GetAvailableCaptureEndpointRegionsRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.CarrotControl.GetAvailableCaptureEndpointRegions
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *starfruit_carrot_rtmp_recorder.GetAvailableCaptureEndpointRegionsRequest) (*starfruit_carrot_rtmp_recorder.AvailableCaptureEndpointRegions, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_rtmp_recorder.GetAvailableCaptureEndpointRegionsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_rtmp_recorder.GetAvailableCaptureEndpointRegionsRequest) when calling interceptor")
					}
					return s.CarrotControl.GetAvailableCaptureEndpointRegions(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_rtmp_recorder.AvailableCaptureEndpointRegions)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_rtmp_recorder.AvailableCaptureEndpointRegions) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *starfruit_carrot_rtmp_recorder.AvailableCaptureEndpointRegions
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *starfruit_carrot_rtmp_recorder.AvailableCaptureEndpointRegions and nil error while calling GetAvailableCaptureEndpointRegions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveGetAvailableCaptureEndpointRegionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAvailableCaptureEndpointRegions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(starfruit_carrot_rtmp_recorder.GetAvailableCaptureEndpointRegionsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.CarrotControl.GetAvailableCaptureEndpointRegions
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *starfruit_carrot_rtmp_recorder.GetAvailableCaptureEndpointRegionsRequest) (*starfruit_carrot_rtmp_recorder.AvailableCaptureEndpointRegions, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_rtmp_recorder.GetAvailableCaptureEndpointRegionsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_rtmp_recorder.GetAvailableCaptureEndpointRegionsRequest) when calling interceptor")
					}
					return s.CarrotControl.GetAvailableCaptureEndpointRegions(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_rtmp_recorder.AvailableCaptureEndpointRegions)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_rtmp_recorder.AvailableCaptureEndpointRegions) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *starfruit_carrot_rtmp_recorder.AvailableCaptureEndpointRegions
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *starfruit_carrot_rtmp_recorder.AvailableCaptureEndpointRegions and nil error while calling GetAvailableCaptureEndpointRegions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveCreateCaptureEndpoint(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateCaptureEndpointJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateCaptureEndpointProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *carrotControlServer) serveCreateCaptureEndpointJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateCaptureEndpoint")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(starfruit_carrot_rtmp_recorder.CreateCaptureEndpointRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.CarrotControl.CreateCaptureEndpoint
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *starfruit_carrot_rtmp_recorder.CreateCaptureEndpointRequest) (*starfruit_carrot_rtmp_recorder.CaptureEndpointInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_rtmp_recorder.CreateCaptureEndpointRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_rtmp_recorder.CreateCaptureEndpointRequest) when calling interceptor")
					}
					return s.CarrotControl.CreateCaptureEndpoint(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_rtmp_recorder.CaptureEndpointInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_rtmp_recorder.CaptureEndpointInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *starfruit_carrot_rtmp_recorder.CaptureEndpointInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *starfruit_carrot_rtmp_recorder.CaptureEndpointInfo and nil error while calling CreateCaptureEndpoint. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveCreateCaptureEndpointProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateCaptureEndpoint")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(starfruit_carrot_rtmp_recorder.CreateCaptureEndpointRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.CarrotControl.CreateCaptureEndpoint
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *starfruit_carrot_rtmp_recorder.CreateCaptureEndpointRequest) (*starfruit_carrot_rtmp_recorder.CaptureEndpointInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_rtmp_recorder.CreateCaptureEndpointRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_rtmp_recorder.CreateCaptureEndpointRequest) when calling interceptor")
					}
					return s.CarrotControl.CreateCaptureEndpoint(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_rtmp_recorder.CaptureEndpointInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_rtmp_recorder.CaptureEndpointInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *starfruit_carrot_rtmp_recorder.CaptureEndpointInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *starfruit_carrot_rtmp_recorder.CaptureEndpointInfo and nil error while calling CreateCaptureEndpoint. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveGetCaptureEndpoint(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetCaptureEndpointJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetCaptureEndpointProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *carrotControlServer) serveGetCaptureEndpointJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCaptureEndpoint")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(starfruit_carrot_rtmp_recorder.GetCaptureEndpointRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.CarrotControl.GetCaptureEndpoint
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *starfruit_carrot_rtmp_recorder.GetCaptureEndpointRequest) (*starfruit_carrot_rtmp_recorder.CaptureEndpointDetail, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_rtmp_recorder.GetCaptureEndpointRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_rtmp_recorder.GetCaptureEndpointRequest) when calling interceptor")
					}
					return s.CarrotControl.GetCaptureEndpoint(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_rtmp_recorder.CaptureEndpointDetail)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_rtmp_recorder.CaptureEndpointDetail) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *starfruit_carrot_rtmp_recorder.CaptureEndpointDetail
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *starfruit_carrot_rtmp_recorder.CaptureEndpointDetail and nil error while calling GetCaptureEndpoint. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveGetCaptureEndpointProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCaptureEndpoint")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(starfruit_carrot_rtmp_recorder.GetCaptureEndpointRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.CarrotControl.GetCaptureEndpoint
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *starfruit_carrot_rtmp_recorder.GetCaptureEndpointRequest) (*starfruit_carrot_rtmp_recorder.CaptureEndpointDetail, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_rtmp_recorder.GetCaptureEndpointRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_rtmp_recorder.GetCaptureEndpointRequest) when calling interceptor")
					}
					return s.CarrotControl.GetCaptureEndpoint(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_rtmp_recorder.CaptureEndpointDetail)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_rtmp_recorder.CaptureEndpointDetail) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *starfruit_carrot_rtmp_recorder.CaptureEndpointDetail
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *starfruit_carrot_rtmp_recorder.CaptureEndpointDetail and nil error while calling GetCaptureEndpoint. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveListCaptureEndpoints(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListCaptureEndpointsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListCaptureEndpointsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *carrotControlServer) serveListCaptureEndpointsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListCaptureEndpoints")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(starfruit_carrot_rtmp_recorder.ListCaptureEndpointsRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.CarrotControl.ListCaptureEndpoints
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *starfruit_carrot_rtmp_recorder.ListCaptureEndpointsRequest) (*starfruit_carrot_rtmp_recorder.ListCaptureEndpointsResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_rtmp_recorder.ListCaptureEndpointsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_rtmp_recorder.ListCaptureEndpointsRequest) when calling interceptor")
					}
					return s.CarrotControl.ListCaptureEndpoints(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_rtmp_recorder.ListCaptureEndpointsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_rtmp_recorder.ListCaptureEndpointsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *starfruit_carrot_rtmp_recorder.ListCaptureEndpointsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *starfruit_carrot_rtmp_recorder.ListCaptureEndpointsResponse and nil error while calling ListCaptureEndpoints. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveListCaptureEndpointsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListCaptureEndpoints")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(starfruit_carrot_rtmp_recorder.ListCaptureEndpointsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.CarrotControl.ListCaptureEndpoints
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *starfruit_carrot_rtmp_recorder.ListCaptureEndpointsRequest) (*starfruit_carrot_rtmp_recorder.ListCaptureEndpointsResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_rtmp_recorder.ListCaptureEndpointsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_rtmp_recorder.ListCaptureEndpointsRequest) when calling interceptor")
					}
					return s.CarrotControl.ListCaptureEndpoints(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_rtmp_recorder.ListCaptureEndpointsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_rtmp_recorder.ListCaptureEndpointsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *starfruit_carrot_rtmp_recorder.ListCaptureEndpointsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *starfruit_carrot_rtmp_recorder.ListCaptureEndpointsResponse and nil error while calling ListCaptureEndpoints. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveCreateRTMPDump(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateRTMPDumpJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateRTMPDumpProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *carrotControlServer) serveCreateRTMPDumpJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateRTMPDump")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(starfruit_carrot_rtmp_recorder.CreateRTMPDumpRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.CarrotControl.CreateRTMPDump
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *starfruit_carrot_rtmp_recorder.CreateRTMPDumpRequest) (*starfruit_carrot_rtmp_recorder.CreateRTMPDumpResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_rtmp_recorder.CreateRTMPDumpRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_rtmp_recorder.CreateRTMPDumpRequest) when calling interceptor")
					}
					return s.CarrotControl.CreateRTMPDump(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_rtmp_recorder.CreateRTMPDumpResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_rtmp_recorder.CreateRTMPDumpResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *starfruit_carrot_rtmp_recorder.CreateRTMPDumpResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *starfruit_carrot_rtmp_recorder.CreateRTMPDumpResponse and nil error while calling CreateRTMPDump. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveCreateRTMPDumpProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateRTMPDump")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(starfruit_carrot_rtmp_recorder.CreateRTMPDumpRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.CarrotControl.CreateRTMPDump
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *starfruit_carrot_rtmp_recorder.CreateRTMPDumpRequest) (*starfruit_carrot_rtmp_recorder.CreateRTMPDumpResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_rtmp_recorder.CreateRTMPDumpRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_rtmp_recorder.CreateRTMPDumpRequest) when calling interceptor")
					}
					return s.CarrotControl.CreateRTMPDump(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_rtmp_recorder.CreateRTMPDumpResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_rtmp_recorder.CreateRTMPDumpResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *starfruit_carrot_rtmp_recorder.CreateRTMPDumpResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *starfruit_carrot_rtmp_recorder.CreateRTMPDumpResponse and nil error while calling CreateRTMPDump. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveGetRTMPDump(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetRTMPDumpJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetRTMPDumpProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *carrotControlServer) serveGetRTMPDumpJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRTMPDump")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(starfruit_carrot_rtmp_recorder.GetRTMPDumpRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.CarrotControl.GetRTMPDump
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *starfruit_carrot_rtmp_recorder.GetRTMPDumpRequest) (*starfruit_carrot_rtmp_recorder.RTMPDumpSummary, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_rtmp_recorder.GetRTMPDumpRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_rtmp_recorder.GetRTMPDumpRequest) when calling interceptor")
					}
					return s.CarrotControl.GetRTMPDump(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_rtmp_recorder.RTMPDumpSummary)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_rtmp_recorder.RTMPDumpSummary) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *starfruit_carrot_rtmp_recorder.RTMPDumpSummary
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *starfruit_carrot_rtmp_recorder.RTMPDumpSummary and nil error while calling GetRTMPDump. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveGetRTMPDumpProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetRTMPDump")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(starfruit_carrot_rtmp_recorder.GetRTMPDumpRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.CarrotControl.GetRTMPDump
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *starfruit_carrot_rtmp_recorder.GetRTMPDumpRequest) (*starfruit_carrot_rtmp_recorder.RTMPDumpSummary, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_rtmp_recorder.GetRTMPDumpRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_rtmp_recorder.GetRTMPDumpRequest) when calling interceptor")
					}
					return s.CarrotControl.GetRTMPDump(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_rtmp_recorder.RTMPDumpSummary)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_rtmp_recorder.RTMPDumpSummary) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *starfruit_carrot_rtmp_recorder.RTMPDumpSummary
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *starfruit_carrot_rtmp_recorder.RTMPDumpSummary and nil error while calling GetRTMPDump. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveListRTMPDumps(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListRTMPDumpsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListRTMPDumpsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *carrotControlServer) serveListRTMPDumpsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListRTMPDumps")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(starfruit_carrot_rtmp_recorder.ListRTMPDumpsRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.CarrotControl.ListRTMPDumps
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *starfruit_carrot_rtmp_recorder.ListRTMPDumpsRequest) (*starfruit_carrot_rtmp_recorder.ListRTMPDumpsResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_rtmp_recorder.ListRTMPDumpsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_rtmp_recorder.ListRTMPDumpsRequest) when calling interceptor")
					}
					return s.CarrotControl.ListRTMPDumps(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_rtmp_recorder.ListRTMPDumpsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_rtmp_recorder.ListRTMPDumpsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *starfruit_carrot_rtmp_recorder.ListRTMPDumpsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *starfruit_carrot_rtmp_recorder.ListRTMPDumpsResponse and nil error while calling ListRTMPDumps. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveListRTMPDumpsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListRTMPDumps")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(starfruit_carrot_rtmp_recorder.ListRTMPDumpsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.CarrotControl.ListRTMPDumps
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *starfruit_carrot_rtmp_recorder.ListRTMPDumpsRequest) (*starfruit_carrot_rtmp_recorder.ListRTMPDumpsResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_rtmp_recorder.ListRTMPDumpsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_rtmp_recorder.ListRTMPDumpsRequest) when calling interceptor")
					}
					return s.CarrotControl.ListRTMPDumps(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_rtmp_recorder.ListRTMPDumpsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_rtmp_recorder.ListRTMPDumpsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *starfruit_carrot_rtmp_recorder.ListRTMPDumpsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *starfruit_carrot_rtmp_recorder.ListRTMPDumpsResponse and nil error while calling ListRTMPDumps. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveWhatIs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveWhatIsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveWhatIsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *carrotControlServer) serveWhatIsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "WhatIs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(starfruit_carrot_omnibar.This)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.CarrotControl.WhatIs
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *starfruit_carrot_omnibar.This) (*starfruit_carrot_omnibar.Thing, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_omnibar.This)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_omnibar.This) when calling interceptor")
					}
					return s.CarrotControl.WhatIs(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_omnibar.Thing)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_omnibar.Thing) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *starfruit_carrot_omnibar.Thing
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *starfruit_carrot_omnibar.Thing and nil error while calling WhatIs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) serveWhatIsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "WhatIs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(starfruit_carrot_omnibar.This)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.CarrotControl.WhatIs
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *starfruit_carrot_omnibar.This) (*starfruit_carrot_omnibar.Thing, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*starfruit_carrot_omnibar.This)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*starfruit_carrot_omnibar.This) when calling interceptor")
					}
					return s.CarrotControl.WhatIs(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*starfruit_carrot_omnibar.Thing)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*starfruit_carrot_omnibar.Thing) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *starfruit_carrot_omnibar.Thing
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *starfruit_carrot_omnibar.Thing and nil error while calling WhatIs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotControlServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *carrotControlServer) ProtocGenTwirpVersion() string {
	return "v8.1.0"
}

// PathPrefix returns the base service path, in the form: "/<prefix>/<package>.<Service>/"
// that is everything in a Twirp route except for the <Method>. This can be used for routing,
// for example to identify the requests that are targeted to this service in a mux.
func (s *carrotControlServer) PathPrefix() string {
	return baseServicePath(s.pathPrefix, "starfruit.carrot_control", "CarrotControl")
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler

	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// google.golang.org/protobuf/types/descriptorpb.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)

	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string

	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route Twirp requests.
	// The path prefix is in the form: "/<prefix>/<package>.<Service>/"
	// that is, everything in a Twirp route except for the <Method> at the end.
	PathPrefix() string
}

func newServerOpts(opts []interface{}) *twirp.ServerOptions {
	serverOpts := &twirp.ServerOptions{}
	for _, opt := range opts {
		switch o := opt.(type) {
		case twirp.ServerOption:
			o(serverOpts)
		case *twirp.ServerHooks: // backwards compatibility, allow to specify hooks as an argument
			twirp.WithServerHooks(o)(serverOpts)
		case nil: // backwards compatibility, allow nil value for the argument
			continue
		default:
			panic(fmt.Sprintf("Invalid option type %T, please use a twirp.ServerOption", o))
		}
	}
	return serverOpts
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Convert to a twirp.Error. Non-twirp errors are converted to internal errors.
	var twerr twirp.Error
	if !errors.As(err, &twerr) {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// sanitizeBaseURL parses the the baseURL, and adds the "http" scheme if needed.
// If the URL is unparsable, the baseURL is returned unchaged.
func sanitizeBaseURL(baseURL string) string {
	u, err := url.Parse(baseURL)
	if err != nil {
		return baseURL // invalid URL will fail later when making requests
	}
	if u.Scheme == "" {
		u.Scheme = "http"
	}
	return u.String()
}

// baseServicePath composes the path prefix for the service (without <Method>).
// e.g.: baseServicePath("/twirp", "my.pkg", "MyService")
//       returns => "/twirp/my.pkg.MyService/"
// e.g.: baseServicePath("", "", "MyService")
//       returns => "/MyService/"
func baseServicePath(prefix, pkg, service string) string {
	fullServiceName := service
	if pkg != "" {
		fullServiceName = pkg + "." + service
	}
	return path.Join("/", prefix, fullServiceName) + "/"
}

// parseTwirpPath extracts path components form a valid Twirp route.
// Expected format: "[<prefix>]/<package>.<Service>/<Method>"
// e.g.: prefix, pkgService, method := parseTwirpPath("/twirp/pkg.Svc/MakeHat")
func parseTwirpPath(path string) (string, string, string) {
	parts := strings.Split(path, "/")
	if len(parts) < 2 {
		return "", "", ""
	}
	method := parts[len(parts)-1]
	pkgService := parts[len(parts)-2]
	prefix := strings.Join(parts[0:len(parts)-2], "/")
	return prefix, pkgService, method
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v8.1.0")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429: // Too Many Requests
			code = twirp.ResourceExhausted
		case 502, 503, 504: // Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	marshaler := &protojson.MarshalOptions{UseProtoNames: true}
	reqBytes, err := marshaler.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, bytes.NewReader(reqBytes), "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	d := json.NewDecoder(resp.Body)
	rawRespBody := json.RawMessage{}
	if err := d.Decode(&rawRespBody); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawRespBody, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 1374 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x98, 0x5d, 0x6f, 0x1b, 0x45,
	0x17, 0xc7, 0xb5, 0x4f, 0xa5, 0x3e, 0x74, 0xdc, 0xd7, 0x29, 0x6d, 0xad, 0xa5, 0xa2, 0xc8, 0x12,
	0x52, 0x40, 0xb2, 0x97, 0x3a, 0x6d, 0xd3, 0xd2, 0x0a, 0xd4, 0x3a, 0x4e, 0xb0, 0x9a, 0x40, 0x6a,
	0x07, 0x81, 0x10, 0x92, 0x35, 0x59, 0x4f, 0xed, 0x21, 0xeb, 0x99, 0xed, 0xcc, 0x6c, 0x8a, 0x43,
	0xd5, 0xf2, 0x22, 0x51, 0x95, 0x1b, 0xde, 0x25, 0x3e, 0x40, 0xaf, 0xb8, 0x2a, 0x1f, 0x82, 0xef,
	0x85, 0x76, 0x77, 0xd6, 0xfb, 0xee, 0xdd, 0x4d, 0x23, 0xc1, 0x4d, 0x14, 0xef, 0x9c, 0xf3, 0x3f,
	0xbf, 0x3d, 0x67, 0x76, 0xce, 0xd1, 0x80, 0x63, 0xdc, 0x36, 0x5b, 0x36, 0x67, 0x92, 0xc1, 0xba,
	0x90, 0x88, 0xdf, 0xe7, 0x0e, 0x91, 0x2d, 0x13, 0x71, 0xce, 0xe4, 0xd0, 0x64, 0x54, 0x72, 0x66,
	0xe9, 0x9f, 0x9b, 0x6c, 0x84, 0x5b, 0x5f, 0x38, 0x42, 0x12, 0xda, 0x92, 0x7b, 0x06, 0xde, 0xc3,
	0x54, 0x36, 0x31, 0x1d, 0x13, 0x8a, 0x31, 0x27, 0x74, 0x6c, 0xf8, 0x0e, 0x4d, 0x21, 0x39, 0x46,
	0xd3, 0x26, 0xa2, 0xc8, 0x9a, 0x09, 0x22, 0x0c, 0x7b, 0x77, 0x6c, 0x70, 0xdb, 0x54, 0xcb, 0x43,
	0x7f, 0x79, 0x18, 0x2c, 0xfb, 0x71, 0xf5, 0xbb, 0x65, 0xd5, 0x3d, 0x3f, 0x49, 0x4c, 0x61, 0x28,
	0x30, 0x5f, 0xdb, 0xff, 0x5f, 0x89, 0x7d, 0x5a, 0x1a, 0x75, 0x26, 0x24, 0x9e, 0x36, 0x27, 0x18,
	0x59, 0x72, 0x92, 0x02, 0xf5, 0x16, 0x87, 0xfe, 0x62, 0x55, 0x65, 0x2e, 0xa7, 0x76, 0x93, 0x63,
	0x93, 0xf1, 0x11, 0xe6, 0x49, 0x65, 0x77, 0x71, 0x18, 0x2c, 0x2a, 0xe5, 0x8d, 0xb2, 0xca, 0x6c,
	0x4a, 0xc9, 0x0e, 0x4a, 0x69, 0xaa, 0xc7, 0x4a, 0xed, 0x77, 0xad, 0xac, 0x5c, 0x90, 0xc5, 0x40,
	0x0e, 0x4d, 0xf7, 0xa9, 0x31, 0x08, 0x36, 0x41, 0xef, 0xa3, 0xce, 0xd6, 0xc0, 0x9c, 0xe0, 0x29,
	0x32, 0xa6, 0x6c, 0x84, 0x2d, 0x23, 0x21, 0x9b, 0xb6, 0xde, 0x7e, 0x48, 0xb8, 0x6d, 0xa8, 0x22,
	0x9b, 0x8c, 0xde, 0x27, 0xe3, 0x21, 0xb2, 0x89, 0xe2, 0xfa, 0xe5, 0xbf, 0xc1, 0xb5, 0x8b, 0x67,
	0x11, 0xa8, 0xdf, 0xfe, 0x65, 0x28, 0xdb, 0x42, 0xb3, 0x1d, 0x64, 0xee, 0x26, 0xb0, 0x9e, 0x1e,
	0x12, 0xd6, 0xa0, 0xdb, 0x29, 0x4f, 0x35, 0xe8, 0x76, 0x7c, 0x28, 0xe9, 0xfe, 0xf5, 0x49, 0x1a,
	0x75, 0x70, 0x7e, 0x1d, 0xcb, 0x4d, 0x36, 0x72, 0x2c, 0x7c, 0xdb, 0x34, 0xb1, 0x10, 0x7d, 0xfc,
	0xc0, 0xc1, 0x42, 0x36, 0x9e, 0x6b, 0xe0, 0x42, 0x6a, 0x49, 0xd8, 0x8c, 0x0a, 0x0c, 0xdf, 0x06,
	0x67, 0x4c, 0x44, 0x87, 0xc8, 0x7b, 0xaa, 0xbe, 0xa6, 0xba, 0xf6, 0x86, 0xb6, 0xf4, 0x4a, 0xff,
	0x94, 0x89, 0xa8, 0x6f, 0x3d, 0xf0, 0x1e, 0xc3, 0x25, 0x70, 0x3a, 0x62, 0x2b, 0x19, 0xb3, 0x44,
	0xfd, 0x7f, 0x9e, 0xe9, 0xc9, 0xb9, 0xe9, 0xb6, 0xfb, 0x14, 0x2e, 0x83, 0xf3, 0x51, 0xcb, 0x87,
	0x44, 0x9a, 0x93, 0xe1, 0x08, 0x49, 0x54, 0x3f, 0xe2, 0xd9, 0x9f, 0x0d, 0xed, 0xbd, 0xb5, 0x55,
	0x24, 0x51, 0xe3, 0xb1, 0xf7, 0x02, 0x03, 0xaf, 0xf8, 0x1d, 0x6f, 0x4f, 0xaa, 0x17, 0x80, 0xe7,
	0xc1, 0x51, 0x8e, 0xc7, 0x84, 0x51, 0x8f, 0xec, 0x58, 0x5f, 0xfd, 0x82, 0x1b, 0xe0, 0xff, 0xdc,
	0x37, 0xf1, 0x38, 0x6a, 0xed, 0x76, 0xcb, 0x8f, 0xd5, 0xda, 0x23, 0x23, 0xcc, 0x5a, 0xf3, 0x63,
	0x92, 0x30, 0xd3, 0x6e, 0x65, 0x8b, 0xf7, 0x03, 0x89, 0xc6, 0x0b, 0x3f, 0x4d, 0x71, 0x1b, 0x95,
	0xa6, 0x4d, 0x70, 0x22, 0xf6, 0xb5, 0x78, 0x20, 0xb5, 0xf6, 0xd2, 0xa2, 0x78, 0x31, 0xa1, 0xe3,
	0x22, 0xf2, 0x0b, 0xae, 0x81, 0x5a, 0xb8, 0xc9, 0xdd, 0x24, 0x1e, 0x59, 0xaa, 0xb5, 0xdf, 0x2c,
	0x16, 0xbb, 0x8b, 0x67, 0x7d, 0x20, 0x82, 0x7f, 0x45, 0xe3, 0x5b, 0x0d, 0xd4, 0x37, 0x88, 0x88,
	0x31, 0x8b, 0xa2, 0xac, 0x7d, 0x98, 0xcc, 0xda, 0x95, 0x45, 0x81, 0xf3, 0xe4, 0xc3, 0xbc, 0x3d,
	0xd7, 0xc0, 0x5b, 0x29, 0xab, 0x3b, 0xb3, 0xbe, 0x77, 0x74, 0x12, 0x3a, 0x2e, 0x57, 0xcb, 0x61,
	0x92, 0xaa, 0x5b, 0x89, 0x2a, 0x2f, 0x5e, 0x88, 0xf9, 0x25, 0x38, 0x3b, 0xaf, 0xae, 0x9b, 0xc7,
	0x02, 0x9e, 0x5e, 0x92, 0xc7, 0x28, 0xb5, 0xb7, 0x42, 0xe5, 0x30, 0xf2, 0x4f, 0x1a, 0xb8, 0x14,
	0x02, 0xbb, 0x85, 0x5b, 0x63, 0xbc, 0xc3, 0xa8, 0xc4, 0x54, 0x16, 0x61, 0x7c, 0x9c, 0xc4, 0xb8,
	0x59, 0x2e, 0x2d, 0x99, 0x51, 0x42, 0xa4, 0x47, 0xe0, 0xdc, 0x3a, 0x96, 0x5b, 0xea, 0x4c, 0x2b,
	0x91, 0x8e, 0xbb, 0x49, 0x8e, 0xcb, 0x05, 0xe9, 0x48, 0x6b, 0x87, 0xd1, 0xbf, 0xd6, 0xc0, 0x05,
	0x17, 0x35, 0x62, 0x53, 0xb8, 0x6b, 0x37, 0x93, 0x00, 0xcb, 0x45, 0x89, 0xc8, 0x50, 0x8f, 0xd7,
	0x24, 0x42, 0x79, 0xdb, 0x91, 0x13, 0xc6, 0xc9, 0x3e, 0x92, 0x84, 0xd1, 0xc3, 0xad, 0x49, 0x41,
	0x94, 0x10, 0xe9, 0x89, 0x9f, 0x14, 0xbf, 0x7e, 0x5d, 0xb7, 0x8d, 0x88, 0x43, 0x3b, 0x00, 0x05,
	0x36, 0x5b, 0x39, 0xe2, 0x21, 0xc0, 0x33, 0x0d, 0x5c, 0x74, 0x8d, 0x36, 0xc8, 0x94, 0xc8, 0x3b,
	0x1c, 0x23, 0x73, 0x52, 0x0e, 0xe3, 0x5e, 0x12, 0x63, 0xa5, 0x00, 0x23, 0x2f, 0xc2, 0x9c, 0xa5,
	0xfd, 0xf7, 0x45, 0x70, 0xa2, 0xe3, 0x35, 0xce, 0x8e, 0xdf, 0x37, 0xe1, 0x1e, 0x38, 0x95, 0x68,
	0x62, 0xf0, 0x9d, 0x56, 0xde, 0x20, 0xdc, 0xca, 0x6e, 0x85, 0xfa, 0xe5, 0x0a, 0x1e, 0xea, 0xe8,
	0xff, 0x51, 0x03, 0x70, 0x1d, 0xcb, 0xce, 0x04, 0x51, 0x8a, 0xad, 0x01, 0x16, 0x82, 0x30, 0x2a,
	0xe0, 0xcd, 0xb4, 0x52, 0x72, 0x68, 0x4e, 0x7b, 0x05, 0x18, 0xb7, 0x0e, 0xe6, 0xac, 0x88, 0xbe,
	0xd3, 0xc0, 0x49, 0xf7, 0xc0, 0xf1, 0x9f, 0xbb, 0xbd, 0x13, 0xae, 0x94, 0x12, 0x8c, 0x78, 0x04,
	0x24, 0xd7, 0xab, 0x3b, 0x2a, 0x8a, 0x3f, 0x34, 0xef, 0x0c, 0xe9, 0x20, 0x5b, 0x3a, 0x1c, 0x8f,
	0xd6, 0x88, 0x85, 0x57, 0xb1, 0x44, 0xc4, 0x82, 0xef, 0x95, 0x7b, 0xbb, 0x94, 0x63, 0xc0, 0xf4,
	0xfe, 0x81, 0xfd, 0x15, 0xda, 0x9f, 0x1a, 0x78, 0x2d, 0x69, 0xc1, 0x1e, 0x52, 0x8b, 0xa1, 0xd1,
	0x06, 0xa1, 0xbb, 0x70, 0xb5, 0x7a, 0x80, 0x88, 0x7b, 0x80, 0xd9, 0x7d, 0x49, 0x15, 0x05, 0xeb,
	0xef, 0xeb, 0x68, 0x33, 0x2b, 0xd8, 0xd7, 0x19, 0x43, 0x4c, 0xc1, 0xbe, 0xce, 0x1c, 0x69, 0x1e,
	0x83, 0x33, 0xa9, 0x2e, 0x0a, 0xdb, 0xf9, 0x3a, 0x79, 0x83, 0x80, 0x7e, 0xb5, 0xe2, 0xf8, 0xa0,
	0xe2, 0xff, 0xa5, 0x81, 0x46, 0x71, 0x1b, 0x87, 0x9d, 0x0a, 0x44, 0x79, 0x43, 0x80, 0xbe, 0xf6,
	0xb2, 0xb3, 0x84, 0x62, 0x1e, 0x81, 0xe3, 0xd1, 0x4e, 0x0f, 0x9b, 0x25, 0xd2, 0x1e, 0x36, 0x40,
	0xbd, 0xdc, 0x84, 0x07, 0x7f, 0x8d, 0x4d, 0x75, 0xf1, 0x4e, 0x0e, 0x6f, 0x94, 0xc9, 0x47, 0x66,
	0xf7, 0xd7, 0x6f, 0x1d, 0x6c, 0x74, 0x50, 0xef, 0xee, 0x78, 0x87, 0x4e, 0xa4, 0xa9, 0x42, 0x63,
	0xe1, 0xdb, 0xa7, 0x07, 0x00, 0xbd, 0x5d, 0x65, 0x66, 0x50, 0x61, 0xbf, 0x02, 0xa7, 0x93, 0xcd,
	0x1c, 0x5e, 0x5e, 0x9c, 0x83, 0x8c, 0xc6, 0xaf, 0x5f, 0xa9, 0x36, 0x2d, 0xa8, 0xe0, 0x6e, 0x25,
	0xf2, 0xfa, 0xf7, 0xa2, 0x4a, 0x14, 0xf4, 0xfc, 0xc5, 0x95, 0xc8, 0x77, 0x56, 0x54, 0xfb, 0x7e,
	0x4a, 0xa2, 0xbd, 0xbc, 0x28, 0x25, 0x19, 0x7d, 0x5f, 0x5f, 0xae, 0x34, 0x2b, 0xa8, 0xd8, 0xcf,
	0x34, 0x70, 0x2e, 0xb3, 0x83, 0xc3, 0x6b, 0x8b, 0x09, 0xf2, 0x5a, 0xbe, 0x7e, 0xbd, 0xfa, 0xac,
	0xa0, 0x58, 0xbe, 0xd1, 0xc0, 0xf1, 0x2e, 0x7d, 0xe0, 0x60, 0x07, 0xdf, 0x73, 0x30, 0x9f, 0x65,
	0x75, 0xc1, 0xf9, 0x4d, 0xd4, 0x1c, 0x26, 0xea, 0xb1, 0xa0, 0x0b, 0x16, 0x39, 0x2a, 0x86, 0xa7,
	0x7e, 0x2f, 0x0e, 0x1e, 0x3a, 0x56, 0xe6, 0x17, 0x9a, 0x16, 0x8b, 0xfb, 0x04, 0x1c, 0xef, 0x1e,
	0xc4, 0x75, 0x7e, 0x9e, 0xd7, 0xdc, 0x74, 0xb9, 0x4b, 0x04, 0x67, 0x96, 0x23, 0x2d, 0x15, 0x71,
	0x08, 0x10, 0x56, 0x2a, 0xfb, 0xa9, 0xf8, 0x33, 0xef, 0x6c, 0xdc, 0x62, 0x5b, 0x1f, 0x78, 0x77,
	0x71, 0x70, 0x39, 0xa3, 0x3d, 0xc6, 0x2e, 0xeb, 0xa2, 0xd6, 0xe1, 0x67, 0x5a, 0xc9, 0x49, 0x85,
	0x7e, 0xa1, 0x81, 0xc6, 0x3a, 0x96, 0xb7, 0xf7, 0x10, 0xb1, 0xd0, 0x8e, 0x85, 0x55, 0xcf, 0xed,
	0xd2, 0x91, 0xcd, 0x88, 0x7b, 0x84, 0x8d, 0xbd, 0x91, 0xad, 0x97, 0x16, 0x8f, 0x5f, 0xf2, 0x15,
	0x6b, 0x2c, 0x18, 0x51, 0xe2, 0x52, 0x45, 0x2c, 0x3f, 0x68, 0xe0, 0x5c, 0x87, 0x63, 0x24, 0x93,
	0x06, 0xf0, 0x56, 0x91, 0x74, 0xa6, 0x5b, 0xf8, 0x51, 0x17, 0x79, 0xc7, 0xfd, 0x7a, 0xf4, 0x3e,
	0x83, 0xdf, 0xab, 0x11, 0x37, 0x41, 0x72, 0xa3, 0x44, 0xbe, 0x72, 0x30, 0xae, 0x56, 0xc4, 0x50,
	0x93, 0xe3, 0xcf, 0x1a, 0x78, 0xd5, 0xdd, 0x5b, 0x89, 0xd5, 0xcc, 0x69, 0x3b, 0xae, 0x97, 0xe5,
	0xb5, 0x60, 0xda, 0x2e, 0xe3, 0xac, 0x36, 0xd7, 0x13, 0x70, 0xd2, 0xcf, 0x78, 0x7f, 0x7b, 0x73,
	0x6b, 0xd5, 0x99, 0xda, 0xf0, 0x6a, 0xb9, 0x0a, 0x05, 0xf6, 0x01, 0xc6, 0xb5, 0xaa, 0x6e, 0x0a,
	0x80, 0x83, 0xda, 0x3a, 0x96, 0xf3, 0xe8, 0xed, 0x12, 0x55, 0x49, 0x86, 0x36, 0x8a, 0x7c, 0x02,
	0x87, 0x81, 0x33, 0x9d, 0x22, 0x3e, 0x83, 0x8f, 0xc0, 0x09, 0x37, 0x29, 0xc1, 0x63, 0x01, 0xaf,
	0x94, 0xc9, 0xe1, 0xdc, 0xbc, 0xf4, 0x36, 0x48, 0x78, 0xa9, 0x37, 0xee, 0x81, 0xa3, 0x9f, 0x4c,
	0x90, 0xec, 0x09, 0xf8, 0x7a, 0x5a, 0x20, 0xb8, 0x43, 0xdf, 0x9e, 0x10, 0xa1, 0x5f, 0x5a, 0xb8,
	0x4e, 0xc7, 0x77, 0x6e, 0x7c, 0xb6, 0x72, 0xc0, 0x0b, 0xda, 0x9d, 0xa3, 0xde, 0xbd, 0xea, 0xf2,
	0x3f, 0x01, 0x00, 0x00, 0xff, 0xff, 0xc8, 0xbb, 0xa9, 0x60, 0x79, 0x19, 0x00, 0x00,
}
