package svc

import (
	"context"

	cac "code.justin.tv/event-engineering/carrot-analytics/control/rpc"
	aud "code.justin.tv/event-engineering/carrot-control/pkg/auditor"
)

// EnqueueQuery is just a direct passthrough to the twirp client for the Carrot Analytics service
func (c *client) EnqueueQuery(context context.Context, request *cac.EnqueueQueryRequest) (*cac.EnqueueQueryResponse, error) {
	// We need some audit here so that we can handle the errors
	err := c.WriteAudit(context, aud.Audit{
		Endpoint: "EnqueueQuery-start",
	})

	if err != nil {
		return nil, err
	}

	resp, err := c.analytics.EnqueueQuery(context, request)

	if err == nil {
		// Ignoring errors here because we already wrote an audit earlier that would have errored
		c.WriteAudit(context, aud.Audit{
			Endpoint: "EnqueueQuery",
			Data: map[string]string{
				"query_id": resp.QueryId,
			},
		})
	}

	return resp, err
}

// GetQueryResult is just a direct passthrough to the twirp client for the Carrot Analytics service
func (c *client) GetQueryResult(context context.Context, request *cac.GetQueryResultRequest) (*cac.GetQueryResultResponse, error) {
	err := c.WriteAudit(context, aud.Audit{
		Endpoint: "GetQueryResult",
		Data: map[string]string{
			"query_id": request.QueryId,
		},
	})

	if err != nil {
		return nil, err
	}

	return c.analytics.GetQueryResult(context, request)
}

// ListQueries is just a direct passthrough to the twirp client for the Carrot Analytics service
func (c *client) ListQueries(context context.Context, request *cac.ListQueriesRequest) (*cac.ListQueriesResponse, error) {
	err := c.WriteAudit(context, aud.Audit{
		Endpoint: "ListQueries",
		Data: map[string]string{
			"requested_by": request.RequestedBy,
		},
	})

	if err != nil {
		return nil, err
	}

	return c.analytics.ListQueries(context, request)
}
