package svc

import "context"

type key int

const (
	keyClientID key = iota
	keyUserID   key = iota
)

const ClientIDHeader = "carrot-client-id"
const AuditUserIDHeader = "carrot-audit-user-id"

// WithClientID will add the supplied clientID to the context
func WithClientID(ctx context.Context, clientID string) context.Context {
	return context.WithValue(ctx, keyClientID, clientID)
}

func ClientID(ctx context.Context) string {
	clientID, ok := ctx.Value(keyClientID).(string)
	if !ok {
		return ""
	}
	return clientID
}

// WithUserID will add the supplied userID to the context
func WithUserID(ctx context.Context, userID string) context.Context {
	return context.WithValue(ctx, keyUserID, userID)
}

func UserID(ctx context.Context) string {
	userID, ok := ctx.Value(keyUserID).(string)
	if !ok {
		return ""
	}
	return userID
}
