package svc

import (
	"context"

	csh "code.justin.tv/event-engineering/carrot-system-health/pkg/rpc"
)

// GetPoPHealth is just a direct passthrough to the twirp client for the Carrot System Health service
func (c *client) GetPoPHealth(context context.Context, request *csh.GetPoPHealthRequest) (*csh.GetPoPHealthResponse, error) {
	// We're not auditing this request because it seems pointless
	err := c.canAccessTools(context)
	if err != nil {
		return nil, err
	}

	return c.health.GetPoPHealth(context, request)
}
