package svc

import (
	"context"

	omnibar "code.justin.tv/event-engineering/carrot-omnibar/pkg/rpc"

	aud "code.justin.tv/event-engineering/carrot-control/pkg/auditor"
)

// WhatIs calls the Omnibar endpoint and returns the result
func (c *client) WhatIs(ctx context.Context, request *omnibar.This) (*omnibar.Thing, error) {
	err := c.WriteAudit(ctx, aud.Audit{
		Endpoint: "WhatIs",
		Data: map[string]string{
			"thing": request.Thing,
		},
	})

	if err != nil {
		return nil, err
	}

	resp, err := c.omnibar.WhatIs(ctx, request)

	if err != nil {
		return nil, err
	}

	// Only certain people can view the full weaver payload
	if resp.WeaverPayloadJson != "" {
		err = c.canAccessTools(ctx)

		if err != nil {
			resp.WeaverPayloadJson = ""
		}
	}

	return resp, nil
}
