# carrot-events
Keep an eye on streams and notify requestors when something interesting happens

### Service Endpoints

This all works using Twirp over Lambda Transport

`Staging: arn:aws::some-lambda-arn`\
`Production: arn:aws::some-lambda-arn`

### Usage

Tell the service that you're interested in a particular stream and tell it an SQS queue to send notifications to
```
example.TwirpCall(&twirpPayload{
    CustomerId: "06785934948",
    ContentId: "my-first-stream",
    SQSQueueURL: "https://sqs.queue.url/someshit",
    Metadata: "whatever you want - this will get sent alongside the SQS message",
})
```

Configure permissions on your SQS queue to allow carrot to send messages to it
#### Staging
```
{
  "Example": "IAM Policy"
}
```
#### Production
```
{
  "Example": "IAM Policy"
}
```

### Events

#### Stream Up
Triggered when the RTMP connection from a client is received and authorised

#### Stream Down
Triggered when the RTMP connection from a client is disconnected

#### Starvation Detected
Triggered when ingest is not receiving data from the client fast enough to be real time

#### Failover
Triggered when a stream fails over from a primary RTMP source to a backup RTMP source (or vice versa)
