#!/usr/bin/env node
import "source-map-support/register";
import * as cdk from "@aws-cdk/core";
import { CarrotOmnibarStack } from "../lib/carrot-omnibar-stack";

const app = new cdk.App();
new CarrotOmnibarStack(app, "carrot-omnibar-stg", {
  cdkProps: {
    env: {
      region: "us-west-2",
      account: "134277936734",
    },
  },
  vpcId: "vpc-0ba8a2483a591a259",
  coProps: {
    invokeFunctionRoles: [
      "arn:aws:iam::134277936734:role/carrot-control-stg-CarrotControlServiceRole38F61F3-CUOBT9HTOPF4", // Carrot Control
      "arn:aws:iam::025746400680:role/bridge-stg-BridgeAppBridgeLambdaServiceRole033B00F-Y2CQYNURP5KB", // Video Bridge
    ],
    iocpHost: 'iocp.live-video.a2z.com',
    iocpStage: 'prod',
    iocpArn: '*',
  },
});

new CarrotOmnibarStack(app, "carrot-omnibar-prod", {
  cdkProps: {
    env: {
      region: "us-west-2",
      account: "782947612856",
    },
    terminationProtection: true,
  },
  vpcId: "vpc-094f73121cb30db65",
  coProps: {
    invokeFunctionRoles: [
      "arn:aws:iam::782947612856:role/carrot-control-prod-CarrotControlServiceRole38F61F-1IQPIF0KPHJF9", // Carrot Control
      "arn:aws:iam::000132032748:role/bridge-prod-BridgeAppBridgeLambdaServiceRole033B00-PFO2R9WHK1US", // Video Bridge
    ],
    iocpHost: 'iocp.live-video.a2z.com',
    iocpStage: 'prod',
    iocpArn: '*',
  },
});
