import * as cdk from '@aws-cdk/core';
import * as ec2 from '@aws-cdk/aws-ec2';

import { CarrotOmnibar, COProps } from './carrot-omnibar/carrot-omnibar'

export interface CarrotOmnibarProps {
  cdkProps: cdk.StackProps;
  coProps: COProps;
  vpcId: string
}

export class CarrotOmnibarStack extends cdk.Stack {
  constructor(scope: cdk.Construct, id: string, props: CarrotOmnibarProps) {
    super(scope, id, props.cdkProps);

    let vpc = ec2.Vpc.fromLookup(this, 'VpcRef', {
      vpcId: props.vpcId,
    })

    new CarrotOmnibar(this, 'Omnibar', vpc, props.coProps)
  }
}
