package main

import (
	"context"
	"encoding/json"
	"fmt"

	twirpLambda "code.justin.tv/amzn/TwirpGoLangAWSTransports/lambda"
	"code.justin.tv/coleiain/isengard-dev-helper/pkg/credentials"
	rpc "code.justin.tv/event-engineering/carrot-omnibar/pkg/rpc"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/lambda"
	"github.com/sirupsen/logrus"
)

var (
	awsAccountID = "134277936734" // starfruit-support+carrot-stg@amazon.com
	isengardRole = "Admin"
	awsRegion    = "us-west-2"
	lambdaARN    = "arn:aws:lambda:us-west-2:134277936734:function:carrot-omnibar-stg-OmnibarFunction2F151B77-M9L191IQKN42"
)

func main() {
	logger := logrus.New()
	logger.SetLevel(logrus.DebugLevel)

	credentials, err := credentials.GetIsengardCredentials(awsAccountID, isengardRole)

	if err != nil {
		panic(err)
	}

	sess, err := session.NewSession(&aws.Config{
		Region:      aws.String(awsRegion),
		Credentials: credentials,
	})

	if err != nil {
		panic(err)
	}

	lambdaClient := lambda.New(sess)
	lambdaTransport := twirpLambda.NewClient(lambdaClient, lambdaARN)

	client := rpc.NewCarrotOmnibarProtobufClient("https://would.you.like.a.carrot.twitch.tv", lambdaTransport)

	// Test your shit
	result, err := client.WhatIs(context.Background(), &rpc.This{
		Thing: "avc1.42C01F",
	})

	if err != nil {
		panic(err)
	}

	bytes, _ := json.MarshalIndent(result, "", "  ")
	fmt.Println(string(bytes))
}
