#!/usr/bin/env node
import 'source-map-support/register';
import * as cdk from '@aws-cdk/core';

import {CarrotRtmpRecorderStack} from '../lib/carrot-rtmp-recorder-stack';
import {CarrotRtmpRecorderAPIStack} from '../lib/carrot-rtmp-recorder-api-stack';

const app = new cdk.App();
const resourceGroupName = 'carrot-rtmp-recorder-resource-group';
const resourceGroupValue = 'would you like a carrot';

const stgDigestionEndpoints = [
    'https://v3.us-east-2.cmh.gamma.digestion.live-video-ext.a2z.com', // CMH
]

const stgDgnArns = [
    'arn:aws:execute-api:us-east-2:094649156782:*/*/*/*'
]

const prodDigestionEndpoints = [
    'https://v3.us-west-2.sjc.prod.digestion.live-video-ext.a2z.com', // SJC
    'https://v3.us-west-2.pdx.prod.digestion.live-video-ext.a2z.com', // PDX
    'https://v3.us-east-2.cmh.prod.digestion.live-video-ext.a2z.com', // CMH
    'https://v3.eu-west-2.lhr.prod.digestion.live-video-ext.a2z.com' // LHR
]

const prodDgnArns = [
    'arn:aws:execute-api:eu-west-2:623882245366:*/*/*/*',
    'arn:aws:execute-api:us-east-2:629365967711:*/*/*/*',
    'arn:aws:execute-api:us-west-2:769991230852:*/*/*/*',
    'arn:aws:execute-api:us-west-2:101577003404:*/*/*/*',
]

const stgRtmpsDomain = 'stg.support.contribute.live-video.net'

const prodRtmpsDomain = 'support.contribute.live-video.net'

const stagingRegions = [
    {
        region: 'us-west-2',
        cidr: '172.19.0.0/22'
    },
    {
        region: 'us-east-2',
        cidr: '172.19.4.0/22'
    },
];

const prodRegions = [
    {
        region: 'us-west-2',
        cidr: '172.19.0.0/22'
    },
    {
        region: 'us-east-2',
        cidr: '172.19.4.0/22'
    },
    {
        region: 'eu-west-2',
        cidr: '172.19.8.0/22'
    },
    {
        region: 'ap-southeast-1',
        cidr: '172.19.12.0/22'
    },
    {
        region: 'ap-south-1',
        cidr: '172.19.16.0/22'
    }
];

//============
//  STAGING
//============

let stagingRegionList = []
for (var region of stagingRegions) {
    stagingRegionList.push(region.region)
}

const stagingAPI = new CarrotRtmpRecorderAPIStack(app, 'carrot-rtmp-recorder-api-stg', 'vpc-0ba8a2483a591a259', {
    cdkProps: {
        env: {
            region: 'us-west-2',
            account: '134277936734',
        },
    },
    props: {
        invokeFunctionRoles: [
            'arn:aws:iam::134277936734:role/carrot-control-stg-CarrotControlServiceRole38F61F3-CUOBT9HTOPF4' // Carrot Control
        ],
        recordingEndpointRegions: stagingRegionList,
        digestionEndpoints: stgDigestionEndpoints,
        carrotStreamAnalysisLambdaARN: 'arn:aws:lambda:us-west-2:134277936734:function:carrot-stream-analysis-st-CarrotStreamAnalysis66AA-GL65ALU6B8B5',
        rtmpsDomain: stgRtmpsDomain,
        flvAnalyserRecordingBucketName: 'carrot-flv-analyser-recordings-stg',
        dgnARNs: stgDgnArns,
    },
});

for (var region of stagingRegions) {
    new CarrotRtmpRecorderStack(app, 'carrot-rtmp-recorder-stg-' + region.region, region.cidr, {
        cdkProps: {
            env: {
                region: region.region,
                account: '134277936734',
            },
        },
        props: {
            rtmpsHostName: region.region + '.' + stgRtmpsDomain,
            hostedZoneName: stgRtmpsDomain,
            resourceGroupName: resourceGroupName,
            resourceGroupValue: resourceGroupValue,
            controlAPIRegion: 'us-west-2',
            endpointTableArn: stagingAPI.RecorderAPI.EndpointsTable.tableArn,
            recordingBucketName: 'carrot-flv-analyser-recordings-stg',
            ecrRepositoryArn: stagingAPI.RecorderAPI.Repository.repositoryArn,
            ecrRepositoryName: stagingAPI.RecorderAPI.Repository.repositoryName,
        },
    });
}

//============
//  PROD
//============

let prodRegionList = []
for (var region of prodRegions) {
    prodRegionList.push(region.region)
}

const prodAPI = new CarrotRtmpRecorderAPIStack(app, 'carrot-rtmp-recorder-api-prod', 'vpc-094f73121cb30db65', {
    cdkProps: {
        env: {
            region: 'us-west-2',
            account: '782947612856',
        },
        terminationProtection: true
    },
    props: {
        invokeFunctionRoles: [
            'arn:aws:iam::782947612856:role/carrot-control-prod-CarrotControlServiceRole38F61F-1IQPIF0KPHJF9' // Carrot Control
        ],
        recordingEndpointRegions: prodRegionList,
        digestionEndpoints: prodDigestionEndpoints,
        carrotStreamAnalysisLambdaARN: 'arn:aws:lambda:us-west-2:782947612856:function:carrot-stream-analysis-pr-CarrotStreamAnalysis66AA-VPB1VZ30TXWK',
        rtmpsDomain: prodRtmpsDomain,
        flvAnalyserRecordingBucketName: 'carrot-flv-analyser-recordings-prod',
        dgnARNs: prodDgnArns,
    },
});

for (var region of prodRegions) {
    new CarrotRtmpRecorderStack(app, 'carrot-rtmp-recorder-prod-' + region.region, region.cidr, {
        cdkProps: {
            env: {
                region: region.region,
                account: '782947612856',
            },
            terminationProtection: true,
        },
        props: {
            rtmpsHostName: region.region + '.' + prodRtmpsDomain,
            hostedZoneName: prodRtmpsDomain,
            resourceGroupName: resourceGroupName,
            resourceGroupValue: resourceGroupValue,
            controlAPIRegion: 'us-west-2',
            endpointTableArn: prodAPI.RecorderAPI.EndpointsTable.tableArn,
            recordingBucketName: 'carrot-flv-analyser-recordings-prod',
            ecrRepositoryArn: prodAPI.RecorderAPI.Repository.repositoryArn,
            ecrRepositoryName: prodAPI.RecorderAPI.Repository.repositoryName,
        },
    });
}
