import * as cdk from '@aws-cdk/core';
import * as ec2 from '@aws-cdk/aws-ec2';
import { CarrotRtmpRecorderAPI, CarrotRtmpRecorderAPIProps } from './carrot-rtmp-recorder-api/carrot-rtmp-recorder-api';

export interface CarrotRtmpRecorderAPIStackProps {
  cdkProps: cdk.StackProps;
  props: CarrotRtmpRecorderAPIProps;
}

export class CarrotRtmpRecorderAPIStack extends cdk.Stack {
  Vpc: ec2.IVpc;
  RecorderAPI: CarrotRtmpRecorderAPI;

  constructor(scope: cdk.Construct, id: string, vpcId: string, props: CarrotRtmpRecorderAPIStackProps) {
    super(scope, id, props.cdkProps);

    this.Vpc = ec2.Vpc.fromLookup(this, 'VpcRef', { vpcId: vpcId })

    this.RecorderAPI = new CarrotRtmpRecorderAPI(this, 'API', this.Vpc, props.props)
  }
}
