import * as cdk from '@aws-cdk/core';
import * as ec2 from '@aws-cdk/aws-ec2';
import { CarrotRTMPRecorder, CarrotRTMPRecorderProps } from './carrot-rtmp-recorder/carrot-rtmp-recorder';

export interface CarrotRtmpRecorderProps {
  cdkProps: cdk.StackProps;
  props: CarrotRTMPRecorderProps;
}

export class CarrotRtmpRecorderStack extends cdk.Stack {
  Vpc: ec2.Vpc;
  RTMPRecorder: CarrotRTMPRecorder;

  constructor(scope: cdk.Construct, id: string, cidr: string, props: CarrotRtmpRecorderProps) {
    super(scope, id, props.cdkProps);

    this.Vpc = new ec2.Vpc(this, 'RecorderVpc', {
      maxAzs: 3,
      cidr: cidr,
    })

    cdk.Tags.of(this.Vpc).add(props.props.resourceGroupName, props.props.resourceGroupValue);

    this.RTMPRecorder = new CarrotRTMPRecorder(this, 'Recorder', this.Vpc, props.props)
  }
}
