package main

import (
	"context"
	"encoding/json"
	"fmt"

	twirpLambda "code.justin.tv/amzn/TwirpGoLangAWSTransports/lambda"
	"code.justin.tv/coleiain/isengard-dev-helper/pkg/credentials"
	rpc "code.justin.tv/event-engineering/carrot-rtmp-recorder/pkg/rpc"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/lambda"
	"github.com/sirupsen/logrus"
)

var (
	awsAccountID = "134277936734" // starfruit-support+carrot-stg@amazon.com
	isengardRole = "Admin"
	awsRegion    = "us-west-2"
	lambdaARN    = "arn:aws:lambda:us-west-2:134277936734:function:carrot-rtmp-recorder-api-APIRecorderServiceF507BB-M5X5M3TJGKG3"
)

func main() {
	logger := logrus.New()
	logger.SetLevel(logrus.DebugLevel)

	credentials, err := credentials.GetIsengardCredentials(awsAccountID, isengardRole)

	if err != nil {
		panic(err)
	}

	sess, err := session.NewSession(&aws.Config{
		Region:      aws.String(awsRegion),
		Credentials: credentials,
	})

	if err != nil {
		panic(err)
	}

	lambdaClient := lambda.New(sess)
	lambdaTransport := twirpLambda.NewClient(lambdaClient, lambdaARN)

	client := rpc.NewCarrotRtmpRecorderProtobufClient("https://would.you.like.a.carrot.twitch.tv", lambdaTransport)

	//doCreate(client)
	doList(client)
	//doGet(client, "59d48d7a-9a61-41a8-b4dc-9da032fa0081")
	doDump(client)
}

func doDump(client rpc.CarrotRtmpRecorder) {
	resp, err := client.CreateRTMPDump(context.Background(), &rpc.CreateRTMPDumpRequest{
		Region:     "us-west-2",
		Owner:      "coleiain",
		CustomerId: "twitch",
		ChannelId:  "gamesdonequick",
	})

	if err != nil {
		fmt.Println(err)
		return
	}

	fmt.Println(resp.RtmpDumpId)
}

func doList(client rpc.CarrotRtmpRecorder) {
	resp, err := client.ListCaptureEndpoints(context.Background(), &rpc.ListCaptureEndpointsRequest{
		Owner: "coleiain",
	})

	if err != nil {
		fmt.Println(err)
		return
	}

	bytes, _ := json.MarshalIndent(resp, "", "  ")
	fmt.Println(string(bytes))
}

func doCreate(client rpc.CarrotRtmpRecorder) {
	resp, err := client.CreateCaptureEndpoint(context.Background(), &rpc.CreateCaptureEndpointRequest{
		Owner:  "iain_test",
		Region: "us-east-2",
		Name:   "iain test 1",
	})

	if err != nil {
		fmt.Println(err)
		return
	}

	bytes, _ := json.MarshalIndent(resp, "", "  ")
	fmt.Println(string(bytes))
}

func doGet(client rpc.CarrotRtmpRecorder, id string) {
	resp, err := client.GetCaptureEndpoint(context.Background(), &rpc.GetCaptureEndpointRequest{
		Id: id,
	})

	if err != nil {
		fmt.Println(err)
		return
	}

	bytes, _ := json.MarshalIndent(resp, "", "  ")
	fmt.Println(string(bytes))
}
