package main

import (
	"log"

	"code.justin.tv/coleiain/isengard-dev-helper/pkg/credentials"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/endpoints"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/ecs"
)

var (
	awsAccountID = "134277936734" //starfruit-support+carrot-stg@amazon.com
	isengardRole = "Admin"
)

var settings = []string{
	"serviceLongArnFormat",
	"taskLongArnFormat",
	"containerInstanceLongArnFormat",
	"awsvpcTrunking",
	"containerInsights",
}

// Set the default longARN settings for ECS in all regions
func main() {
	credentials, err := credentials.GetIsengardCredentials(awsAccountID, isengardRole)

	if err != nil {
		panic(err)
	}

	partition := endpoints.AwsPartition()

	for _, region := range partition.Regions() {
		ecsClient := ecs.New(session.New(&aws.Config{
			Credentials: credentials,
			Region:      aws.String(region.ID()),
		}))

		for _, setting := range settings {
			_, err := ecsClient.PutAccountSettingDefault(&ecs.PutAccountSettingDefaultInput{
				Name:  aws.String(setting),
				Value: aws.String("enabled"),
			})

			if err != nil {
				log.Printf("Failed to put setting %v for region %v\n", setting, region.ID())
				continue
			}

			log.Printf("Put setting %v for region %v\n", setting, region.ID())
		}
	}
}
