package main

import (
	"os"
	"os/signal"
	"syscall"
	"time"

	"code.justin.tv/coleiain/isengard-dev-helper/pkg/credentials"
	"code.justin.tv/event-engineering/carrot-rtmp-recorder/pkg/server"
	"code.justin.tv/event-engineering/carrot-rtmp-recorder/pkg/svc"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/dynamodb"
	"github.com/aws/aws-sdk-go/service/s3"
	"github.com/sirupsen/logrus"
)

func main() {
	destBucketArn := "carrot-recorder-testing"
	destBucketRegion := "us-west-2"
	streamKey := "iaintest"
	s3Path := "iaintest/eaba8de8-8ac9-4e83-a3d7-0df202aecaa9/"
	maxDuration := 180

	logger := logrus.New()
	logger.SetLevel(logrus.DebugLevel)

	awsAccountID := "996545152037" //coleiain@amazon.com
	isengardRole := "Admin"

	credentials, err := credentials.GetIsengardCredentials(awsAccountID, isengardRole)

	if err != nil {
		panic(err)
	}

	sess, err := session.NewSession(&aws.Config{
		Region:      aws.String(destBucketRegion),
		Credentials: credentials,
	})

	if err != nil {
		panic(err)
	}

	s3Client := s3.New(sess)
	ddbClient := dynamodb.New(sess)

	statusUpdater := svc.NewStatusUpdater("carrot-rtmp-capture-endpoints", "", ddbClient, logger)

	server := server.New(destBucketArn, "somebullshit", streamKey, s3Path, time.Duration(maxDuration)*time.Second, s3Client, statusUpdater, logger)

	err = server.Start()
	if err != nil {
		panic(err)
	}

	logger.Info("Server started listening")

	osSig := make(chan os.Signal, 1)
	signal.Notify(osSig, os.Interrupt, syscall.SIGTERM, syscall.SIGQUIT)

	sig := <-osSig
	logger.Infof("Got signal %v, cleaning up", sig)

	server.Stop()

	logger.Info("Cleaned up, exiting")
}
