package main

import (
	"code.justin.tv/coleiain/isengard-dev-helper/pkg/credentials"
	rtmpdump "code.justin.tv/event-engineering/carrot-rtmp-recorder/pkg/rtmpdump"
	"code.justin.tv/event-engineering/carrot-rtmp-recorder/pkg/svc"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/dynamodb"
	"github.com/aws/aws-sdk-go/service/s3"
	"github.com/sirupsen/logrus"
)

var (
	awsAccountID = "134277936734" //starfruit-support+carrot-stg@amazon.com
	isengardRole = "Admin"
	awsRegion    = "us-west-2"
	s3Bucket     = "carrot-flv-analyser-recordings-stg"
	s3Key        = "dumps/iain_test_02.flv"
)

func main() {
	logger := logrus.New()
	logger.SetLevel(logrus.DebugLevel)

	credentials, err := credentials.GetIsengardCredentials(awsAccountID, isengardRole)

	if err != nil {
		logger.WithError(err).Fatal("Failed to generate credentials")
	}

	rtmpDumpsTableName := "carrot-rtmp-dumps"
	rtmpCaptureEndpointsTableName := "carrot-rtmp-capture-endpoints"

	sess := session.New(&aws.Config{
		Region:      aws.String(awsRegion),
		Credentials: credentials,
	})

	s3Client := s3.New(sess)
	ddbClient := dynamodb.New(sess)
	updater := svc.NewStatusUpdater(rtmpCaptureEndpointsTableName, rtmpDumpsTableName, ddbClient, logger)

	dumper := rtmpdump.New(s3Client, s3Bucket, updater, logger)

	req := svc.RTMPDumpRequest{
		RTMPURL:         "rtmp://10.27.33.108:22299/app/live_user_gamesdonequick",
		S3Key:           s3Key,
		DurationSeconds: 5,
	}

	err = dumper.DumpToS3(req)
	if err != nil {
		logger.WithError(err).Fatal("Failed to dump RTMP")
	}
}
