package ms2s3

import (
	"bytes"
	"io"
	"sync"

	"github.com/sirupsen/logrus"
)

type blockingReader struct {
	logger logrus.FieldLogger
	buf    bytes.Buffer
	closed bool
	cond   *sync.Cond
}

func newBlockingReader(logger logrus.FieldLogger) *blockingReader {
	m := sync.Mutex{}

	return &blockingReader{
		logger: logger,
		cond:   sync.NewCond(&m),
	}
}

func (br *blockingReader) Close() {
	br.closed = true
	br.cond.Broadcast()
}

func (br *blockingReader) Write(b []byte) (ln int, err error) {
	// If we don't copy shit here, it all goes wrong
	cBytes := make([]byte, len(b))
	copy(cBytes, b)

	ln, err = br.buf.Write(cBytes)
	br.cond.Broadcast()
	return
}

func (br *blockingReader) Read(b []byte) (ln int, err error) {
	// If we don't copy shit here, it all goes wrong
	cBytes := make([]byte, len(b))

	ln, err = br.buf.Read(cBytes)

	if err == io.EOF && !br.closed {
		br.cond.L.Lock()
		br.cond.Wait()
		br.cond.L.Unlock()
		ln, err = br.buf.Read(cBytes)
	}

	copy(b, cBytes)
	return
}
