package svc

import (
	"strings"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/ecs"
	"github.com/aws/aws-sdk-go/service/ecs/ecsiface"
)

func (c *client) regionIsValid(region string) bool {
	for _, ar := range c.availableRegions {
		if strings.EqualFold(region, ar) {
			return true
		}
	}

	return false
}

func (c *client) stopTask(ecsClient ecsiface.ECSAPI, clusterArn, taskArn, reason string) {
	// Attempt to stop the task
	_, err := ecsClient.StopTask(&ecs.StopTaskInput{
		Cluster: aws.String(clusterArn),
		Task:    aws.String(taskArn),
		Reason:  aws.String(reason),
	})

	if err != nil {
		c.logger.WithError(err).Warn("Failed to stop task after endpoint update failure")
	}
}
