package svc

import (
	"context"

	crr "code.justin.tv/event-engineering/carrot-rtmp-recorder/pkg/rpc"
	csa "code.justin.tv/event-engineering/carrot-stream-analysis/pkg/rpc"
	"github.com/aws/aws-sdk-go/service/dynamodb/dynamodbiface"
	"github.com/aws/aws-sdk-go/service/s3/s3iface"
	"github.com/aws/aws-sdk-go/service/sqs/sqsiface"
	"github.com/sirupsen/logrus"
)

// Client represents the RPCs for this service
type Client interface {
	GetAvailableCaptureEndpointRegions(context.Context, *crr.GetAvailableCaptureEndpointRegionsRequest) (*crr.AvailableCaptureEndpointRegions, error)
	CreateCaptureEndpoint(context.Context, *crr.CreateCaptureEndpointRequest) (*crr.CaptureEndpointInfo, error)
	GetCaptureEndpoint(context.Context, *crr.GetCaptureEndpointRequest) (*crr.CaptureEndpointDetail, error)
	ListCaptureEndpoints(context.Context, *crr.ListCaptureEndpointsRequest) (*crr.ListCaptureEndpointsResponse, error)
	CreateRTMPDump(context.Context, *crr.CreateRTMPDumpRequest) (*crr.CreateRTMPDumpResponse, error)
	GetRTMPDump(ctx context.Context, request *crr.GetRTMPDumpRequest) (*crr.RTMPDumpSummary, error)
	ListRTMPDumps(context.Context, *crr.ListRTMPDumpsRequest) (*crr.ListRTMPDumpsResponse, error)
}

type client struct {
	availableRegions   []string
	digestionEndpoints []string
	endpointsTableName string
	rtmpDumpsTableName string
	rtmpDumpQueueURL   string
	rtmpsDomain        string
	ddb                dynamodbiface.DynamoDBAPI
	s3                 s3iface.S3API
	sqs                sqsiface.SQSAPI
	csa                csa.CarrotStreamAnalysis
	operations         WorkerOperations
	logger             logrus.FieldLogger
}

// New creates the RTMP Recorder service object
func New(availableRegions, digestionEndpoints []string, endpointsTableName, rtmpDumpsTableName, rtmpDumpQueueURL, rtmpsDomain string, ddb dynamodbiface.DynamoDBAPI, s3 s3iface.S3API, sqs sqsiface.SQSAPI, csaClient csa.CarrotStreamAnalysis, logger logrus.FieldLogger) Client {
	return &client{
		availableRegions:   availableRegions,
		digestionEndpoints: digestionEndpoints,
		endpointsTableName: endpointsTableName,
		rtmpDumpsTableName: rtmpDumpsTableName,
		rtmpDumpQueueURL:   rtmpDumpQueueURL,
		rtmpsDomain:        rtmpsDomain,
		ddb:                ddb,
		operations:         NewWorkerOperations(endpointsTableName, rtmpDumpsTableName, ddb, logger),
		s3:                 s3,
		sqs:                sqs,
		csa:                csaClient,
		logger:             logger,
	}
}
