#!/usr/bin/env node
import 'source-map-support/register';
import * as cdk from '@aws-cdk/core';
import { CarrotStreamAnalysisStack } from '../lib/carrot-stream-analysis-stack';
import { CarrotFlvAnalyserStack } from '../lib/carrot-flv-analyser-stack';

const app = new cdk.App();

const stagingBucketName = 'carrot-flv-analyser-recordings-stg';
const prodBucketName = 'carrot-flv-analyser-recordings-prod';

// FLV Analyser
let flvAnalyserStg = new CarrotFlvAnalyserStack(app, 'carrot-flv-analyser-stg', 'vpc-0ba8a2483a591a259', {
  cdkProps: {
    env: {
      region: 'us-west-2',
      account: '134277936734',
    },
  },
  props: {
    recordingAnalysisBucketName: stagingBucketName,
  }
});

let flvAnalyserProd = new CarrotFlvAnalyserStack(app, 'carrot-flv-analyser-prod', 'vpc-094f73121cb30db65', {
  cdkProps: {
    env: {
      region: 'us-west-2',
      account: '782947612856',
    },
    terminationProtection: true,
  },
  props: {
    recordingAnalysisBucketName: prodBucketName,
  }
});

new CarrotStreamAnalysisStack(app, 'carrot-stream-analysis-stg', {
  cdkProps: {
    env: {
      region: 'us-west-2',
      account: '134277936734',
    },
  },
  vpcId: 'vpc-0ba8a2483a591a259',
  csaProps: {
    invokeFunctionRoles: [
      'arn:aws:iam::134277936734:role/carrot-control-stg-CarrotControlServiceRole38F61F3-CUOBT9HTOPF4', // Carrot Control
      'arn:aws:iam::134277936734:role/carrot-rtmp-recorder-api-APIRecorderServiceServic-1EXDGCLAO9PSO' // Carrot RTMP Recorder API (to access recorded file list)
    ],
    streamlogEndpoint: 'http://streamlog-query-prod.elasticbeanstalk.com',
    flvAnalyserBucketName: stagingBucketName,
  }
});

new CarrotStreamAnalysisStack(app, 'carrot-stream-analysis-prod', {
  cdkProps: {
    env: {
      region: 'us-west-2',
      account: '782947612856',
    },
    terminationProtection: true,
  },
  vpcId: 'vpc-094f73121cb30db65',
  csaProps: {
    invokeFunctionRoles: [
      'arn:aws:iam::782947612856:role/carrot-control-prod-CarrotControlServiceRole38F61F-1IQPIF0KPHJF9', // Carrot Control
      'arn:aws:iam::782947612856:role/carrot-rtmp-recorder-api-APIRecorderServiceServic-GINZSDTRREHJ' // Carrot RTMP Recorder (to access recorded file list)
    ],
    streamlogEndpoint: 'http://streamlog-query-prod.elasticbeanstalk.com',
    flvAnalyserBucketName: prodBucketName,
  }
});
