import * as cdk from '@aws-cdk/core';
import * as ec2 from '@aws-cdk/aws-ec2';
import { CarrotFLVAnalyser, CarrotFLVAnalyserProps } from './carrot-flv-analyser/carrot-flv-analyser';

export interface CarrotFlvAnalyserStackProps {
  cdkProps: cdk.StackProps;
  props: CarrotFLVAnalyserProps;
}

export class CarrotFlvAnalyserStack extends cdk.Stack {
  Vpc: ec2.IVpc;
  FLVAnalyser: CarrotFLVAnalyser;

  constructor(scope: cdk.Construct, id: string, vpcId: string, props: CarrotFlvAnalyserStackProps) {
    super(scope, id, props.cdkProps);

    this.Vpc = ec2.Vpc.fromLookup(this, 'VpcRef', { vpcId: vpcId })

    this.FLVAnalyser = new CarrotFLVAnalyser(this, 'FLVAnalyser', this.Vpc, props.props)
  }
}
