import * as cdk from '@aws-cdk/core';
import * as ec2 from '@aws-cdk/aws-ec2';

import { CarrotStreamAnalysis, CSAProps } from './carrot-stream-analysis/carrot-stream-analysis'

export interface CarrotStreamAnalysisProps {
  cdkProps: cdk.StackProps;
  csaProps: CSAProps;
  vpcId: string
}

export class CarrotStreamAnalysisStack extends cdk.Stack {
  constructor(scope: cdk.Construct, id: string, props: CarrotStreamAnalysisProps) {
    super(scope, id, props.cdkProps);

    let vpc = ec2.Vpc.fromLookup(this, 'CarrotVpcRef', {
      vpcId: props.vpcId,
    })

    new CarrotStreamAnalysis(this, 'CarrotStreamAnalysis', vpc, props.csaProps)
  }
}
