package main

import (
	"code.justin.tv/coleiain/isengard-dev-helper/pkg/credentials"
	mi "code.justin.tv/event-engineering/carrot-stream-analysis/pkg/mediainfo"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/s3"
	"github.com/sirupsen/logrus"
)

var (
	awsAccountID = "134277936734" //starfruit-support+carrot-stg@amazon.com
	isengardRole = "Admin"
	awsRegion    = "us-west-2"
	s3Bucket     = "carrot-flv-analyser-recordings-stg"
	s3Key        = "testing/887b9921-04de-44e3-b57b-545dcb7f9bb0_retry.flv"
)

func main() {
	logger := logrus.New()

	credentials, err := credentials.GetIsengardCredentials(awsAccountID, isengardRole)

	if err != nil {
		logger.WithError(err).Fatal("Failed to generate credentials")
	}

	sess := session.New(&aws.Config{
		Region:      aws.String(awsRegion),
		Credentials: credentials,
	})

	s3Client := s3.New(sess)

	mediaInfo := mi.New(s3Bucket, s3Client, logger)

	err = mediaInfo.ExtractMediaInfo(s3Key)
	if err != nil {
		logger.WithError(err).Fatal("Failed to extract media info")
	}
}
