package main

import (
	"context"
	"encoding/json"
	"fmt"
	"time"

	"code.justin.tv/coleiain/isengard-dev-helper/pkg/credentials"
	"code.justin.tv/event-engineering/carrot-stream-analysis/pkg/mmdb"
	csa "code.justin.tv/event-engineering/carrot-stream-analysis/pkg/rpc"
	"code.justin.tv/event-engineering/carrot-stream-analysis/pkg/svc"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/s3"
	"github.com/golang/protobuf/ptypes"
	"github.com/sirupsen/logrus"
)

var (
	awsAccountID = "134277936734" // starfruit-support+carrot-stg@amazon.com
	awsRole      = "Admin"
	awsRegion    = "us-west-2"
)

func main() {
	logger := logrus.New()
	logger.SetLevel(logrus.DebugLevel)

	credentials, err := credentials.GetIsengardCredentials(awsAccountID, awsRole)

	if err != nil {
		panic(err)
	}

	sess := session.New(&aws.Config{
		Credentials: credentials,
		Region:      &awsRegion,
	})

	streamlogEndpoint := "http://streamlog-query-prod.elasticbeanstalk.com"

	// Download the MMDB files using make mmdb
	// This command should be run from the root of the repository
	cityDbPath := "mmdb/GeoIP2-City.mmdb"
	ispDbPath := "mmdb/GeoIP2-ISP.mmdb"

	mmdbClient := mmdb.New(ispDbPath, cityDbPath, logger)

	flvAnalyserBucketName := "carrot-flv-analyser-recordings-stg"
	s3Client := s3.New(sess)

	// Create the Service
	csaServer := svc.New(streamlogEndpoint, mmdbClient, s3Client, flvAnalyserBucketName, logger)

	//doSessionList(csaServer)
	doSessionDetail(csaServer)
}

func doSessionDetail(client svc.Client) {
	// Test your shit
	result, err := client.GetSessionData(context.Background(), &csa.GetSessionDataRequest{
		CustomerId: "twitch",
		ContentId:  "gamesdonequick",
		SessionId:  "56df7dfc-f2d6-4ca4-9979-a30da9ced45f",
	})

	if err != nil {
		panic(err)
	}

	bytes, _ := json.MarshalIndent(result.Session.RtmpSession, "", "  ")
	fmt.Println(string(bytes))
}

func doSessionList(client svc.Client) {
	now := time.Now()

	end, err := ptypes.TimestampProto(now)
	if err != nil {
		panic(err)
	}

	start, err := ptypes.TimestampProto(now.Add(time.Hour * -24 * 14))
	if err != nil {
		panic(err)
	}

	// Test your shit
	result, err := client.GetChannelSessions(context.Background(), &csa.GetChannelSessionsRequest{
		CustomerId: "twitch",
		ContentId:  "gamesdonequick",
		Start:      start,
		End:        end,
	})

	if err != nil {
		panic(err)
	}

	bytes, _ := json.MarshalIndent(result.Sessions, "", "  ")
	fmt.Println(string(bytes))
}
