package main

import (
	"fmt"
	"os"

	"code.justin.tv/amzn/TwirpGoLangAWSTransports/lambda"
	"code.justin.tv/event-engineering/carrot-stream-analysis/pkg/mmdb"
	csa "code.justin.tv/event-engineering/carrot-stream-analysis/pkg/rpc"
	"code.justin.tv/event-engineering/carrot-stream-analysis/pkg/svc"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/s3"
	"github.com/sirupsen/logrus"
)

func main() {
	logger := logrus.New()
	logger.SetLevel(logrus.DebugLevel)

	// Create an AWS session
	sess, err := session.NewSession(&aws.Config{
		Region: aws.String(os.Getenv("AWS_REGION")),
	})

	if err != nil {
		panic(fmt.Errorf("Error creating AWS session %v", err))
	}

	streamlogEndpoint := os.Getenv("streamlogEndpoint")

	// Maybe these should be env variables but the path for these is defined at build time so it's ok no?
	cityDbPath := "mmdb/GeoIP2-City.mmdb"
	ispDbPath := "mmdb/GeoIP2-ISP.mmdb"

	mmdbClient := mmdb.New(ispDbPath, cityDbPath, logger)

	// Access to S3
	flvAnalyserBucketName := os.Getenv("flvAnalyserBucketName")
	s3Client := s3.New(sess)

	// Create the Service
	csaServer := svc.New(streamlogEndpoint, mmdbClient, s3Client, flvAnalyserBucketName, logger)

	// Create a Twirp service based off the internal service
	server := csa.NewCarrotStreamAnalysisServer(csaServer, nil)

	err = lambda.ListenAndServe(":80", server)
	if err != nil {
		// TODO logging and metrics
		panic(err)
	}
}
