package main

import (
	"context"
	"fmt"

	twirpLambda "code.justin.tv/amzn/TwirpGoLangAWSTransports/lambda"
	"code.justin.tv/coleiain/isengard-dev-helper/pkg/credentials"
	csa "code.justin.tv/event-engineering/carrot-stream-analysis/pkg/rpc"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/lambda"
)

var (
	accountID    = "134277936734" //starfruit-support+carrot-stg@amazon.com
	region       = "us-west-2"
	isengardRole = "Admin"
	lambdaARN    = "arn:aws:lambda:us-west-2:134277936734:function:carrot-stream-analysis-st-CarrotStreamAnalysis66AA-GL65ALU6B8B5"
)

func main() {
	credentials, err := credentials.GetIsengardCredentials(accountID, isengardRole)

	if err != nil {
		panic(err)
	}

	sess, err := session.NewSession(&aws.Config{
		Region:      aws.String(region),
		Credentials: credentials,
	})

	if err != nil {
		panic(err)
	}

	lambdaClient := lambda.New(sess)
	lambdaTransport := twirpLambda.NewClient(lambdaClient, lambdaARN)

	client := csa.NewCarrotStreamAnalysisProtobufClient("https://would.you.like.a.carrot.twitch.tv", lambdaTransport)

	resp, err := client.GetCapturedFileDownloadLink(context.Background(), &csa.GetCapturedFileDownloadLinkRequest{
		Key: "captures/009d5cec-669c-47d9-86aa-4f0c5ac136e3/f65c8534-20fe-4afc-ac06-8e32bb85bd54.flv",
	})

	if err != nil {
		fmt.Println(err)
		return
	}

	fmt.Println(resp.DownloadLink)
}
