package encoding

import "encoding/xml"

type MediaTrace struct {
	XMLName xml.Name `xml:"MediaTrace"   json:"-"`
	Media   Media    `xml:"media"        json:"media"`
}

type Media struct {
	XMLName xml.Name `xml:"media"        json:"-"`
	Ref     string   `xml:"ref,attr"     json:"ref"`
	Parser  string   `xml:"parser,attr"  json:"parser"`
	Blocks  []*Block `xml:"block"        json:"blocks,omitempty"`
}

type Block struct {
	XMLName xml.Name `xml:"block"        json:"-"`
	Name    string   `xml:"name,attr"    json:"name,omitempty"`
	Size    string   `xml:"size,attr"    json:"size"`
	Info    string   `xml:"info,attr"    json:"info,omitempty"`
	Info2   string   `xml:"info2,attr"   json:"info2,omitempty"`
	Info3   string   `xml:"info3,attr"   json:"info3,omitempty"`
	Info4   string   `xml:"info4,attr"   json:"info4,omitempty"`
	Info5   string   `xml:"info5,attr"   json:"info5,omitempty"`
	Info6   string   `xml:"info6,attr"   json:"info6,omitempty"`
	Blocks  []*Block `xml:"block"        json:"blocks,omitempty"`
	Data    []*Data  `xml:"data"         json:"data,omitempty"`
}

type Data struct {
	XMLName xml.Name `xml:"data"         json:"-"`
	Name    string   `xml:"name,attr"    json:"name,omitempty"`
	Info    string   `xml:"info,attr"    json:"info,omitempty"`
	Info2   string   `xml:"info2,attr"   json:"info2,omitempty"`
	Value   string   `xml:",chardata"    json:"value,omitempty"`
}

type BasicDetail struct {
	Media *BasicDetailMedia `json:"media"`
}

type BasicDetailMedia struct {
	Ref    string              `json:"@ref"`
	Tracks []*BasicDetailTrack `json:"track"`
}

type BasicDetailTrack struct {
	Type                     string `json:"@type"`
	VideoCount               string `json:"VideoCount"`
	AudioCount               string `json:"AudioCount"`
	FileExtension            string `json:"FileExtension"`
	Format                   string `json:"Format"`
	FormatProfile            string `json:"Format_Profile"`
	FormatLevel              string `json:"Format_Level"`
	FormatSettingsCABAC      string `json:"Format_Settings_CABAC"`
	FormatSettingsSBR        string `json:"Format_Settings_SBR"`
	FormatSettingsRefFrames  string `json:"Format_Settings_RefFrames"`
	FormatAdditionalFeatures string `json:"Format_AdditionalFeatures"`
	FileSize                 string `json:"FileSize"`
	Duration                 string `json:"Duration"`
	OverallBitRate           string `json:"OverallBitRate"`
	FrameCount               string `json:"FrameCount"`
	FileModifiedDate         string `json:"File_Modified_Date"`
	FileModifiedDateLocal    string `json:"File_Modified_Date_Local"`
	CodecID                  string `json:"CodecID"`
	BitRate                  string `json:"BitRate"`
	BitRateNominal           string `json:"BitRate_Nominal"`
	Width                    string `json:"Width"`
	Height                   string `json:"Height"`
	StoredHeight             string `json:"Stored_Height"`
	SampledWidth             string `json:"Sampled_Width"`
	SampledHeight            string `json:"Sampled_Height"`
	PixelAspectRatio         string `json:"PixelAspectRatio"`
	DisplayAspectRatio       string `json:"DisplayAspectRatio"`
	FrameRateMode            string `json:"FrameRate_Mode"`
	FrameRateModeOriginal    string `json:"FrameRate_Mode_Original"`
	FrameRate                string `json:"FrameRate"`
	FrameRateOriginal        string `json:"FrameRate_Original"`
	ColorSpace               string `json:"ColorSpace"`
	ChromaSubsampling        string `json:"ChromaSubsampling"`
	BitDepth                 string `json:"BitDepth"`
	ScanType                 string `json:"ScanType"`
	Delay                    string `json:"Delay"`
	DelaySource              string `json:"Delay_Source"`
	EncodedLibrary           string `json:"Encoded_Library"`
	EncodedLibraryName       string `json:"Encoded_Library_Name"`
	EncodedLibraryVersion    string `json:"Encoded_Library_Version"`
	EncodedLibrarySettings   string `json:"Encoded_Library_Settings"`
	Channels                 string `json:"Channels"`
	ChannelPositions         string `json:"ChannelPositions"`
	ChannelLayout            string `json:"ChannelLayout"`
	SamplesPerFrame          string `json:"SamplesPerFrame"`
	SamplingRate             string `json:"SamplingRate"`
	SamplingCount            string `json:"SamplingCount"`
	CompressionMode          string `json:"Compression_Mode"`
}

type GOPData struct {
	Frames []*Frame `json:"frames"`
}

type Frame struct {
	Timestamp string `json:"timestamp"`
	PictType  string `json:"pict_type"`
	Size      string `json:"size"`
}
